(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    377475,       6133]
NotebookOptionsPosition[    368084,       5950]
NotebookOutlinePosition[    368420,       5965]
CellTagsIndexPosition[    368377,       5962]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Rotate to Natural Impurity Orbitals", "Section",
 CellChangeTimes->{{3.779360344653454*^9, 
  3.779360361530102*^9}},ExpressionUUID->"2b8eb12d-5629-4f5b-a078-\
2b8e5ffa1628"],

Cell["\<\
This notebook rotates a tight binding Hamiltonian to a form where a local \
impurity interacts with either fully occupied or fully empty orbitals and one \
Ligand orbital that allows for the needed charge fluctuations between the \
impurity and the metal. \
\>", "Text",
 CellChangeTimes->{{3.779360364603763*^9, 
  3.779360435171052*^9}},ExpressionUUID->"24d7cc16-da0a-4d49-85f3-\
2851555126e6"],

Cell["\<\
The Notebook uses functions from the Quanty package, which needs to be loaded\
\
\>", "Text",
 CellChangeTimes->{{3.779360437962102*^9, 
  3.7793604647631702`*^9}},ExpressionUUID->"fab746cb-3562-492c-a799-\
c12ca5c45ece"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Quanty`Core`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.779348701223526*^9, 3.779348710477653*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"1ee448e0-9ec8-40e5-a42f-ba0f36b2d1a5"],

Cell[TextData[{
 "We define two functions, the first function does two things. Firstly it \
creates the tight binding Hamiltonian, as used in the tutorials. (You can use \
a different Hamiltonian if wished). Secondly it rotates this Hamiltonian to a \
Natural impurity orbital form. It returns the matrix T and HNat. Whereby ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"T", ".", 
     SuperscriptBox["T", "\[ConjugateTranspose]"]}], "=", "1"}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c2b3766d-9559-47cd-914e-e2c973d8a2d2"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"T", "\[Conjugate]"}], ".", "HBath", ".", 
     RowBox[{"T", "\[Transpose]"}]}], "=", "HNat"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4edd83d2-c592-47dc-aa8f-4b7f7985cbdb"],
 "."
}], "Text",
 CellChangeTimes->{{3.779360437962102*^9, 
  3.779360653838269*^9}},ExpressionUUID->"9d1eca54-2f2f-44e6-b3a3-\
a042115fb6e1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateHNat", "[", 
   RowBox[{"NBath_", ",", "EpsilondIn_", ",", "DigitsUsed_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Epsilond", ",", "H"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Epsilond", "=", 
      RowBox[{"N", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"Round", "[", 
          RowBox[{
           SuperscriptBox["10", "20"], "EpsilondIn"}], "]"}], 
         SuperscriptBox["10", "20"]], ",", "DigitsUsed"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"H", "=", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"SparseArray", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"Band", "[", 
              RowBox[{"{", 
               RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "1"}], ",", 
            RowBox[{
             RowBox[{"Band", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", "1"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"NBath", "+", "1"}], ",", 
            RowBox[{"NBath", "+", "1"}]}], "}"}]}], "]"}], ",", 
        "DigitsUsed"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"H", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "Epsilond"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Chop", "[", 
      RowBox[{"ImpurityMatrixToNaturalImpurityOrbitalBasisNElectron", "[", 
       RowBox[{"H", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"NBath", "+", "1"}], ")"}], "/", "2"}], ",", "1"}], "]"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.7793558240702457`*^9, 3.779355932186913*^9}, 
   3.779356105230267*^9, {3.779358595454638*^9, 3.779358599721479*^9}, {
   3.779358800046001*^9, 3.779358801419313*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"3a5a9429-75fb-48c2-bc6a-7d254eee32ad"],

Cell["\<\
The function CreateImpurityHamiltonian turns the Hamiltonian into a text \
string that can be used as input in the C version of Quanty.\
\>", "Text",
 CellChangeTimes->{{3.779360664519116*^9, 
  3.779360698716219*^9}},ExpressionUUID->"8d0de52b-7de9-4978-bc89-\
86cba72e200f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateImpurityHamiltonian", "[", 
   RowBox[{"NBath_", ",", "Epsilond_", ",", "Ncore_", ",", "DigitsUsed_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"T", ",", "HNat"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"T", ",", "HNat"}], "}"}], "=", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"CreateHNat", "[", 
         RowBox[{"NBath", ",", "Epsilond", ",", "DigitsUsed"}], "]"}], ",", 
        "16"}], "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"\"\<HTB = NewOperator(\\\"Number\\\",NF,\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{
        RowBox[{"StringDrop", "[", 
         RowBox[{
          RowBox[{"ToString", "[", 
           RowBox[{"Transpose", "[", 
            RowBox[{"Ncore", "-", "1", "+", 
             RowBox[{"Join", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"2", 
                 RowBox[{"Drop", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"ArrayRules", "[", "HNat", "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"-", "1"}]}], "]"}]}], "-", "1"}], ",", 
               RowBox[{"2", 
                RowBox[{"Drop", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ArrayRules", "[", "HNat", "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                  RowBox[{"-", "1"}]}], "]"}]}]}], "]"}]}], "]"}], "]"}], ",",
           "1"}], "]"}], ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<,\>\"", "<>", 
      RowBox[{"StringReplace", "[", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{"Drop", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"ArrayRules", "[", "HNat", "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"-", "1"}]}], "]"}], ",", 
           RowBox[{"Drop", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"ArrayRules", "[", "HNat", "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"-", "1"}]}], "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\< I\>\"", "\[Rule]", "\"\<*I\>\""}], ",", 
          RowBox[{"\"\<0. +\>\"", " ", "->", "\"\<\>\""}], ",", 
          RowBox[{"\"\<0. - \>\"", "\[Rule]", "\"\<-\>\""}]}], "}"}]}], "]"}],
       "<>", "\"\<)\>\""}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7793560912970457`*^9, 3.779356155166484*^9}, {
  3.7793562259038897`*^9, 3.7793562358343487`*^9}, {3.779356345648183*^9, 
  3.779356369777896*^9}, {3.779356414246339*^9, 3.7793564521160517`*^9}, {
  3.779356584030097*^9, 3.779356648125978*^9}, {3.7793567424070053`*^9, 
  3.7793567469987583`*^9}, {3.779358756875535*^9, 3.779358757150942*^9}, {
  3.77935919288595*^9, 3.7793591939710417`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"5f27b6dc-ccf0-4d4f-9713-d0dd1b81c199"],

Cell[CellGroupData[{

Cell["NBat = 5    Epsilond = 0", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 
  3.7793592558686867`*^9}},ExpressionUUID->"88437b74-a9c5-43f9-9fec-\
4e344d75dbb4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, 3.779359230885201*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"f3d6a97e-aa14-4831-ba44-c3554e992cd3"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 2, 2, 2, 4, \
4, 4, 4, 6, 6, 8, 8, 8, 8, 10, 10, 1, 1, 1, 3, 3, 3, 5, 5, 5, 5, 7, 7, 9, 9, \
9, 9, 11, 11}, {2, 4, 8, 0, 4, 8, 0, 2, 4, 6, 4, 6, 0, 2, 8, 10, 8, 10, 3, 5, \
9, 1, 5, 9, 1, 3, 5, 7, 5, 7, 1, 3, 9, 11, 9, 11},{0.8711192398635158, \
0.3472400250112380, 0.3472400250112380, 0.8711192398635158, \
-0.3472400250112380, 0.3472400250112380, 0.3472400250112380, \
-0.3472400250112380, -1.133575598779010, 0.3577336521481784, \
0.3577336521481784, -1.489264368792409, 0.3472400250112380, \
0.3472400250112380, 1.133575598779010, 0.3577336521481784, \
0.3577336521481784, 1.489264368792409, 0.8711192398635158, \
0.3472400250112380, 0.3472400250112380, 0.8711192398635158, \
-0.3472400250112380, 0.3472400250112380, 0.3472400250112380, \
-0.3472400250112380, -1.133575598779010, 0.3577336521481784, \
0.3577336521481784, -1.489264368792409, 0.3472400250112380, \
0.3472400250112380, 1.133575598779010, 0.3577336521481784, \
0.3577336521481784, 1.489264368792409})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, {
   3.779359220138113*^9, 3.7793592312112217`*^9}, 3.7793594991073437`*^9, 
   3.779550283480158*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"198e146b-2936-432e-99bc-721e17f89286"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 11    Epsilond = 0", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.7793592558686867`*^9}, {
  3.779550253827518*^9, 
  3.7795502540345907`*^9}},ExpressionUUID->"8e6b12de-568b-4f7e-a3b8-\
9f535636c664"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "11"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, 3.779359230885201*^9, {
   3.7795502943317337`*^9, 3.779550294530637*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"db533497-82d9-4992-ad7e-b0e92d1681a4"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 2, 2, 2, 4, \
4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 14, 14, 14, 14, 16, 16, 16, \
18, 18, 18, 20, 20, 20, 22, 22, 1, 1, 1, 3, 3, 3, 5, 5, 5, 5, 7, 7, 7, 9, 9, \
9, 11, 11, 11, 13, 13, 15, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, 21, 21, \
23, 23}, {2, 4, 14, 0, 4, 14, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, 8, 10, 12, 10, \
12, 0, 2, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, 22, 3, 5, 15, 1, 5, \
15, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, 1, 3, 15, 17, 15, 17, \
19, 17, 19, 21, 19, 21, 23, 21, 23},{-0.8550976851855241, 0.3666114760822132, \
0.3666114760822132, -0.8550976851855241, 0.3666114760822132, \
-0.3666114760822132, 0.3666114760822132, 0.3666114760822132, \
-1.015230218408785, 0.4711704775408612, 0.4711704775408612, \
-1.103069038676347, 0.4209553704382022, 0.4209553704382022, \
-1.224241080048528, 0.3460825268674989, 0.3460825268674989, \
-1.407777364267011, 0.2305702589219096, 0.2305702589219096, \
-1.690814423972560, 0.3666114760822132, -0.3666114760822132, \
1.015230218408785, 0.4711704775408612, 0.4711704775408612, 1.103069038676347, \
0.4209553704382022, 0.4209553704382022, 1.224241080048528, \
0.3460825268674989, 0.3460825268674989, 1.407777364267011, \
0.2305702589219096, 0.2305702589219096, 1.690814423972560, \
-0.8550976851855241, 0.3666114760822132, 0.3666114760822132, \
-0.8550976851855241, 0.3666114760822132, -0.3666114760822132, \
0.3666114760822132, 0.3666114760822132, -1.015230218408785, \
0.4711704775408612, 0.4711704775408612, -1.103069038676347, \
0.4209553704382022, 0.4209553704382022, -1.224241080048528, \
0.3460825268674989, 0.3460825268674989, -1.407777364267011, \
0.2305702589219096, 0.2305702589219096, -1.690814423972560, \
0.3666114760822132, -0.3666114760822132, 1.015230218408785, \
0.4711704775408612, 0.4711704775408612, 1.103069038676347, \
0.4209553704382022, 0.4209553704382022, 1.224241080048528, \
0.3460825268674989, 0.3460825268674989, 1.407777364267011, \
0.2305702589219096, 0.2305702589219096, 1.690814423972560})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, {
   3.779359220138113*^9, 3.7793592312112217`*^9}, 3.7793594991073437`*^9, {
   3.779550290244526*^9, 3.7795502950994587`*^9}},
 CellLabel->"Out[18]=",ExpressionUUID->"17dbf7e6-f34c-4ab0-b602-05924538fb5b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 21    Epsilond = 0", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.7793592558686867`*^9}, {
  3.779550260425435*^9, 
  3.779550260524317*^9}},ExpressionUUID->"71c81e8d-79ff-4356-aff5-\
38189922f9d1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "21"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, 3.779359230885201*^9, {
   3.7795502998501453`*^9, 3.779550299988348*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"9c41c71a-afcd-44cd-92b9-7fdfb452d7d9"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 2, 2, 2, 4, \
4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, 16, \
18, 18, 18, 20, 20, 20, 22, 22, 24, 24, 24, 24, 26, 26, 26, 28, 28, 28, 30, \
30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, 42, \
1, 1, 1, 3, 3, 3, 5, 5, 5, 5, 7, 7, 7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, \
15, 15, 17, 17, 17, 19, 19, 19, 21, 21, 21, 23, 23, 25, 25, 25, 25, 27, 27, \
27, 29, 29, 29, 31, 31, 31, 33, 33, 33, 35, 35, 35, 37, 37, 37, 39, 39, 39, \
41, 41, 41, 43, 43}, {2, 4, 24, 0, 4, 24, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, 8, \
10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, 22, \
0, 2, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, 36, 34, \
36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 3, 5, 25, 1, 5, 25, 1, 3, 5, 7, 5, 7, \
9, 7, 9, 11, 9, 11, 13, 11, 13, 15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, \
21, 23, 21, 23, 1, 3, 25, 27, 25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, \
33, 35, 37, 35, 37, 39, 37, 39, 41, 39, 41, 43, 41, 43},{0.8508135156344978, \
0.3715618129017473, 0.3715618129017473, 0.8508135156344978, \
-0.3715618129017473, 0.3715618129017473, 0.3715618129017473, \
-0.3715618129017473, -0.9863917223894534, 0.4963249202903262, \
0.4963249202903262, -1.024380564774505, 0.4791651511535990, \
0.4791651511535990, -1.060565128580510, 0.4590017663462531, \
0.4590017663462531, -1.106188470311259, 0.4330639709245659, \
0.4330639709245659, -1.164992786960643, 0.3997214526481756, \
0.3997214526481756, -1.240246751069489, 0.3571726949331372, \
0.3571726949331372, -1.335990541136208, 0.3030296550878047, \
0.3030296550878047, -1.457704916849321, 0.2339051214406751, \
0.2339051214406751, -1.613094699843629, 0.1445150150036315, \
0.1445150150036315, -1.813274446037396, 0.3715618129017473, \
0.3715618129017473, 0.9863917223894534, 0.4963249202903262, \
0.4963249202903262, 1.024380564774505, 0.4791651511535990, \
0.4791651511535990, 1.060565128580510, 0.4590017663462531, \
0.4590017663462531, 1.106188470311259, 0.4330639709245659, \
0.4330639709245659, 1.164992786960643, 0.3997214526481756, \
0.3997214526481756, 1.240246751069489, 0.3571726949331372, \
0.3571726949331372, 1.335990541136208, 0.3030296550878047, \
0.3030296550878047, 1.457704916849321, 0.2339051214406751, \
0.2339051214406751, 1.613094699843629, 0.1445150150036315, \
0.1445150150036315, 1.813274446037396, 0.8508135156344978, \
0.3715618129017473, 0.3715618129017473, 0.8508135156344978, \
-0.3715618129017473, 0.3715618129017473, 0.3715618129017473, \
-0.3715618129017473, -0.9863917223894534, 0.4963249202903262, \
0.4963249202903262, -1.024380564774505, 0.4791651511535990, \
0.4791651511535990, -1.060565128580510, 0.4590017663462531, \
0.4590017663462531, -1.106188470311259, 0.4330639709245659, \
0.4330639709245659, -1.164992786960643, 0.3997214526481756, \
0.3997214526481756, -1.240246751069489, 0.3571726949331372, \
0.3571726949331372, -1.335990541136208, 0.3030296550878047, \
0.3030296550878047, -1.457704916849321, 0.2339051214406751, \
0.2339051214406751, -1.613094699843629, 0.1445150150036315, \
0.1445150150036315, -1.813274446037396, 0.3715618129017473, \
0.3715618129017473, 0.9863917223894534, 0.4963249202903262, \
0.4963249202903262, 1.024380564774505, 0.4791651511535990, \
0.4791651511535990, 1.060565128580510, 0.4590017663462531, \
0.4590017663462531, 1.106188470311259, 0.4330639709245659, \
0.4330639709245659, 1.164992786960643, 0.3997214526481756, \
0.3997214526481756, 1.240246751069489, 0.3571726949331372, \
0.3571726949331372, 1.335990541136208, 0.3030296550878047, \
0.3030296550878047, 1.457704916849321, 0.2339051214406751, \
0.2339051214406751, 1.613094699843629, 0.1445150150036315, \
0.1445150150036315, 1.813274446037396})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, {
   3.779359220138113*^9, 3.7793592312112217`*^9}, 3.7793594991073437`*^9, 
   3.779550301165957*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"282dce97-9d4b-4475-89d0-3f7ccb0b8ed0"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 41    Epsilond = 0", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.7793592558686867`*^9}, {
  3.779550272334642*^9, 
  3.779550272488977*^9}},ExpressionUUID->"2d3dfb5a-dace-4290-a63d-\
dd40b5979295"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", "41"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, 3.779359230885201*^9, {
   3.7795503053244753`*^9, 3.779550306714127*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"bb706788-4e2c-42c4-a08a-6fa2cbf9c839"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 2, 2, 2, 4, \
4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, 16, \
18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, 30, \
30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, 42, \
44, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, 54, \
56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, 68, \
68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, 80, \
80, 82, 82, 1, 1, 1, 3, 3, 3, 5, 5, 5, 5, 7, 7, 7, 9, 9, 9, 11, 11, 11, 13, \
13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, 21, 21, 23, 23, 23, 25, 25, \
25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, 33, 35, 35, 35, 37, 37, 37, \
39, 39, 39, 41, 41, 41, 43, 43, 45, 45, 45, 45, 47, 47, 47, 49, 49, 49, 51, \
51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, 59, 59, 61, 61, 61, 63, 63, \
63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, 71, 73, 73, 73, 75, 75, 75, \
77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83}, {2, 4, 44, 0, 4, 44, 0, 2, 4, 6, \
4, 6, 8, 6, 8, 10, 8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, \
18, 20, 22, 20, 22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, \
32, 34, 32, 34, 36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 0, 2, 44, 46, \
44, 46, 48, 46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, \
58, 60, 58, 60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, \
72, 70, 72, 74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 3, 5, \
45, 1, 5, 45, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, 15, 13, 15, \
17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, 25, 27, 29, \
27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, 39, 41, 39, \
41, 43, 41, 43, 1, 3, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, 53, 51, 53, 55, \
53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, 63, 65, 67, 65, \
67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, 77, 79, 77, 79, \
81, 79, 81, 83, 81, 83},{0.8493933400039547, 0.3731829001688891, \
0.3731829001688891, 0.8493933400039547, -0.3731829001688891, \
0.3731829001688891, 0.3731829001688891, -0.3731829001688891, \
-0.9770705006379899, 0.5042767798831333, 0.5042767798831333, \
-1.000064317842622, 0.4965603680836179, 0.4965603680836179, \
-1.013234488124659, 0.4901423447226700, 0.4901423447226700, \
-1.026571239104735, 0.4830115097690691, 0.4830115097690691, \
-1.041998568489590, 0.4746314928588816, 0.4746314928588816, \
-1.060205152697242, 0.4647514290983590, 0.4647514290983590, \
-1.081599105145350, 0.4531895670208550, 0.4531895670208550, \
-1.106526085655485, 0.4397732950884204, 0.4397732950884204, \
-1.135340816454641, 0.4243160198749000, 0.4243160198749000, \
-1.168439526221691, 0.4066046656931699, 0.4066046656931699, \
-1.206280765644405, 0.3863901565540565, 0.3863901565540565, \
-1.249403576770582, 0.3633780301917777, 0.3633780301917777, \
-1.298446803111865, 0.3372177224742490, 0.3372177224742490, \
-1.354171759367345, 0.3074893665170716, 0.3074893665170716, \
-1.417490130249630, 0.2736866955245105, 0.2736866955245105, \
-1.489499152668544, 0.2351935923638701, 0.2351935923638701, \
-1.571526669801396, 0.1912482099764827, 0.1912482099764827, \
-1.665189528340305, 0.1408715308097474, 0.1408715308097474, \
-1.772470122495835, 0.08259715566815579, 0.08259715566815579, \
-1.895817868839552, 0.3731829001688891, 0.3731829001688891, \
0.9770705006379899, 0.5042767798831333, 0.5042767798831333, \
1.000064317842622, 0.4965603680836179, 0.4965603680836179, 1.013234488124659, \
0.4901423447226700, 0.4901423447226700, 1.026571239104735, \
0.4830115097690691, 0.4830115097690691, 1.041998568489590, \
0.4746314928588816, 0.4746314928588816, 1.060205152697242, \
0.4647514290983590, 0.4647514290983590, 1.081599105145350, \
0.4531895670208550, 0.4531895670208550, 1.106526085655485, \
0.4397732950884204, 0.4397732950884204, 1.135340816454641, \
0.4243160198749000, 0.4243160198749000, 1.168439526221691, \
0.4066046656931699, 0.4066046656931699, 1.206280765644405, \
0.3863901565540565, 0.3863901565540565, 1.249403576770582, \
0.3633780301917777, 0.3633780301917777, 1.298446803111865, \
0.3372177224742490, 0.3372177224742490, 1.354171759367345, \
0.3074893665170716, 0.3074893665170716, 1.417490130249630, \
0.2736866955245105, 0.2736866955245105, 1.489499152668544, \
0.2351935923638701, 0.2351935923638701, 1.571526669801396, \
0.1912482099764827, 0.1912482099764827, 1.665189528340305, \
0.1408715308097474, 0.1408715308097474, 1.772470122495835, \
0.08259715566815579, 0.08259715566815579, 1.895817868839552, \
0.8493933400039547, 0.3731829001688891, 0.3731829001688891, \
0.8493933400039547, -0.3731829001688891, 0.3731829001688891, \
0.3731829001688891, -0.3731829001688891, -0.9770705006379899, \
0.5042767798831333, 0.5042767798831333, -1.000064317842622, \
0.4965603680836179, 0.4965603680836179, -1.013234488124659, \
0.4901423447226700, 0.4901423447226700, -1.026571239104735, \
0.4830115097690691, 0.4830115097690691, -1.041998568489590, \
0.4746314928588816, 0.4746314928588816, -1.060205152697242, \
0.4647514290983590, 0.4647514290983590, -1.081599105145350, \
0.4531895670208550, 0.4531895670208550, -1.106526085655485, \
0.4397732950884204, 0.4397732950884204, -1.135340816454641, \
0.4243160198749000, 0.4243160198749000, -1.168439526221691, \
0.4066046656931699, 0.4066046656931699, -1.206280765644405, \
0.3863901565540565, 0.3863901565540565, -1.249403576770582, \
0.3633780301917777, 0.3633780301917777, -1.298446803111865, \
0.3372177224742490, 0.3372177224742490, -1.354171759367345, \
0.3074893665170716, 0.3074893665170716, -1.417490130249630, \
0.2736866955245105, 0.2736866955245105, -1.489499152668544, \
0.2351935923638701, 0.2351935923638701, -1.571526669801396, \
0.1912482099764827, 0.1912482099764827, -1.665189528340305, \
0.1408715308097474, 0.1408715308097474, -1.772470122495835, \
0.08259715566815579, 0.08259715566815579, -1.895817868839552, \
0.3731829001688891, 0.3731829001688891, 0.9770705006379899, \
0.5042767798831333, 0.5042767798831333, 1.000064317842622, \
0.4965603680836179, 0.4965603680836179, 1.013234488124659, \
0.4901423447226700, 0.4901423447226700, 1.026571239104735, \
0.4830115097690691, 0.4830115097690691, 1.041998568489590, \
0.4746314928588816, 0.4746314928588816, 1.060205152697242, \
0.4647514290983590, 0.4647514290983590, 1.081599105145350, \
0.4531895670208550, 0.4531895670208550, 1.106526085655485, \
0.4397732950884204, 0.4397732950884204, 1.135340816454641, \
0.4243160198749000, 0.4243160198749000, 1.168439526221691, \
0.4066046656931699, 0.4066046656931699, 1.206280765644405, \
0.3863901565540565, 0.3863901565540565, 1.249403576770582, \
0.3633780301917777, 0.3633780301917777, 1.298446803111865, \
0.3372177224742490, 0.3372177224742490, 1.354171759367345, \
0.3074893665170716, 0.3074893665170716, 1.417490130249630, \
0.2736866955245105, 0.2736866955245105, 1.489499152668544, \
0.2351935923638701, 0.2351935923638701, 1.571526669801396, \
0.1912482099764827, 0.1912482099764827, 1.665189528340305, \
0.1408715308097474, 0.1408715308097474, 1.772470122495835, \
0.08259715566815579, 0.08259715566815579, 1.895817868839552})\"\>"], "Output",\

 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, {
   3.779359220138113*^9, 3.7793592312112217`*^9}, 3.7793594991073437`*^9, 
   3.779550313636553*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"9521ef2f-120f-4c57-ab40-45164323bbd9"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = 0", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 
  3.7793592709990683`*^9}},ExpressionUUID->"d85708b3-fe01-41a0-8c6e-\
a2c3cce20c69"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
  3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
  3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
  3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
  3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
  3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
  3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
  3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
  3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
  3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
  3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
  3.779359157281836*^9, 3.779359157715231*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"3fee9fdb-44e8-400a-9aee-4f6cc93b90eb"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 2, 2, 2, 4, \
4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, 16, \
18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, 30, \
30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, 42, \
42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, 54, \
56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, 68, \
68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, 80, \
80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, 92, \
94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, 104, \
104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, 114, \
114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, 124, \
124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, 134, \
134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, 144, \
144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, 154, \
154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, 164, \
164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, 174, \
174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, 184, \
184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, 194, \
194, 196, 196, 196, 198, 198, 1, 1, 1, 3, 3, 3, 5, 5, 5, 5, 7, 7, 7, 9, 9, 9, \
11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, 21, 21, 23, \
23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, 33, 35, 35, \
35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, 47, 47, 47, \
49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, 59, 59, 61, \
61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, 71, 73, 73, \
73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, 85, 85, 85, \
87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, 97, 97, 99, \
99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, 107, 109, 109, \
109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, 117, 119, 119, \
119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, 127, 129, 129, \
129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, 137, 139, 139, \
139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, 147, 149, 149, \
149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, 157, 159, 159, \
159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, 167, 169, 169, \
169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, 177, 179, 179, \
179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, 187, 189, 189, \
189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, 197, 199, 199}, \
{2, 4, 102, 0, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, 8, 10, 12, 10, 12, 14, \
12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, 22, 24, 22, 24, 26, 24, \
26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, 36, 34, 36, 38, 36, 38, \
40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, 46, 48, 50, 48, 50, 52, \
50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, 60, 62, 60, 62, 64, 62, \
64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, 74, 72, 74, 76, 74, 76, \
78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, 84, 86, 88, 86, 88, 90, \
88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, 98, 100, 98, 100, 0, 2, \
102, 104, 102, 104, 106, 104, 106, 108, 106, 108, 110, 108, 110, 112, 110, \
112, 114, 112, 114, 116, 114, 116, 118, 116, 118, 120, 118, 120, 122, 120, \
122, 124, 122, 124, 126, 124, 126, 128, 126, 128, 130, 128, 130, 132, 130, \
132, 134, 132, 134, 136, 134, 136, 138, 136, 138, 140, 138, 140, 142, 140, \
142, 144, 142, 144, 146, 144, 146, 148, 146, 148, 150, 148, 150, 152, 150, \
152, 154, 152, 154, 156, 154, 156, 158, 156, 158, 160, 158, 160, 162, 160, \
162, 164, 162, 164, 166, 164, 166, 168, 166, 168, 170, 168, 170, 172, 170, \
172, 174, 172, 174, 176, 174, 176, 178, 176, 178, 180, 178, 180, 182, 180, \
182, 184, 182, 184, 186, 184, 186, 188, 186, 188, 190, 188, 190, 192, 190, \
192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 3, 5, 103, 1, 5, 103, 1, 3, \
5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, 15, 13, 15, 17, 15, 17, 19, 17, \
19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, 25, 27, 29, 27, 29, 31, 29, 31, \
33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, 39, 41, 39, 41, 43, 41, 43, 45, \
43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, 53, 51, 53, 55, 53, 55, 57, 55, \
57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, 63, 65, 67, 65, 67, 69, 67, 69, \
71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, 77, 79, 77, 79, 81, 79, 81, 83, \
81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, 91, 89, 91, 93, 91, 93, 95, 93, \
95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, 3, 103, 105, 103, 105, 107, 105, \
107, 109, 107, 109, 111, 109, 111, 113, 111, 113, 115, 113, 115, 117, 115, \
117, 119, 117, 119, 121, 119, 121, 123, 121, 123, 125, 123, 125, 127, 125, \
127, 129, 127, 129, 131, 129, 131, 133, 131, 133, 135, 133, 135, 137, 135, \
137, 139, 137, 139, 141, 139, 141, 143, 141, 143, 145, 143, 145, 147, 145, \
147, 149, 147, 149, 151, 149, 151, 153, 151, 153, 155, 153, 155, 157, 155, \
157, 159, 157, 159, 161, 159, 161, 163, 161, 163, 165, 163, 165, 167, 165, \
167, 169, 167, 169, 171, 169, 171, 173, 171, 173, 175, 173, 175, 177, 175, \
177, 179, 177, 179, 181, 179, 181, 183, 181, 183, 185, 183, 185, 187, 185, \
187, 189, 187, 189, 191, 189, 191, 193, 191, 193, 195, 193, 195, 197, 195, \
197, 199, 197, 199},{-0.8489290398016424, 0.3737107741164692, \
0.3737107741164692, -0.8489290398016424, 0.3737107741164692, \
-0.3737107741164692, 0.3737107741164692, 0.3737107741164692, \
-0.9740482257320762, 0.5068368984266726, 0.5068368984266726, \
-0.9922931542259100, 0.5020630844692045, 0.5020630844692045, \
-0.9984181150287332, 0.4997594140104044, 0.4997594140104044, \
-1.002317277554051, 0.4979692462624301, 0.4979692462624301, \
-1.005787703753603, 0.4962285205609439, 0.4962285205609439, \
-1.009354784949573, 0.4943778628396333, 0.4943778628396333, \
-1.013223137837993, 0.4923484262750797, 0.4923484262750797, \
-1.017489437291571, 0.4901049259970967, 0.4901049259970967, \
-1.022207163760450, 0.4876263513806559, 0.4876263513806559, \
-1.027410521667359, 0.4848983002345396, 0.4848983002345396, \
-1.033124559410564, 0.4819095529293429, 0.4819095529293429, \
-1.039369917081812, 0.4786503929780709, 0.4786503929780709, \
-1.046165249731204, 0.4751117167825077, 0.4751117167825077, \
-1.053528559146478, 0.4712845268145902, 0.4712845268145902, \
-1.061477978999492, 0.4671596220321726, 0.4671596220321726, \
-1.070032272158246, 0.4627273942463138, 0.4627273942463138, \
-1.079211170794960, 0.4579776830912797, 0.4579776830912797, \
-1.089035628804926, 0.4528996637780211, 0.4528996637780211, \
-1.099528025339815, 0.4474817528829836, 0.4474817528829836, \
-1.110712342127858, 0.4417115233527582, 0.4417115233527582, \
-1.122614328460667, 0.4355756231875203, 0.4355756231875203, \
-1.135261662789283, 0.4290596941304002, 0.4290596941304002, \
-1.148684117040381, 0.4221482877649873, 0.4221482877649873, \
-1.162913728124270, 0.4148247770429612, 0.4148247770429612, \
-1.177984980166640, 0.4070712616109387, 0.4070712616109387, \
-1.193935000482767, 0.3988684654823032, 0.3988684654823032, \
-1.210803772070887, 0.3901956256641870, 0.3901956256641870, \
-1.228634365341495, 0.3810303703349336, 0.3810303703349336, \
-1.247473191869689, 0.3713485850913122, 0.3713485850913122, \
-1.267370283129243, 0.3611242656559930, 0.3611242656559930, \
-1.288379597424376, 0.3503293552559101, 0.3503293552559101, \
-1.310559358571624, 0.3389335646467524, 0.3389335646467524, \
-1.333972430299457, 0.3269041724568382, 0.3269041724568382, \
-1.358686730831517, 0.3142058031346098, 0.3142058031346098, \
-1.384775692708616, 0.3008001792722893, 0.3008001792722893, \
-1.412318773596494, 0.2866458443809318, 0.2866458443809318, \
-1.441402024636008, 0.2716978511938388, 0.2716978511938388, \
-1.472118723838765, 0.2559074090540809, 0.2559074090540809, \
-1.504570083137827, 0.2392214814462007, 0.2392214814462007, \
-1.538866038998353, 0.2215823202854082, 0.2215823202854082, \
-1.575126138011842, 0.2029269149163467, 0.2029269149163467, \
-1.613480530681994, 0.1831863152179508, 0.1831863152179508, \
-1.654071088711601, 0.1622847440932148, 0.1622847440932148, \
-1.697052663580693, 0.1401382963804420, 0.1401382963804420, \
-1.742594507142841, 0.1166526540358445, 0.1166526540358445, \
-1.790881878452591, 0.09171786023148453, 0.09171786023148453, \
-1.842117865187462, 0.06519119401934156, 0.06519119401934156, \
-1.896525452984524, 0.03680013143341261, 0.03680013143341261, \
-1.954349881949963, 0.3737107741164692, -0.3737107741164692, \
0.9740482257320762, 0.5068368984266726, 0.5068368984266726, \
0.9922931542259100, 0.5020630844692045, 0.5020630844692045, \
0.9984181150287332, 0.4997594140104044, 0.4997594140104044, \
1.002317277554051, 0.4979692462624301, 0.4979692462624301, 1.005787703753603, \
0.4962285205609439, 0.4962285205609439, 1.009354784949573, \
0.4943778628396333, 0.4943778628396333, 1.013223137837993, \
0.4923484262750797, 0.4923484262750797, 1.017489437291571, \
0.4901049259970967, 0.4901049259970967, 1.022207163760450, \
0.4876263513806559, 0.4876263513806559, 1.027410521667359, \
0.4848983002345396, 0.4848983002345396, 1.033124559410564, \
0.4819095529293429, 0.4819095529293429, 1.039369917081812, \
0.4786503929780709, 0.4786503929780709, 1.046165249731204, \
0.4751117167825077, 0.4751117167825077, 1.053528559146478, \
0.4712845268145902, 0.4712845268145902, 1.061477978999492, \
0.4671596220321726, 0.4671596220321726, 1.070032272158246, \
0.4627273942463138, 0.4627273942463138, 1.079211170794960, \
0.4579776830912797, 0.4579776830912797, 1.089035628804926, \
0.4528996637780211, 0.4528996637780211, 1.099528025339815, \
0.4474817528829836, 0.4474817528829836, 1.110712342127858, \
0.4417115233527582, 0.4417115233527582, 1.122614328460667, \
0.4355756231875203, 0.4355756231875203, 1.135261662789283, \
0.4290596941304002, 0.4290596941304002, 1.148684117040381, \
0.4221482877649873, 0.4221482877649873, 1.162913728124270, \
0.4148247770429612, 0.4148247770429612, 1.177984980166640, \
0.4070712616109387, 0.4070712616109387, 1.193935000482767, \
0.3988684654823032, 0.3988684654823032, 1.210803772070887, \
0.3901956256641870, 0.3901956256641870, 1.228634365341495, \
0.3810303703349336, 0.3810303703349336, 1.247473191869689, \
0.3713485850913122, 0.3713485850913122, 1.267370283129243, \
0.3611242656559930, 0.3611242656559930, 1.288379597424376, \
0.3503293552559101, 0.3503293552559101, 1.310559358571624, \
0.3389335646467524, 0.3389335646467524, 1.333972430299457, \
0.3269041724568382, 0.3269041724568382, 1.358686730831517, \
0.3142058031346098, 0.3142058031346098, 1.384775692708616, \
0.3008001792722893, 0.3008001792722893, 1.412318773596494, \
0.2866458443809318, 0.2866458443809318, 1.441402024636008, \
0.2716978511938388, 0.2716978511938388, 1.472118723838765, \
0.2559074090540809, 0.2559074090540809, 1.504570083137827, \
0.2392214814462007, 0.2392214814462007, 1.538866038998353, \
0.2215823202854082, 0.2215823202854082, 1.575126138011842, \
0.2029269149163467, 0.2029269149163467, 1.613480530681994, \
0.1831863152179508, 0.1831863152179508, 1.654071088711601, \
0.1622847440932148, 0.1622847440932148, 1.697052663580693, \
0.1401382963804420, 0.1401382963804420, 1.742594507142841, \
0.1166526540358445, 0.1166526540358445, 1.790881878452591, \
0.09171786023148453, 0.09171786023148453, 1.842117865187462, \
0.06519119401934156, 0.06519119401934156, 1.896525452984524, \
0.03680013143341261, 0.03680013143341261, 1.954349881949963, \
-0.8489290398016424, 0.3737107741164692, 0.3737107741164692, \
-0.8489290398016424, 0.3737107741164692, -0.3737107741164692, \
0.3737107741164692, 0.3737107741164692, -0.9740482257320762, \
0.5068368984266726, 0.5068368984266726, -0.9922931542259100, \
0.5020630844692045, 0.5020630844692045, -0.9984181150287332, \
0.4997594140104044, 0.4997594140104044, -1.002317277554051, \
0.4979692462624301, 0.4979692462624301, -1.005787703753603, \
0.4962285205609439, 0.4962285205609439, -1.009354784949573, \
0.4943778628396333, 0.4943778628396333, -1.013223137837993, \
0.4923484262750797, 0.4923484262750797, -1.017489437291571, \
0.4901049259970967, 0.4901049259970967, -1.022207163760450, \
0.4876263513806559, 0.4876263513806559, -1.027410521667359, \
0.4848983002345396, 0.4848983002345396, -1.033124559410564, \
0.4819095529293429, 0.4819095529293429, -1.039369917081812, \
0.4786503929780709, 0.4786503929780709, -1.046165249731204, \
0.4751117167825077, 0.4751117167825077, -1.053528559146478, \
0.4712845268145902, 0.4712845268145902, -1.061477978999492, \
0.4671596220321726, 0.4671596220321726, -1.070032272158246, \
0.4627273942463138, 0.4627273942463138, -1.079211170794960, \
0.4579776830912797, 0.4579776830912797, -1.089035628804926, \
0.4528996637780211, 0.4528996637780211, -1.099528025339815, \
0.4474817528829836, 0.4474817528829836, -1.110712342127858, \
0.4417115233527582, 0.4417115233527582, -1.122614328460667, \
0.4355756231875203, 0.4355756231875203, -1.135261662789283, \
0.4290596941304002, 0.4290596941304002, -1.148684117040381, \
0.4221482877649873, 0.4221482877649873, -1.162913728124270, \
0.4148247770429612, 0.4148247770429612, -1.177984980166640, \
0.4070712616109387, 0.4070712616109387, -1.193935000482767, \
0.3988684654823032, 0.3988684654823032, -1.210803772070887, \
0.3901956256641870, 0.3901956256641870, -1.228634365341495, \
0.3810303703349336, 0.3810303703349336, -1.247473191869689, \
0.3713485850913122, 0.3713485850913122, -1.267370283129243, \
0.3611242656559930, 0.3611242656559930, -1.288379597424376, \
0.3503293552559101, 0.3503293552559101, -1.310559358571624, \
0.3389335646467524, 0.3389335646467524, -1.333972430299457, \
0.3269041724568382, 0.3269041724568382, -1.358686730831517, \
0.3142058031346098, 0.3142058031346098, -1.384775692708616, \
0.3008001792722893, 0.3008001792722893, -1.412318773596494, \
0.2866458443809318, 0.2866458443809318, -1.441402024636008, \
0.2716978511938388, 0.2716978511938388, -1.472118723838765, \
0.2559074090540809, 0.2559074090540809, -1.504570083137827, \
0.2392214814462007, 0.2392214814462007, -1.538866038998353, \
0.2215823202854082, 0.2215823202854082, -1.575126138011842, \
0.2029269149163467, 0.2029269149163467, -1.613480530681994, \
0.1831863152179508, 0.1831863152179508, -1.654071088711601, \
0.1622847440932148, 0.1622847440932148, -1.697052663580693, \
0.1401382963804420, 0.1401382963804420, -1.742594507142841, \
0.1166526540358445, 0.1166526540358445, -1.790881878452591, \
0.09171786023148453, 0.09171786023148453, -1.842117865187462, \
0.06519119401934156, 0.06519119401934156, -1.896525452984524, \
0.03680013143341261, 0.03680013143341261, -1.954349881949963, \
0.3737107741164692, -0.3737107741164692, 0.9740482257320762, \
0.5068368984266726, 0.5068368984266726, 0.9922931542259100, \
0.5020630844692045, 0.5020630844692045, 0.9984181150287332, \
0.4997594140104044, 0.4997594140104044, 1.002317277554051, \
0.4979692462624301, 0.4979692462624301, 1.005787703753603, \
0.4962285205609439, 0.4962285205609439, 1.009354784949573, \
0.4943778628396333, 0.4943778628396333, 1.013223137837993, \
0.4923484262750797, 0.4923484262750797, 1.017489437291571, \
0.4901049259970967, 0.4901049259970967, 1.022207163760450, \
0.4876263513806559, 0.4876263513806559, 1.027410521667359, \
0.4848983002345396, 0.4848983002345396, 1.033124559410564, \
0.4819095529293429, 0.4819095529293429, 1.039369917081812, \
0.4786503929780709, 0.4786503929780709, 1.046165249731204, \
0.4751117167825077, 0.4751117167825077, 1.053528559146478, \
0.4712845268145902, 0.4712845268145902, 1.061477978999492, \
0.4671596220321726, 0.4671596220321726, 1.070032272158246, \
0.4627273942463138, 0.4627273942463138, 1.079211170794960, \
0.4579776830912797, 0.4579776830912797, 1.089035628804926, \
0.4528996637780211, 0.4528996637780211, 1.099528025339815, \
0.4474817528829836, 0.4474817528829836, 1.110712342127858, \
0.4417115233527582, 0.4417115233527582, 1.122614328460667, \
0.4355756231875203, 0.4355756231875203, 1.135261662789283, \
0.4290596941304002, 0.4290596941304002, 1.148684117040381, \
0.4221482877649873, 0.4221482877649873, 1.162913728124270, \
0.4148247770429612, 0.4148247770429612, 1.177984980166640, \
0.4070712616109387, 0.4070712616109387, 1.193935000482767, \
0.3988684654823032, 0.3988684654823032, 1.210803772070887, \
0.3901956256641870, 0.3901956256641870, 1.228634365341495, \
0.3810303703349336, 0.3810303703349336, 1.247473191869689, \
0.3713485850913122, 0.3713485850913122, 1.267370283129243, \
0.3611242656559930, 0.3611242656559930, 1.288379597424376, \
0.3503293552559101, 0.3503293552559101, 1.310559358571624, \
0.3389335646467524, 0.3389335646467524, 1.333972430299457, \
0.3269041724568382, 0.3269041724568382, 1.358686730831517, \
0.3142058031346098, 0.3142058031346098, 1.384775692708616, \
0.3008001792722893, 0.3008001792722893, 1.412318773596494, \
0.2866458443809318, 0.2866458443809318, 1.441402024636008, \
0.2716978511938388, 0.2716978511938388, 1.472118723838765, \
0.2559074090540809, 0.2559074090540809, 1.504570083137827, \
0.2392214814462007, 0.2392214814462007, 1.538866038998353, \
0.2215823202854082, 0.2215823202854082, 1.575126138011842, \
0.2029269149163467, 0.2029269149163467, 1.613480530681994, \
0.1831863152179508, 0.1831863152179508, 1.654071088711601, \
0.1622847440932148, 0.1622847440932148, 1.697052663580693, \
0.1401382963804420, 0.1401382963804420, 1.742594507142841, \
0.1166526540358445, 0.1166526540358445, 1.790881878452591, \
0.09171786023148453, 0.09171786023148453, 1.842117865187462, \
0.06519119401934156, 0.06519119401934156, 1.896525452984524, \
0.03680013143341261, 0.03680013143341261, 1.954349881949963})\"\>"], "Output",\

 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.779359567962748*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"b255ec70-5281-450e-b1ac-2b12a146ec3b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -0.1", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 
  3.779359280778961*^9}},ExpressionUUID->"b4d2f851-cedd-460e-b4c6-\
3b50dae401b8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "0.1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
  3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
  3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
  3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
  3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
  3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
  3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
  3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
  3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
  3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
  3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
  3.779359157281836*^9, 3.779359157715231*^9}, {3.779359285341239*^9, 
  3.779359286580131*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"5917ceb5-6449-4f59-bb2e-faa704c96178"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-0.1000000000000000, \
-0.8486268134923375, 0.3911917177063634, 0.3560920827816679, \
-0.8486268134923375, 0.04189306482739880, 0.3598521591984161, \
-0.3871041758795993, 0.3911917177063634, 0.3598521591984161, \
-0.9726625540524699, 0.5068272776574746, 0.5068272776574746, \
-0.9927818958664074, 0.5017267996458744, 0.5017267996458744, \
-0.9991717274984014, 0.4993634541108944, 0.4993634541108944, \
-1.003127075850371, 0.4975607823662244, 0.4975607823662244, \
-1.006605634648950, 0.4958208957639075, 0.4958208957639075, \
-1.010165043166751, 0.4939759812407619, 0.4939759812407619, \
-1.014019417626565, 0.4919543668910539, 0.4919543668910539, \
-1.018268947296093, 0.4897196350176636, 0.4897196350176636, \
-1.022968618108318, 0.4872502622235643, 0.4872502622235643, \
-1.028153348154137, 0.4845315936290917, 0.4845315936290917, \
-1.033848549040304, 0.4815522775802228, 0.4815522775802228, \
-1.040075054565505, 0.4783025261340892, 0.4783025261340892, \
-1.046851625515563, 0.4747731966364653, 0.4747731966364653, \
-1.054196321042753, 0.4709552707737492, 0.4709552707737492, \
-1.062127304264578, 0.4668395374940846, 0.4668395374940846, \
-1.070663350692029, 0.4624163852090910, 0.4624163852090910, \
-1.079824194644088, 0.4576756543558384, 0.4576756543558384, \
-1.089630785375496, 0.4526065237117425, 0.4526065237117425, \
-1.100105492857546, 0.4471974153004692, 0.4471974153004692, \
-1.111272286493254, 0.4414359088432781, 0.4414359088432781, \
-1.123156900985428, 0.4353086600908270, 0.4353086600908270, \
-1.135786998494976, 0.4288013192879317, 0.4288013192879317, \
-1.149192333315638, 0.4218984471287307, 0.4218984471287307, \
-1.163404923606736, 0.4145834261967719, 0.4145834261967719, \
-1.178459233759283, 0.4068383662419040, 0.4068383662419040, \
-1.194392370441593, 0.3986440018287837, 0.3986440018287837, \
-1.211244295118692, 0.3899795809601209, 0.3899795809601209, \
-1.229058055773637, 0.3808227432654273, 0.3808227432654273, \
-1.247880040625211, 0.3711493862716211, 0.3711493862716211, \
-1.267760256805389, 0.3609335181441707, 0.3609335181441707, \
-1.288752637215409, 0.3501470951083455, 0.3501470951083455, \
-1.310915379114489, 0.3387598415253161, 0.3387598415253161, \
-1.334311318409517, 0.3267390502962901, 0.3267390502962901, \
-1.359008344111589, 0.3140493608792163, 0.3140493608792163, \
-1.385079858013941, 0.3006525116912372, 0.3006525116912372, \
-1.412605285337208, 0.2865070629731320, 0.2865070629731320, \
-1.441670642897148, 0.2715680851941710, 0.2715680851941710, \
-1.472369172295875, 0.2557868065552316, 0.2557868065552316, \
-1.504802046743797, 0.2391102106533626, 0.2391102106533626, \
-1.539079161414219, 0.2214805709260281, 0.2214805709260281, \
-1.575320018750804, 0.2028348998355460, 0.2028348998355460, \
-1.613654721931849, 0.1831042722062629, 0.1831042722062629, \
-1.654225091796020, 0.1622129380274079, 0.1622129380274079, \
-1.697185925014169, 0.1400770218409753, 0.1400770218409753, \
-1.742706414227617, 0.1166022387986051, 0.1166022387986051, \
-1.790971754358198, 0.09167867083760742, 0.09167867083760742, \
-1.842184963444482, 0.06516364832095791, 0.06516364832095791, \
-1.896568951313641, 0.03678475107186927, 0.03678475107186927, \
-1.954368875334836, 0.3560920827816679, -0.3871041758795993, \
0.9751014273929654, 0.5069108888079694, 0.5069108888079694, \
0.9917426502324176, 0.5024173380943798, 0.5024173380943798, \
0.9976399411721026, 0.5001648751171952, 0.5001648751171952, \
1.001491337318501, 0.4983850396522329, 0.4983850396522329, 1.004955834175096, \
0.4966429761175443, 0.4966429761175443, 1.008530874364786, \
0.4947866487786690, 0.4947866487786690, 1.012412790379905, \
0.4927496808220424, 0.4927496808220424, 1.016695177021387, \
0.4904977825374985, 0.4904977825374985, 1.021430189063255, \
0.4880103959602936, 0.4880103959602936, 1.026651399214740, \
0.4852733432437651, 0.4852733432437651, 1.032383532307806, \
0.4822755228343942, 0.4822755228343942, 1.038647054402430, \
0.4790072827890102, 0.4790072827890102, 1.045460524425642, \
0.4754595552936335, 0.4754595552936335, 1.052841891091189, \
0.4716233622946716, 0.4716233622946716, 1.060809260008196, \
0.4674895125306233, 0.4674895125306233, 1.069381381171226, \
0.4630484015833467, 0.4630484015833467, 1.078577983485714, \
0.4582898689818083, 0.4582898689818083, 1.088420023897039, \
0.4532030872329016, 0.4532030872329016, 1.098929888926101, \
0.4477764683958903, 0.4477764683958903, 1.110131570746851, \
0.4419975795804641, 0.4419975795804641, 1.122050831386477, \
0.4358530619443249, 0.4358530619443249, 1.134715363818784, \
0.4293285495834165, 0.4293285495834165, 1.148154955959820, \
0.4224085857565757, 0.4224085857565757, 1.162401661975509, \
0.4150765344908940, 0.4150765344908940, 1.177489984394870, \
0.4073144859520950, 0.4073144859520950, 1.193457070023279, \
0.3991031541353686, 0.3991031541353686, 1.210342922416991, \
0.3904217654930433, 0.3904217654930433, 1.228190633625665, \
0.3812479370984139, 0.3812479370984139, 1.247046637983614, \
0.3715575428675332, 0.3715575428675332, 1.266960990904414, \
0.3613245662310192, 0.3613245662310192, 1.287987675892425, \
0.3505209374673577, 0.3505209374673577, 1.310184943322371, \
0.3391163536732775, 0.3391163536732775, 1.333615684954206, \
0.3270780790443867, 0.3270780790443867, 1.358347848649399, \
0.3143707227498901, 0.3143707227498901, 1.384454898344558, \
0.3009559911731716, 0.3009559911731716, 1.412016325030692, \
0.2867924105923442, 0.2867924105923442, 1.441118215296501, \
0.2718350153761291, 0.2718350153761291, 1.471853884940914, \
0.2560349952485322, 0.2560349952485322, 1.504324586267143, \
0.2393392926790285, 0.2393392926790285, 1.538640298966328, \
0.2216901370062874, 0.2216901370062874, 1.574920616018160, \
0.2030244932384817, 0.2030244932384817, 1.613295737820946, \
0.1832733849095798, 0.1832733849095798, 1.653907589865664, \
0.1623610062340038, 0.1623610062340038, 1.696911081750288, \
0.1402034205078917, 0.1402034205078917, 1.742475528268365, \
0.1167062743571035, 0.1167062743571035, 1.790786256793104, \
0.09175956961611741, 0.09175956961611741, 1.842046429330133, \
0.06522053054872843, 0.06522053054872843, 1.896479112570412, \
0.03681652235724314, 0.03681652235724314, 1.954329635215190, \
-0.1000000000000000, -0.8486268134923375, 0.3911917177063634, \
0.3560920827816679, -0.8486268134923375, 0.04189306482739880, \
0.3598521591984161, -0.3871041758795993, 0.3911917177063634, \
0.3598521591984161, -0.9726625540524699, 0.5068272776574746, \
0.5068272776574746, -0.9927818958664074, 0.5017267996458744, \
0.5017267996458744, -0.9991717274984014, 0.4993634541108944, \
0.4993634541108944, -1.003127075850371, 0.4975607823662244, \
0.4975607823662244, -1.006605634648950, 0.4958208957639075, \
0.4958208957639075, -1.010165043166751, 0.4939759812407619, \
0.4939759812407619, -1.014019417626565, 0.4919543668910539, \
0.4919543668910539, -1.018268947296093, 0.4897196350176636, \
0.4897196350176636, -1.022968618108318, 0.4872502622235643, \
0.4872502622235643, -1.028153348154137, 0.4845315936290917, \
0.4845315936290917, -1.033848549040304, 0.4815522775802228, \
0.4815522775802228, -1.040075054565505, 0.4783025261340892, \
0.4783025261340892, -1.046851625515563, 0.4747731966364653, \
0.4747731966364653, -1.054196321042753, 0.4709552707737492, \
0.4709552707737492, -1.062127304264578, 0.4668395374940846, \
0.4668395374940846, -1.070663350692029, 0.4624163852090910, \
0.4624163852090910, -1.079824194644088, 0.4576756543558384, \
0.4576756543558384, -1.089630785375496, 0.4526065237117425, \
0.4526065237117425, -1.100105492857546, 0.4471974153004692, \
0.4471974153004692, -1.111272286493254, 0.4414359088432781, \
0.4414359088432781, -1.123156900985428, 0.4353086600908270, \
0.4353086600908270, -1.135786998494976, 0.4288013192879317, \
0.4288013192879317, -1.149192333315638, 0.4218984471287307, \
0.4218984471287307, -1.163404923606736, 0.4145834261967719, \
0.4145834261967719, -1.178459233759283, 0.4068383662419040, \
0.4068383662419040, -1.194392370441593, 0.3986440018287837, \
0.3986440018287837, -1.211244295118692, 0.3899795809601209, \
0.3899795809601209, -1.229058055773637, 0.3808227432654273, \
0.3808227432654273, -1.247880040625211, 0.3711493862716211, \
0.3711493862716211, -1.267760256805389, 0.3609335181441707, \
0.3609335181441707, -1.288752637215409, 0.3501470951083455, \
0.3501470951083455, -1.310915379114489, 0.3387598415253161, \
0.3387598415253161, -1.334311318409517, 0.3267390502962901, \
0.3267390502962901, -1.359008344111589, 0.3140493608792163, \
0.3140493608792163, -1.385079858013941, 0.3006525116912372, \
0.3006525116912372, -1.412605285337208, 0.2865070629731320, \
0.2865070629731320, -1.441670642897148, 0.2715680851941710, \
0.2715680851941710, -1.472369172295875, 0.2557868065552316, \
0.2557868065552316, -1.504802046743797, 0.2391102106533626, \
0.2391102106533626, -1.539079161414219, 0.2214805709260281, \
0.2214805709260281, -1.575320018750804, 0.2028348998355460, \
0.2028348998355460, -1.613654721931849, 0.1831042722062629, \
0.1831042722062629, -1.654225091796020, 0.1622129380274079, \
0.1622129380274079, -1.697185925014169, 0.1400770218409753, \
0.1400770218409753, -1.742706414227617, 0.1166022387986051, \
0.1166022387986051, -1.790971754358198, 0.09167867083760742, \
0.09167867083760742, -1.842184963444482, 0.06516364832095791, \
0.06516364832095791, -1.896568951313641, 0.03678475107186927, \
0.03678475107186927, -1.954368875334836, 0.3560920827816679, \
-0.3871041758795993, 0.9751014273929654, 0.5069108888079694, \
0.5069108888079694, 0.9917426502324176, 0.5024173380943798, \
0.5024173380943798, 0.9976399411721026, 0.5001648751171952, \
0.5001648751171952, 1.001491337318501, 0.4983850396522329, \
0.4983850396522329, 1.004955834175096, 0.4966429761175443, \
0.4966429761175443, 1.008530874364786, 0.4947866487786690, \
0.4947866487786690, 1.012412790379905, 0.4927496808220424, \
0.4927496808220424, 1.016695177021387, 0.4904977825374985, \
0.4904977825374985, 1.021430189063255, 0.4880103959602936, \
0.4880103959602936, 1.026651399214740, 0.4852733432437651, \
0.4852733432437651, 1.032383532307806, 0.4822755228343942, \
0.4822755228343942, 1.038647054402430, 0.4790072827890102, \
0.4790072827890102, 1.045460524425642, 0.4754595552936335, \
0.4754595552936335, 1.052841891091189, 0.4716233622946716, \
0.4716233622946716, 1.060809260008196, 0.4674895125306233, \
0.4674895125306233, 1.069381381171226, 0.4630484015833467, \
0.4630484015833467, 1.078577983485714, 0.4582898689818083, \
0.4582898689818083, 1.088420023897039, 0.4532030872329016, \
0.4532030872329016, 1.098929888926101, 0.4477764683958903, \
0.4477764683958903, 1.110131570746851, 0.4419975795804641, \
0.4419975795804641, 1.122050831386477, 0.4358530619443249, \
0.4358530619443249, 1.134715363818784, 0.4293285495834165, \
0.4293285495834165, 1.148154955959820, 0.4224085857565757, \
0.4224085857565757, 1.162401661975509, 0.4150765344908940, \
0.4150765344908940, 1.177489984394870, 0.4073144859520950, \
0.4073144859520950, 1.193457070023279, 0.3991031541353686, \
0.3991031541353686, 1.210342922416991, 0.3904217654930433, \
0.3904217654930433, 1.228190633625665, 0.3812479370984139, \
0.3812479370984139, 1.247046637983614, 0.3715575428675332, \
0.3715575428675332, 1.266960990904414, 0.3613245662310192, \
0.3613245662310192, 1.287987675892425, 0.3505209374673577, \
0.3505209374673577, 1.310184943322371, 0.3391163536732775, \
0.3391163536732775, 1.333615684954206, 0.3270780790443867, \
0.3270780790443867, 1.358347848649399, 0.3143707227498901, \
0.3143707227498901, 1.384454898344558, 0.3009559911731716, \
0.3009559911731716, 1.412016325030692, 0.2867924105923442, \
0.2867924105923442, 1.441118215296501, 0.2718350153761291, \
0.2718350153761291, 1.471853884940914, 0.2560349952485322, \
0.2560349952485322, 1.504324586267143, 0.2393392926790285, \
0.2393392926790285, 1.538640298966328, 0.2216901370062874, \
0.2216901370062874, 1.574920616018160, 0.2030244932384817, \
0.2030244932384817, 1.613295737820946, 0.1832733849095798, \
0.1832733849095798, 1.653907589865664, 0.1623610062340038, \
0.1623610062340038, 1.696911081750288, 0.1402034205078917, \
0.1402034205078917, 1.742475528268365, 0.1167062743571035, \
0.1167062743571035, 1.790786256793104, 0.09175956961611741, \
0.09175956961611741, 1.842046429330133, 0.06522053054872843, \
0.06522053054872843, 1.896479112570412, 0.03681652235724314, \
0.03681652235724314, 1.954329635215190})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.7793596352904263`*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"fdc3d5f5-8772-435d-befc-d598a9044008"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -0.2", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.779359280778961*^9}, {
  3.779359374379603*^9, 
  3.779359374478294*^9}},ExpressionUUID->"a08b710a-e53b-464a-bb92-\
6d5254e6117e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "0.2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, {3.779359285341239*^9, 
   3.779359286580131*^9}, 3.779359476076146*^9},
 CellLabel->"In[19]:=",ExpressionUUID->"6eaa768e-9e23-47a6-858d-1662f056e4cf"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-0.2000000000000000, \
-0.8477365191342075, 0.4082848750988253, 0.3385945287386583, \
-0.8477365191342075, 0.08318324767941748, 0.3457475833377311, \
-0.3998380076605509, 0.4082848750988253, 0.3457475833377311, \
-0.9709554782348285, 0.5068837098037012, 0.5068837098037012, \
-0.9931999591652705, 0.5014141989686101, 0.5014141989686101, \
-0.9998881166579462, 0.4989836270984772, 0.4989836270984772, \
-1.003907206526034, 0.4971664446057500, 0.4971664446057500, \
-1.007396083701518, 0.4954268113056033, 0.4954268113056033, \
-1.010948401254801, 0.4935875265259980, 0.4935875265259980, \
-1.014788807649293, 0.4915737953779486, 0.4915737953779486, \
-1.019021366702992, 0.4893479544396159, 0.4893479544396159, \
-1.023702715701937, 0.4868879193039980, 0.4868879193039980, \
-1.028868551431912, 0.4841787601856619, 0.4841787601856619, \
-1.034544679363690, 0.4812089827869092, 0.4812089827869092, \
-1.040752141702349, 0.4779687226657872, 0.4779687226657872, \
-1.047509811766032, 0.4744487959004522, 0.4744487959004522, \
-1.054835808772183, 0.4706401626709804, 0.4706401626709804, \
-1.062748325804639, 0.4665336019927072, 0.4665336019927072, \
-1.071266150372880, 0.4621194993772110, 0.4621194993772110, \
-1.080409017693113, 0.4573876967754807, 0.4573876967754807, \
-1.090197870844611, 0.4523273773322582, 0.4523273773322582, \
-1.100655068985233, 0.4469269693368470, 0.4469269693368470, \
-1.111804567573385, 0.4411740600777258, 0.4411740600777258, \
-1.123672085184967, 0.4350553137963415, 0.4350553137963415, \
-1.136285266275123, 0.4285563899111730, 0.4285563899111730, \
-1.149673846236632, 0.4216618588207538, 0.4216618588207538, \
-1.163869823372660, 0.4143551132502623, 0.4143551132502623, \
-1.178907641406510, 0.4066182734748335, 0.4066182734748335, \
-1.194824385604308, 0.3984320849424846, 0.3984320849424846, \
-1.211659995324089, 0.3897758068920915, 0.3897758068920915, \
-1.229457495731759, 0.3806270905522059, 0.3806270905522059, \
-1.248263251486477, 0.3709618454338489, 0.3709618454338489, \
-1.268127245363986, 0.3607540921039345, 0.3607540921039345, \
-1.289103385040013, 0.3499757996476757, 0.3499757996476757, \
-1.311249841589622, 0.3385967057940934, 0.3385967057940934, \
-1.334629423671811, 0.3265841173776356, 0.3265841173776356, \
-1.359309991865351, 0.3139026884206379, 0.3139026884206379, \
-1.385364918210060, 0.3005141726103371, 0.3005141726103371, \
-1.412873596698510, 0.2863771462475716, 0.2863771462475716, \
-1.441922011271974, 0.2714466967469119, 0.2714466967469119, \
-1.472603368819903, 0.2556740702479912, 0.2556740702479912, \
-1.505018805787894, 0.2390062694040945, 0.2390062694040945, \
-1.539278178293477, 0.2213855879707796, 0.2213855879707796, \
-1.575500947166728, 0.2027490601628584, 0.2027490601628584, \
-1.613817171115958, 0.1830277842071292, 0.1830277842071292, \
-1.654368623318704, 0.1621460354354560, 0.1621460354354560, \
-1.697310049217566, 0.1400199661143751, 0.1400199661143751, \
-1.742810586235216, 0.1165553223125093, 0.1165553223125093, \
-1.791055369606869, 0.09164222200436628, 0.09164222200436628, \
-1.842247352676357, 0.06513804318504389, 0.06513804318504389, \
-1.896609374955528, 0.03677046197767251, 0.03677046197767251, \
-1.954386517181403, 0.3385945287386583, -0.3998380076605509, \
0.9758316090231906, 0.5070433376790490, 0.5070433376790490, \
0.9911436239312552, 0.5027825233480839, 0.5027825233480839, \
0.9968517320174520, 0.5005724722855768, 0.5005724722855768, \
1.000664035292480, 0.4988007962845478, 0.4988007962845478, 1.004124647956941, \
0.4970570274395905, 0.4970570274395905, 1.007707601572979, \
0.4951952934956306, 0.4951952934956306, 1.011602254438179, \
0.4931513015154748, 0.4931513015154748, 1.015899597473172, \
0.4908916048211160, 0.4908916048211160, 1.020650660021986, \
0.4883960306255098, 0.4883960306255098, 1.025888475868556, \
0.4856505930352334, 0.4856505930352334, 1.031637492062251, \
0.4826442922627998, 0.4826442922627998, 1.037918023981768, \
0.4793675325516791, 0.4793675325516791, 1.044748546337531, \
0.4758112776834427, 0.4758112776834427, 1.052146960534851, \
0.4719665671722846, 0.4719665671722846, 1.060131346467574, \
0.4678242189177159, 0.4678242189177159, 1.068720441657849, \
0.4633746323898363, 0.4633746323898363, 1.077933971029320, \
0.4586076475505698, 0.4586076475505698, 1.087792893232316, \
0.4535124349737828, 0.4535124349737828, 1.098319600474896, \
0.4480774030903491, 0.4480774030903491, 1.109538093539297, \
0.4422901141075544, 0.4422901141075544, 1.121474145310469, \
0.4361372032747508, 0.4361372032747508, 1.134155461440983, \
0.4296042979444454, 0.4296042979444454, 1.147611844074799, \
0.4226759339042368, 0.4226759339042368, 1.161875362987049, \
0.4153354670465312, 0.4153354670465312, 1.176980537600835, \
0.4075649787732531, 0.4075649787732531, 1.192964532854944, \
0.3993451736991763, 0.3993451736991763, 1.209867371670603, \
0.3906552682754850, 0.3906552682754850, 1.227732166715636, \
0.3814728689362103, 0.3814728689362103, 1.246605374241413, \
0.3717738382914228, 0.3717738382914228, 1.266537072943983, \
0.3615321477604503, 0.3615321477604503, 1.287581271061068, \
0.3507197148572056, 0.3507197148572056, 1.309796245255238, \
0.3393062231033525, 0.3393062231033525, 1.333244915250405, \
0.3272589222422737, 0.3272589222422737, 1.357995258688293, \
0.3145424060371085, 0.3145424060371085, 1.384120771261847, \
0.3011183644237561, 0.3011183644237561, 1.411700977875399, \
0.2869453060916856, 0.2869453060916856, 1.440822001391908, \
0.2719782465661612, 0.2719782465661612, 1.471577196474937, \
0.2561683553428956, 0.2561683553428956, 1.504067857140543, \
0.2394625531282511, 0.2394625531282511, 1.538404007930584, \
0.2218030457874002, 0.2218030457874002, 1.574705290138913, \
0.2031267729339121, 0.2031267729339121, 1.613101956307647, \
0.1833647305220461, 0.1833647305220461, 1.653735988313637, \
0.1624410826456338, 0.1624410826456338, 1.696762356847896, \
0.1402718593985191, 0.1402718593985191, 1.742350443029568, \
0.1167626701331226, 0.1167626701331226, 1.790685646384601, \
0.09180347299390093, 0.09180347299390093, 1.841971207572708, \
0.06525143427929395, 0.06525143427929395, 1.896430279206410, \
0.03683380200279092, 0.03683380200279092, 1.954308284048521, \
-0.2000000000000000, -0.8477365191342075, 0.4082848750988253, \
0.3385945287386583, -0.8477365191342075, 0.08318324767941748, \
0.3457475833377311, -0.3998380076605509, 0.4082848750988253, \
0.3457475833377311, -0.9709554782348285, 0.5068837098037012, \
0.5068837098037012, -0.9931999591652705, 0.5014141989686101, \
0.5014141989686101, -0.9998881166579462, 0.4989836270984772, \
0.4989836270984772, -1.003907206526034, 0.4971664446057500, \
0.4971664446057500, -1.007396083701518, 0.4954268113056033, \
0.4954268113056033, -1.010948401254801, 0.4935875265259980, \
0.4935875265259980, -1.014788807649293, 0.4915737953779486, \
0.4915737953779486, -1.019021366702992, 0.4893479544396159, \
0.4893479544396159, -1.023702715701937, 0.4868879193039980, \
0.4868879193039980, -1.028868551431912, 0.4841787601856619, \
0.4841787601856619, -1.034544679363690, 0.4812089827869092, \
0.4812089827869092, -1.040752141702349, 0.4779687226657872, \
0.4779687226657872, -1.047509811766032, 0.4744487959004522, \
0.4744487959004522, -1.054835808772183, 0.4706401626709804, \
0.4706401626709804, -1.062748325804639, 0.4665336019927072, \
0.4665336019927072, -1.071266150372880, 0.4621194993772110, \
0.4621194993772110, -1.080409017693113, 0.4573876967754807, \
0.4573876967754807, -1.090197870844611, 0.4523273773322582, \
0.4523273773322582, -1.100655068985233, 0.4469269693368470, \
0.4469269693368470, -1.111804567573385, 0.4411740600777258, \
0.4411740600777258, -1.123672085184967, 0.4350553137963415, \
0.4350553137963415, -1.136285266275123, 0.4285563899111730, \
0.4285563899111730, -1.149673846236632, 0.4216618588207538, \
0.4216618588207538, -1.163869823372660, 0.4143551132502623, \
0.4143551132502623, -1.178907641406510, 0.4066182734748335, \
0.4066182734748335, -1.194824385604308, 0.3984320849424846, \
0.3984320849424846, -1.211659995324089, 0.3897758068920915, \
0.3897758068920915, -1.229457495731759, 0.3806270905522059, \
0.3806270905522059, -1.248263251486477, 0.3709618454338489, \
0.3709618454338489, -1.268127245363986, 0.3607540921039345, \
0.3607540921039345, -1.289103385040013, 0.3499757996476757, \
0.3499757996476757, -1.311249841589622, 0.3385967057940934, \
0.3385967057940934, -1.334629423671811, 0.3265841173776356, \
0.3265841173776356, -1.359309991865351, 0.3139026884206379, \
0.3139026884206379, -1.385364918210060, 0.3005141726103371, \
0.3005141726103371, -1.412873596698510, 0.2863771462475716, \
0.2863771462475716, -1.441922011271974, 0.2714466967469119, \
0.2714466967469119, -1.472603368819903, 0.2556740702479912, \
0.2556740702479912, -1.505018805787894, 0.2390062694040945, \
0.2390062694040945, -1.539278178293477, 0.2213855879707796, \
0.2213855879707796, -1.575500947166728, 0.2027490601628584, \
0.2027490601628584, -1.613817171115958, 0.1830277842071292, \
0.1830277842071292, -1.654368623318704, 0.1621460354354560, \
0.1621460354354560, -1.697310049217566, 0.1400199661143751, \
0.1400199661143751, -1.742810586235216, 0.1165553223125093, \
0.1165553223125093, -1.791055369606869, 0.09164222200436628, \
0.09164222200436628, -1.842247352676357, 0.06513804318504389, \
0.06513804318504389, -1.896609374955528, 0.03677046197767251, \
0.03677046197767251, -1.954386517181403, 0.3385945287386583, \
-0.3998380076605509, 0.9758316090231906, 0.5070433376790490, \
0.5070433376790490, 0.9911436239312552, 0.5027825233480839, \
0.5027825233480839, 0.9968517320174520, 0.5005724722855768, \
0.5005724722855768, 1.000664035292480, 0.4988007962845478, \
0.4988007962845478, 1.004124647956941, 0.4970570274395905, \
0.4970570274395905, 1.007707601572979, 0.4951952934956306, \
0.4951952934956306, 1.011602254438179, 0.4931513015154748, \
0.4931513015154748, 1.015899597473172, 0.4908916048211160, \
0.4908916048211160, 1.020650660021986, 0.4883960306255098, \
0.4883960306255098, 1.025888475868556, 0.4856505930352334, \
0.4856505930352334, 1.031637492062251, 0.4826442922627998, \
0.4826442922627998, 1.037918023981768, 0.4793675325516791, \
0.4793675325516791, 1.044748546337531, 0.4758112776834427, \
0.4758112776834427, 1.052146960534851, 0.4719665671722846, \
0.4719665671722846, 1.060131346467574, 0.4678242189177159, \
0.4678242189177159, 1.068720441657849, 0.4633746323898363, \
0.4633746323898363, 1.077933971029320, 0.4586076475505698, \
0.4586076475505698, 1.087792893232316, 0.4535124349737828, \
0.4535124349737828, 1.098319600474896, 0.4480774030903491, \
0.4480774030903491, 1.109538093539297, 0.4422901141075544, \
0.4422901141075544, 1.121474145310469, 0.4361372032747508, \
0.4361372032747508, 1.134155461440983, 0.4296042979444454, \
0.4296042979444454, 1.147611844074799, 0.4226759339042368, \
0.4226759339042368, 1.161875362987049, 0.4153354670465312, \
0.4153354670465312, 1.176980537600835, 0.4075649787732531, \
0.4075649787732531, 1.192964532854944, 0.3993451736991763, \
0.3993451736991763, 1.209867371670603, 0.3906552682754850, \
0.3906552682754850, 1.227732166715636, 0.3814728689362103, \
0.3814728689362103, 1.246605374241413, 0.3717738382914228, \
0.3717738382914228, 1.266537072943983, 0.3615321477604503, \
0.3615321477604503, 1.287581271061068, 0.3507197148572056, \
0.3507197148572056, 1.309796245255238, 0.3393062231033525, \
0.3393062231033525, 1.333244915250405, 0.3272589222422737, \
0.3272589222422737, 1.357995258688293, 0.3145424060371085, \
0.3145424060371085, 1.384120771261847, 0.3011183644237561, \
0.3011183644237561, 1.411700977875399, 0.2869453060916856, \
0.2869453060916856, 1.440822001391908, 0.2719782465661612, \
0.2719782465661612, 1.471577196474937, 0.2561683553428956, \
0.2561683553428956, 1.504067857140543, 0.2394625531282511, \
0.2394625531282511, 1.538404007930584, 0.2218030457874002, \
0.2218030457874002, 1.574705290138913, 0.2031267729339121, \
0.2031267729339121, 1.613101956307647, 0.1833647305220461, \
0.1833647305220461, 1.653735988313637, 0.1624410826456338, \
0.1624410826456338, 1.696762356847896, 0.1402718593985191, \
0.1402718593985191, 1.742350443029568, 0.1167626701331226, \
0.1167626701331226, 1.790685646384601, 0.09180347299390093, \
0.09180347299390093, 1.841971207572708, 0.06525143427929395, \
0.06525143427929395, 1.896430279206410, 0.03683380200279092, \
0.03683380200279092, 1.954308284048521})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.779359698392333*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"a9b7c7ad-c5a1-422a-84f0-7bb5f47bd40c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -0.5", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.779359280778961*^9}, {
  3.779359376793551*^9, 
  3.779359377003592*^9}},ExpressionUUID->"52c2ca07-d3c9-484c-8e9f-\
ad58ca1e9186"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "0.5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, {3.779359285341239*^9, 
   3.779359286580131*^9}, 3.779359471914785*^9},
 CellLabel->"In[24]:=",ExpressionUUID->"88838bec-fd1e-4320-aabd-86518dde8792"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-0.5000000000000000, \
-0.8421064865528824, 0.4552945833789559, 0.2890735332944597, \
-0.8421064865528824, 0.1984642311410484, 0.3040779176405696, \
-0.4328285819911314, 0.4552945833789559, 0.3040779176405696, \
-0.9642799801789915, 0.5074051007744027, 0.5074051007744027, \
-0.9940162739371904, 0.5006471088358844, 0.5006471088358844, \
-1.001736170978086, 0.4979849575670231, 0.4979849575670231, \
-1.005976535823337, 0.4961157983327418, 0.4961157983327418, \
-1.009506830156433, 0.4943733900235052, 0.4943733900235052, \
-1.013043062840752, 0.4925489405139110, 0.4925489405139110, \
-1.016845045482765, 0.4905572996495133, 0.4905572996495133, \
-1.021029611739724, 0.4883567210067153, 0.4883567210067153, \
-1.025658783252952, 0.4859233002132330, 0.4859233002132330, \
-1.030770770200763, 0.4832412247884709, 0.4832412247884709, \
-1.036392635757762, 0.4802985476584861, 0.4802985476584861, \
-1.042546079258474, 0.4770851649965193, 0.4770851649965193, \
-1.049250323046007, 0.4735917662547448, 0.4735917662547448, \
-1.056523668177055, 0.4698092476537334, 0.4698092476537334, \
-1.064384394635246, 0.4657283605355845, 0.4657283605355845, \
-1.072851320880089, 0.4613394844663027, 0.4613394844663027, \
-1.081944179089385, 0.4566324688244283, 0.4566324688244283, \
-1.091683888133967, 0.4515965126034063, 0.4515965126034063, \
-1.102092769497119, 0.4462200653493543, 0.4462200653493543, \
-1.113194732234936, 0.4404907391454027, 0.4404907391454027, \
-1.125015442756699, 0.4343952253893037, 0.4343952253893037, \
-1.137582489456856, 0.4279192122745672, 0.4279192122745672, \
-1.150925548952422, 0.4210473001279663, 0.4210473001279663, \
-1.165076558786739, 0.4137629124726395, 0.4137629124726395, \
-1.180069900372666, 0.4060482010903504, 0.4060482010903504, \
-1.195942595346045, 0.3978839435679146, 0.3978839435679146, \
-1.212734518203669, 0.3892494318988342, 0.3892494318988342, \
-1.230488628005571, 0.3801223507100992, 0.3801223507100992, \
-1.249251221969781, 0.3704786436170255, 0.3704786436170255, \
-1.269072213944664, 0.3602923660862191, 0.3602923660862191, \
-1.290005440991476, 0.3495355230109934, 0.3495355230109934, \
-1.312109001639408, 0.3381778889711266, 0.3381778889711266, \
-1.335445629785737, 0.3261868088490845, 0.3261868088490845, \
-1.360083108708334, 0.3135269760876229, 0.3135269760876229, \
-1.386094730244142, 0.3001601853636239, 0.3001601853636239, \
-1.413559804876761, 0.2860450557573996, 0.2860450557573996, \
-1.442564229283766, 0.2711367195004402, 0.2711367195004402, \
-1.473201118838782, 0.2553864698661478, 0.2553864698661478, \
-1.505571513667854, 0.2387413592768022, 0.2387413592768022, \
-1.539785168152845, 0.2211437342609515, 0.2211437342609515, \
-1.575961435290982, 0.2025306852492419, 0.2025306852492419, \
-1.614230259101503, 0.1828333706735364, 0.1828333706735364, \
-1.654733290368713, 0.1619761307938542, 0.1619761307938542, \
-1.697625143488162, 0.1398751886433905, 0.1398751886433905, \
-1.743074815115320, 0.1164363689420299, 0.1164363689420299, \
-1.791267288797441, 0.09154988106839554, 0.09154988106839554, \
-1.842405353914165, 0.06507322353306180, 0.06507322353306180, \
-1.896711672202333, 0.03673431577737839, 0.03673431577737839, \
-1.954431131070883, 0.2890735332944597, -0.4328285819911314, \
0.9764123594807908, 0.5076917758914808, 0.5076917758914808, \
0.9892154403643017, 0.5038705900898875, 0.5038705900898875, \
0.9945671741953824, 0.5017395173169115, 0.5017395173169115, \
0.9983089728685836, 0.4999811820626520, 0.4999811820626520, \
1.001767009311163, 0.4982315649212323, 0.4982315649212323, 1.005370576864430, \
0.4963566061597708, 0.4963566061597708, 1.009295633677805, \
0.4942960262782035, 0.4942960262782035, 1.013628144009867, \
0.4920180100163495, 0.4920180100163495, 1.018416953481259, \
0.4895031342153432, 0.4895031342153432, 1.023694043406085, \
0.4867377893468573, 0.4867377893468573, 1.029483313658205, \
0.4837111771566819, 0.4837111771566819, 1.035804779372412, \
0.4804138146345253, 0.4804138146345253, 1.042676744909948, \
0.4768367300528385, 0.4768367300528385, 1.050117014118906, \
0.4729709995762920, 0.4729709995762920, 1.058143612522990, \
0.4688074607813530, 0.4688074607813530, 1.066775250318406, \
0.4643365218989884, 0.4643365218989884, 1.076031642965717, \
0.4595480242447909, 0.4595480242447909, 1.085933752107536, \
0.4544311344365783, 0.4544311344365783, 1.096503982124603, \
0.4489742529239570, 0.4489742529239570, 1.107766353128295, \
0.4431649307067780, 0.4431649307067780, 1.119746663225164, \
0.4369897890999035, 0.4369897890999035, 1.132472648395346, \
0.4304344391017023, 0.4304344391017023, 1.145974145740305, \
0.4234833979064610, 0.4234833979064610, 1.160283264356004, \
0.4161200006672274, 0.4161200006672274, 1.175434567230179, \
0.4083263059308682, 0.4083263059308682, 1.191465267098727, \
0.4000829933243400, 0.4000829933243400, 1.208415438984941, \
0.3913692521233707, 0.3913692521233707, 1.226328252104816, \
0.3821626593120363, 0.3821626593120363, 1.245250223904786, \
0.3724390456604430, 0.3724390456604430, 1.265231499178302, \
0.3621723482153602, 0.3621723482153602, 1.286326157470953, \
0.3513344474161691, 0.3513344474161691, 1.308592552324556, \
0.3398949868111087, 0.3398949868111087, 1.332093686329225, \
0.3278211730451479, 0.3278211730451479, 1.356897626453387, \
0.3150775534002493, 0.3150775534002493, 1.383077964713324, \
0.3016257676554959, 0.3016257676554959, 1.410714329937949, \
0.2874242703353663, 0.2874242703353663, 1.439892957196353, \
0.2724280184137063, 0.2724280184137063, 1.470707322404378, \
0.2565881180161083, 0.2565881180161083, 1.503258850735505, \
0.2398514211618666, 0.2398514211618666, 1.537657708759458, \
0.2221600591294471, 0.2221600591294471, 1.574023691753808, \
0.2034508903476815, 0.2034508903476815, 1.612487219421908, \
0.1836548221151814, 0.1836548221151814, 1.653190455356057, \
0.1626959212273736, 0.1626959212273736, 1.696288568070596, \
0.1404901100651714, 0.1404901100651714, 1.741951154372093, \
0.1169428766322718, 0.1169428766322718, 1.790363849326748, \
0.09194403649455188, 0.09194403649455188, 1.841730151243740, \
0.06535056678390799, 0.06535056678390799, 1.896273495059615, \
0.03688933493400606, 0.03688933493400606, 1.954239613458801, \
-0.5000000000000000, -0.8421064865528824, 0.4552945833789559, \
0.2890735332944597, -0.8421064865528824, 0.1984642311410484, \
0.3040779176405696, -0.4328285819911314, 0.4552945833789559, \
0.3040779176405696, -0.9642799801789915, 0.5074051007744027, \
0.5074051007744027, -0.9940162739371904, 0.5006471088358844, \
0.5006471088358844, -1.001736170978086, 0.4979849575670231, \
0.4979849575670231, -1.005976535823337, 0.4961157983327418, \
0.4961157983327418, -1.009506830156433, 0.4943733900235052, \
0.4943733900235052, -1.013043062840752, 0.4925489405139110, \
0.4925489405139110, -1.016845045482765, 0.4905572996495133, \
0.4905572996495133, -1.021029611739724, 0.4883567210067153, \
0.4883567210067153, -1.025658783252952, 0.4859233002132330, \
0.4859233002132330, -1.030770770200763, 0.4832412247884709, \
0.4832412247884709, -1.036392635757762, 0.4802985476584861, \
0.4802985476584861, -1.042546079258474, 0.4770851649965193, \
0.4770851649965193, -1.049250323046007, 0.4735917662547448, \
0.4735917662547448, -1.056523668177055, 0.4698092476537334, \
0.4698092476537334, -1.064384394635246, 0.4657283605355845, \
0.4657283605355845, -1.072851320880089, 0.4613394844663027, \
0.4613394844663027, -1.081944179089385, 0.4566324688244283, \
0.4566324688244283, -1.091683888133967, 0.4515965126034063, \
0.4515965126034063, -1.102092769497119, 0.4462200653493543, \
0.4462200653493543, -1.113194732234936, 0.4404907391454027, \
0.4404907391454027, -1.125015442756699, 0.4343952253893037, \
0.4343952253893037, -1.137582489456856, 0.4279192122745672, \
0.4279192122745672, -1.150925548952422, 0.4210473001279663, \
0.4210473001279663, -1.165076558786739, 0.4137629124726395, \
0.4137629124726395, -1.180069900372666, 0.4060482010903504, \
0.4060482010903504, -1.195942595346045, 0.3978839435679146, \
0.3978839435679146, -1.212734518203669, 0.3892494318988342, \
0.3892494318988342, -1.230488628005571, 0.3801223507100992, \
0.3801223507100992, -1.249251221969781, 0.3704786436170255, \
0.3704786436170255, -1.269072213944664, 0.3602923660862191, \
0.3602923660862191, -1.290005440991476, 0.3495355230109934, \
0.3495355230109934, -1.312109001639408, 0.3381778889711266, \
0.3381778889711266, -1.335445629785737, 0.3261868088490845, \
0.3261868088490845, -1.360083108708334, 0.3135269760876229, \
0.3135269760876229, -1.386094730244142, 0.3001601853636239, \
0.3001601853636239, -1.413559804876761, 0.2860450557573996, \
0.2860450557573996, -1.442564229283766, 0.2711367195004402, \
0.2711367195004402, -1.473201118838782, 0.2553864698661478, \
0.2553864698661478, -1.505571513667854, 0.2387413592768022, \
0.2387413592768022, -1.539785168152845, 0.2211437342609515, \
0.2211437342609515, -1.575961435290982, 0.2025306852492419, \
0.2025306852492419, -1.614230259101503, 0.1828333706735364, \
0.1828333706735364, -1.654733290368713, 0.1619761307938542, \
0.1619761307938542, -1.697625143488162, 0.1398751886433905, \
0.1398751886433905, -1.743074815115320, 0.1164363689420299, \
0.1164363689420299, -1.791267288797441, 0.09154988106839554, \
0.09154988106839554, -1.842405353914165, 0.06507322353306180, \
0.06507322353306180, -1.896711672202333, 0.03673431577737839, \
0.03673431577737839, -1.954431131070883, 0.2890735332944597, \
-0.4328285819911314, 0.9764123594807908, 0.5076917758914808, \
0.5076917758914808, 0.9892154403643017, 0.5038705900898875, \
0.5038705900898875, 0.9945671741953824, 0.5017395173169115, \
0.5017395173169115, 0.9983089728685836, 0.4999811820626520, \
0.4999811820626520, 1.001767009311163, 0.4982315649212323, \
0.4982315649212323, 1.005370576864430, 0.4963566061597708, \
0.4963566061597708, 1.009295633677805, 0.4942960262782035, \
0.4942960262782035, 1.013628144009867, 0.4920180100163495, \
0.4920180100163495, 1.018416953481259, 0.4895031342153432, \
0.4895031342153432, 1.023694043406085, 0.4867377893468573, \
0.4867377893468573, 1.029483313658205, 0.4837111771566819, \
0.4837111771566819, 1.035804779372412, 0.4804138146345253, \
0.4804138146345253, 1.042676744909948, 0.4768367300528385, \
0.4768367300528385, 1.050117014118906, 0.4729709995762920, \
0.4729709995762920, 1.058143612522990, 0.4688074607813530, \
0.4688074607813530, 1.066775250318406, 0.4643365218989884, \
0.4643365218989884, 1.076031642965717, 0.4595480242447909, \
0.4595480242447909, 1.085933752107536, 0.4544311344365783, \
0.4544311344365783, 1.096503982124603, 0.4489742529239570, \
0.4489742529239570, 1.107766353128295, 0.4431649307067780, \
0.4431649307067780, 1.119746663225164, 0.4369897890999035, \
0.4369897890999035, 1.132472648395346, 0.4304344391017023, \
0.4304344391017023, 1.145974145740305, 0.4234833979064610, \
0.4234833979064610, 1.160283264356004, 0.4161200006672274, \
0.4161200006672274, 1.175434567230179, 0.4083263059308682, \
0.4083263059308682, 1.191465267098727, 0.4000829933243400, \
0.4000829933243400, 1.208415438984941, 0.3913692521233707, \
0.3913692521233707, 1.226328252104816, 0.3821626593120363, \
0.3821626593120363, 1.245250223904786, 0.3724390456604430, \
0.3724390456604430, 1.265231499178302, 0.3621723482153602, \
0.3621723482153602, 1.286326157470953, 0.3513344474161691, \
0.3513344474161691, 1.308592552324556, 0.3398949868111087, \
0.3398949868111087, 1.332093686329225, 0.3278211730451479, \
0.3278211730451479, 1.356897626453387, 0.3150775534002493, \
0.3150775534002493, 1.383077964713324, 0.3016257676554959, \
0.3016257676554959, 1.410714329937949, 0.2874242703353663, \
0.2874242703353663, 1.439892957196353, 0.2724280184137063, \
0.2724280184137063, 1.470707322404378, 0.2565881180161083, \
0.2565881180161083, 1.503258850735505, 0.2398514211618666, \
0.2398514211618666, 1.537657708759458, 0.2221600591294471, \
0.2221600591294471, 1.574023691753808, 0.2034508903476815, \
0.2034508903476815, 1.612487219421908, 0.1836548221151814, \
0.1836548221151814, 1.653190455356057, 0.1626959212273736, \
0.1626959212273736, 1.696288568070596, 0.1404901100651714, \
0.1404901100651714, 1.741951154372093, 0.1169428766322718, \
0.1169428766322718, 1.790363849326748, 0.09194403649455188, \
0.09194403649455188, 1.841730151243740, 0.06535056678390799, \
0.06535056678390799, 1.896273495059615, 0.03688933493400606, \
0.03688933493400606, 1.954239613458801})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.779359760943426*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"5ec5f741-2d09-4348-99c2-de96576ee499"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -1", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.779359280778961*^9}, 
   3.77935937885754*^9},ExpressionUUID->"6343f24b-fca0-448a-86aa-\
056e6ef8eb2e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, {3.779359285341239*^9, 
   3.779359286580131*^9}, 3.779359464410329*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"4741c6a3-65a6-4595-8929-1f1e1d1b996d"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-1.000000000000000, \
-0.8276036049740966, 0.5150274205947206, 0.2232017676216483, \
-0.8276036049740966, 0.3486098290965558, 0.2447069878635228, \
-0.4697660318326181, 0.5150274205947206, 0.2447069878635228, \
-0.9510478980795530, 0.5089143940726913, 0.5089143940726913, \
-0.9942987333640352, 0.4998850391740042, 0.4998850391740042, \
-1.003791470435643, 0.4968319313570510, 0.4968319313570510, \
-1.008405216098653, 0.4948725594829634, 0.4948725594829634, \
-1.012015302864365, 0.4931186146787440, 0.4931186146787440, \
-1.015540885858256, 0.4913099489962150, 0.4913099489962150, \
-1.019297967728230, 0.4893450995529055, 0.4893450995529055, \
-1.023423255715281, 0.4871760326146102, 0.4871760326146102, \
-1.027986984993391, 0.4847760912026482, 0.4847760912026482, \
-1.033031137179648, 0.4821281481841567, 0.4821281481841567, \
-1.038584635172389, 0.4792195917303561, 0.4792195917303561, \
-1.044670136165796, 0.4760399716815403, 0.4760399716815403, \
-1.051307363418386, 0.4725797973781384, 0.4725797973781384, \
-1.058514873944753, 0.4688298761740128, 0.4688298761740128, \
-1.066311066352044, 0.4647809226689202, 0.4647809226689202, \
-1.074714797958893, 0.4604233104045460, 0.4604233104045460, \
-1.083745792196579, 0.4557469012687447, 0.4557469012687447, \
-1.093424930203100, 0.4507409181340135, 0.4507409181340135, \
-1.103774477841984, 0.4453938414723333, 0.4453938414723333, \
-1.114818277431861, 0.4396933186794651, 0.4396933186794651, \
-1.126581921722275, 0.4336260791953242, 0.4336260791953242, \
-1.139092921147608, 0.4271778509489943, 0.4271778509489943, \
-1.152380871699694, 0.4203332750542915, 0.4203332750542915, \
-1.166477628633371, 0.4130758164868584, 0.4130758164868584, \
-1.181417489995621, 0.4053876689303385, 0.4053876689303385, \
-1.197237393285845, 0.3972496522221760, 0.3972496522221760, \
-1.213977128208663, 0.3886411009351128, 0.3886411009351128, \
-1.231679568355421, 0.3795397426416908, 0.3795397426416908, \
-1.250390924679123, 0.3699215643499302, 0.3699215643499302, \
-1.270161023771674, 0.3597606654808235, 0.3597606654808235, \
-1.291043614191259, 0.3490290955860807, 0.3490290955860807, \
-1.313096704411493, 0.3376966747746057, 0.3376966747746057, \
-1.336382936370229, 0.3257307945182399, 0.3257307945182399, \
-1.360969999087567, 0.3130961961215109, 0.3130961961215109, \
-1.386931087406735, 0.2997547236312786, 0.2997547236312786, \
-1.414345411599198, 0.2856650472677192, 0.2856650472677192, \
-1.443298764381370, 0.2707823524631718, 0.2707823524631718, \
-1.473884152833264, 0.2550579880787170, 0.2550579880787170, \
-1.506202503812635, 0.2384390648798105, 0.2384390648798105, \
-1.540363452749955, 0.2208679909180511, 0.2208679909180511, \
-1.576486227224547, 0.2022819218293339, 0.2022819218293339, \
-1.614700638502348, 0.1826120855556078, 0.1826120855556078, \
-1.655148196312386, 0.1617828970052021, 0.1617828970052021, \
-1.697983364614300, 0.1397106602616513, 0.1397106602616513, \
-1.743374979039487, 0.1163012898130648, 0.1163012898130648, \
-1.791507850166879, 0.09144509903348310, 0.09144509903348310, \
-1.842584580935831, 0.06499972317279478, 0.06499972317279478, \
-1.896827631444488, 0.03669335722744907, 0.03669335722744907, \
-1.954481670307510, 0.2232017676216483, -0.4697660318326181, \
0.9745334799767146, 0.5090200023836715, 0.5090200023836715, \
0.9863004552039376, 0.5053776584024428, 0.5053776584024428, \
0.9915118503513953, 0.5032755067299621, 0.5032755067299621, \
0.9952323222555592, 0.5015185893161656, 0.5015185893161656, \
0.9986978991905978, 0.4997620284200622, 0.4997620284200622, \
1.002319515784844, 0.4978765897395649, 0.4978765897395649, 1.006267682559040, \
0.4958036169552524, 0.4958036169552524, 1.010626342344365, \
0.4935119466318420, 0.4935119466318420, 1.015443474912364, \
0.4909824500534748, 0.4909824500534748, 1.020750653114017, \
0.4882016614645520, 0.4882016614645520, 1.026571572216354, \
0.4851588557785626, 0.4851588557785626, 1.032926142774146, \
0.4818445869791778, 0.4818445869791778, 1.039832617978617, \
0.4782499002214420, 0.4782499002214420, 1.047308781416056, \
0.4743658764342704, 0.4743658764342704, 1.055372657751554, \
0.4701833500258185, 0.4701833500258185, 1.064042969573908, \
0.4656927204043310, 0.4656927204043310, 1.073339454590828, \
0.4608838156792916, 0.4608838156792916, 1.083283104640057, \
0.4557457855926361, 0.4557457855926361, 1.093896361182353, \
0.4502670104392517, 0.4502670104392517, 1.105203287730242, \
0.4444350179808785, 0.4444350179808785, 1.117229731858599, \
0.4382364032819036, 0.4382364032819036, 1.130003485031613, \
0.4316567480651304, 0.4316567480651304, 1.143554445939647, \
0.4246805371513133, 0.4246805371513133, 1.157914791566047, \
0.4172910701026790, 0.4172910701026790, 1.173119159361757, \
0.4094703664999765, 0.4094703664999765, 1.189204843451266, \
0.4011990634361104, 0.4011990634361104, 1.206212007588054, \
0.3924563038591938, 0.3924563038591938, 1.224183917541151, \
0.3832196143734730, 0.3832196143734730, 1.243167195680295, \
0.3734647710240675, 0.3734647710240675, 1.263212100709428, \
0.3631656514580933, 0.3631656514580933, 1.284372835763208, \
0.3522940716713651, 0.3522940716713651, 1.306707888423577, \
0.3408196053116044, 0.3408196053116044, 1.330280406633488, \
0.3287093832044790, 0.3287093832044790, 1.355158614987373, \
0.3159278703771418, 0.3159278703771418, 1.381416276471253, \
0.3024366173392841, 0.3024366173392841, 1.409133205421273, \
0.2881939816807380, 0.2881939816807380, 1.438395838283393, \
0.2731548150413969, 0.2731548150413969, 1.469297869707954, \
0.2572701089805407, 0.2572701089805407, 1.501940962624639, \
0.2404865907647926, 0.2404865907647926, 1.536435542244516, \
0.2227462556254137, 0.2227462556254137, 1.572901685461428, \
0.2039858133318359, 0.2039858133318359, 1.611470118917268, \
0.1841360082812001, 0.1841360082812001, 1.652283341106292, \
0.1631207279676149, 0.1631207279676149, 1.695496886385278, \
0.1408556958664238, 0.1408556958664238, 1.741280751705827, \
0.1172461757601887, 0.1172461757601887, 1.789821010386327, \
0.09218172044163353, 0.09218172044163353, 1.841321641409560, \
0.06551896197963854, 0.06551896197963854, 1.896006607710075, \
0.03698409174913694, 0.03698409174913694, 1.954122222879525, \
-1.000000000000000, -0.8276036049740966, 0.5150274205947206, \
0.2232017676216483, -0.8276036049740966, 0.3486098290965558, \
0.2447069878635228, -0.4697660318326181, 0.5150274205947206, \
0.2447069878635228, -0.9510478980795530, 0.5089143940726913, \
0.5089143940726913, -0.9942987333640352, 0.4998850391740042, \
0.4998850391740042, -1.003791470435643, 0.4968319313570510, \
0.4968319313570510, -1.008405216098653, 0.4948725594829634, \
0.4948725594829634, -1.012015302864365, 0.4931186146787440, \
0.4931186146787440, -1.015540885858256, 0.4913099489962150, \
0.4913099489962150, -1.019297967728230, 0.4893450995529055, \
0.4893450995529055, -1.023423255715281, 0.4871760326146102, \
0.4871760326146102, -1.027986984993391, 0.4847760912026482, \
0.4847760912026482, -1.033031137179648, 0.4821281481841567, \
0.4821281481841567, -1.038584635172389, 0.4792195917303561, \
0.4792195917303561, -1.044670136165796, 0.4760399716815403, \
0.4760399716815403, -1.051307363418386, 0.4725797973781384, \
0.4725797973781384, -1.058514873944753, 0.4688298761740128, \
0.4688298761740128, -1.066311066352044, 0.4647809226689202, \
0.4647809226689202, -1.074714797958893, 0.4604233104045460, \
0.4604233104045460, -1.083745792196579, 0.4557469012687447, \
0.4557469012687447, -1.093424930203100, 0.4507409181340135, \
0.4507409181340135, -1.103774477841984, 0.4453938414723333, \
0.4453938414723333, -1.114818277431861, 0.4396933186794651, \
0.4396933186794651, -1.126581921722275, 0.4336260791953242, \
0.4336260791953242, -1.139092921147608, 0.4271778509489943, \
0.4271778509489943, -1.152380871699694, 0.4203332750542915, \
0.4203332750542915, -1.166477628633371, 0.4130758164868584, \
0.4130758164868584, -1.181417489995621, 0.4053876689303385, \
0.4053876689303385, -1.197237393285845, 0.3972496522221760, \
0.3972496522221760, -1.213977128208663, 0.3886411009351128, \
0.3886411009351128, -1.231679568355421, 0.3795397426416908, \
0.3795397426416908, -1.250390924679123, 0.3699215643499302, \
0.3699215643499302, -1.270161023771674, 0.3597606654808235, \
0.3597606654808235, -1.291043614191259, 0.3490290955860807, \
0.3490290955860807, -1.313096704411493, 0.3376966747746057, \
0.3376966747746057, -1.336382936370229, 0.3257307945182399, \
0.3257307945182399, -1.360969999087567, 0.3130961961215109, \
0.3130961961215109, -1.386931087406735, 0.2997547236312786, \
0.2997547236312786, -1.414345411599198, 0.2856650472677192, \
0.2856650472677192, -1.443298764381370, 0.2707823524631718, \
0.2707823524631718, -1.473884152833264, 0.2550579880787170, \
0.2550579880787170, -1.506202503812635, 0.2384390648798105, \
0.2384390648798105, -1.540363452749955, 0.2208679909180511, \
0.2208679909180511, -1.576486227224547, 0.2022819218293339, \
0.2022819218293339, -1.614700638502348, 0.1826120855556078, \
0.1826120855556078, -1.655148196312386, 0.1617828970052021, \
0.1617828970052021, -1.697983364614300, 0.1397106602616513, \
0.1397106602616513, -1.743374979039487, 0.1163012898130648, \
0.1163012898130648, -1.791507850166879, 0.09144509903348310, \
0.09144509903348310, -1.842584580935831, 0.06499972317279478, \
0.06499972317279478, -1.896827631444488, 0.03669335722744907, \
0.03669335722744907, -1.954481670307510, 0.2232017676216483, \
-0.4697660318326181, 0.9745334799767146, 0.5090200023836715, \
0.5090200023836715, 0.9863004552039376, 0.5053776584024428, \
0.5053776584024428, 0.9915118503513953, 0.5032755067299621, \
0.5032755067299621, 0.9952323222555592, 0.5015185893161656, \
0.5015185893161656, 0.9986978991905978, 0.4997620284200622, \
0.4997620284200622, 1.002319515784844, 0.4978765897395649, \
0.4978765897395649, 1.006267682559040, 0.4958036169552524, \
0.4958036169552524, 1.010626342344365, 0.4935119466318420, \
0.4935119466318420, 1.015443474912364, 0.4909824500534748, \
0.4909824500534748, 1.020750653114017, 0.4882016614645520, \
0.4882016614645520, 1.026571572216354, 0.4851588557785626, \
0.4851588557785626, 1.032926142774146, 0.4818445869791778, \
0.4818445869791778, 1.039832617978617, 0.4782499002214420, \
0.4782499002214420, 1.047308781416056, 0.4743658764342704, \
0.4743658764342704, 1.055372657751554, 0.4701833500258185, \
0.4701833500258185, 1.064042969573908, 0.4656927204043310, \
0.4656927204043310, 1.073339454590828, 0.4608838156792916, \
0.4608838156792916, 1.083283104640057, 0.4557457855926361, \
0.4557457855926361, 1.093896361182353, 0.4502670104392517, \
0.4502670104392517, 1.105203287730242, 0.4444350179808785, \
0.4444350179808785, 1.117229731858599, 0.4382364032819036, \
0.4382364032819036, 1.130003485031613, 0.4316567480651304, \
0.4316567480651304, 1.143554445939647, 0.4246805371513133, \
0.4246805371513133, 1.157914791566047, 0.4172910701026790, \
0.4172910701026790, 1.173119159361757, 0.4094703664999765, \
0.4094703664999765, 1.189204843451266, 0.4011990634361104, \
0.4011990634361104, 1.206212007588054, 0.3924563038591938, \
0.3924563038591938, 1.224183917541151, 0.3832196143734730, \
0.3832196143734730, 1.243167195680295, 0.3734647710240675, \
0.3734647710240675, 1.263212100709428, 0.3631656514580933, \
0.3631656514580933, 1.284372835763208, 0.3522940716713651, \
0.3522940716713651, 1.306707888423577, 0.3408196053116044, \
0.3408196053116044, 1.330280406633488, 0.3287093832044790, \
0.3287093832044790, 1.355158614987373, 0.3159278703771418, \
0.3159278703771418, 1.381416276471253, 0.3024366173392841, \
0.3024366173392841, 1.409133205421273, 0.2881939816807380, \
0.2881939816807380, 1.438395838283393, 0.2731548150413969, \
0.2731548150413969, 1.469297869707954, 0.2572701089805407, \
0.2572701089805407, 1.501940962624639, 0.2404865907647926, \
0.2404865907647926, 1.536435542244516, 0.2227462556254137, \
0.2227462556254137, 1.572901685461428, 0.2039858133318359, \
0.2039858133318359, 1.611470118917268, 0.1841360082812001, \
0.1841360082812001, 1.652283341106292, 0.1631207279676149, \
0.1631207279676149, 1.695496886385278, 0.1408556958664238, \
0.1408556958664238, 1.741280751705827, 0.1172461757601887, \
0.1172461757601887, 1.789821010386327, 0.09218172044163353, \
0.09218172044163353, 1.841321641409560, 0.06551896197963854, \
0.06551896197963854, 1.896006607710075, 0.03698409174913694, \
0.03698409174913694, 1.954122222879525})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.779359826537459*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"bbe34063-b062-4da1-8278-bfb37f6f40a4"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -2", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.779359280778961*^9}, 
   3.779359379962492*^9},ExpressionUUID->"6ba9f7cf-03b3-440e-88ba-\
52711f5e1f4c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, {3.779359285341239*^9, 
   3.779359286580131*^9}, 3.779359460502379*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"334a50b6-1319-4878-b941-a2878d62fc3a"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-2.000000000000000, \
-0.8003080819007085, 0.5814840736176077, 0.1462301137710065, \
-0.8003080819007085, 0.5199709513182025, 0.1690610471818295, \
-0.5029572669668763, 0.5814840736176077, 0.1690610471818295, \
-0.9290896358111570, 0.5117775422752575, 0.5117775422752575, \
-0.9936353489298798, 0.4993089623069012, 0.4993089623069012, \
-1.005686003698882, 0.4957142172486279, 0.4957142172486279, \
-1.010806389590204, 0.4936317684206364, 0.4936317684206364, \
-1.014531490097471, 0.4918563025302863, 0.4918563025302863, \
-1.018058182890484, 0.4900598904927172, 0.4900598904927172, \
-1.021774609550457, 0.4881205868044634, 0.4881205868044634, \
-1.025841984888401, 0.4859827196734157, 0.4859827196734157, \
-1.030340397961640, 0.4836163644898592, 0.4836163644898592, \
-1.035316267900590, 0.4810028587190524, 0.4810028587190524, \
-1.040800676458759, 0.4781288225414502, 0.4781288225414502, \
-1.046817383579288, 0.4749834079202532, 0.4749834079202532, \
-1.053386687679176, 0.4715569170890371, 0.4715569170890371, \
-1.060527441314262, 0.4678400539422029, 0.4678400539422029, \
-1.068258183318933, 0.4638234883335870, 0.4638234883335870, \
-1.076597821714499, 0.4594975834238079, 0.4594975834238079, \
-1.085566077533035, 0.4548522113387669, 0.4548522113387669, \
-1.095183797341148, 0.4498766177817665, 0.4498766177817665, \
-1.105473192657283, 0.4445593138324722, 0.4445593138324722, \
-1.116458039204279, 0.4388879823211569, 0.4388879823211569, \
-1.128163855529709, 0.4328493911170718, 0.4328493911170718, \
-1.140618073155180, 0.4264293084299539, 0.4264293084299539, \
-1.153850206253517, 0.4196124167966930, 0.4196124167966930, \
-1.167892026462263, 0.4123822233302808, 0.4123822233302808, \
-1.182777747065755, 0.4047209643233051, 0.4047209643233051, \
-1.198544220004396, 0.3966095025764327, 0.3966095025764327, \
-1.215231148768601, 0.3880272159494908, 0.3880272159494908, \
-1.232881320075440, 0.3789518756575990, 0.3789518756575990, \
-1.251540857232832, 0.3693595127844090, 0.3693595127844090, \
-1.271259498226205, 0.3592242713727277, 0.3592242713727277, \
-1.292090901792132, 0.3485182462844618, 0.3485182462844618, \
-1.314092985060910, 0.3372113037945634, 0.3372113037945634, \
-1.337328296751899, 0.3252708825876591, 0.3252708825876591, \
-1.361864430393882, 0.3126617724417560, 0.3126617724417560, \
-1.387774482624432, 0.2993458673758396, 0.2993458673758396, \
-1.415137562308096, 0.2852818893449547, 0.2852818893449547, \
-1.444039357017578, 0.2704250775728045, 0.2704250775728045, \
-1.474572764363655, 0.2547268370970683, 0.2547268370970683, \
-1.506838596761410, 0.2381343376168658, 0.2381343376168658, \
-1.540946369510745, 0.2205900493024097, 0.2205900493024097, \
-1.577015183582633, 0.2020311935994785, 0.2020311935994785, \
-1.615174716281116, 0.1823890685785954, 0.1823890685785954, \
-1.655566335045787, 0.1615881644349673, 0.1615881644349673, \
-1.698344352132657, 0.1395448669703842, 0.1395448669703842, \
-1.743677440839071, 0.1161651811553210, 0.1161651811553210, \
-1.791750237413910, 0.09133952515983286, 0.09133952515983286, \
-1.842765156932309, 0.06492567199597812, 0.06492567199597812, \
-1.896944456355994, 0.03665209424049841, 0.03665209424049841, \
-1.954532583920982, 0.1462301137710065, -0.5029572669668763, \
0.9698635715389761, 0.5109472943639593, 0.5109472943639593, \
0.9827291586666034, 0.5071050854362820, 0.5071050854362820, \
0.9881115351944895, 0.5049616651446849, 0.5049616651446849, \
0.9918750398065496, 0.5031931583932677, 0.5031931583932677, \
0.9953530012640495, 0.5014334988264360, 0.5014334988264360, \
0.9989771848927988, 0.4995478411688126, 0.4995478411688126, \
1.002924595667546, 0.4974755419412193, 0.4974755419412193, 1.007281725006968, \
0.4951845874750058, 0.4951845874750058, 1.012097728802225, \
0.4926554287455662, 0.4926554287455662, 1.017404800027354, \
0.4898743641929428, 0.4898743641929428, 1.023227003627874, \
0.4868305194753608, 0.4868305194753608, 1.029584498367573, \
0.4835143424269394, 0.4835143424269394, 1.036495723960374, \
0.4799167942000327, 0.4799167942000327, 1.043978618746260, \
0.4760288830163511, 0.4760288830163511, 1.052051346368260, \
0.4718413758908869, 0.4718413758908869, 1.060732761699362, \
0.4673446066543730, 0.4673446066543730, 1.070042733509391, \
0.4625283374816565, 0.4625283374816565, 1.080002386982787, \
0.4573816503838253, 0.4573816503838253, 1.090634301615134, \
0.4518928551061215, 0.4518928551061215, 1.101962685414236, \
0.4460494052584507, 0.4460494052584507, 1.114013538320944, \
0.4398378175038195, 0.4398378175038195, 1.126814813243971, \
0.4332435903403204, 0.4332435903403204, 1.140396580500924, \
0.4262511200009701, 0.4262511200009701, 1.154791199949443, \
0.4188436115654103, 0.4188436115654103, 1.170033504229827, \
0.4110029836945714, 0.4110029836945714, 1.186160996074251, \
0.4027097655574605, 0.4027097655574605, 1.203214062425377, \
0.3939429845716131, 0.3939429845716131, 1.221236208066668, \
0.3846800435557341, 0.3846800435557341, 1.240274311550684, \
0.3748965858110926, 0.3748965858110926, 1.260378906393229, \
0.3645663465148331, 0.3645663465148331, 1.281604490766490, \
0.3536609886245106, 0.3536609886245106, 1.304009869267704, \
0.3421499212540043, 0.3421499212540043, 1.327658530761588, \
0.3300000981750790, 0.3300000981750790, 1.352619066799483, \
0.3171757937054519, 0.3171757937054519, 1.378965635714210, \
0.3036383527272108, 0.3036383527272108, 1.406778478188896, \
0.2893459108752258, 0.2893459108752258, 1.436144490915943, \
0.2742530799273280, 0.2742530799273280, 1.467157865918027, \
0.2583105918924212, 0.2583105918924212, 1.499920804220350, \
0.2414648927736113, 0.2414648927736113, 1.534544313871044, \
0.2236576724951585, 0.2236576724951585, 1.571149103839882, \
0.2048253087401503, 0.2048253087401503, 1.609866587126715, \
0.1848981837175869, 0.1848981837175869, 1.650840008532298, \
0.1637997883495982, 0.1637997883495982, 1.694225715048379, \
0.1414454090279450, 0.1414454090279450, 1.740194589788272, \
0.1177398214887886, 0.1177398214887886, 1.788933673897988, \
0.09257201625348146, 0.09257201625348146, 1.840648005077508, \
0.06579791400992566, 0.06579791400992566, 1.895562706344984, \
0.03714242455714629, 0.03714242455714629, 1.953925364670830, \
-2.000000000000000, -0.8003080819007085, 0.5814840736176077, \
0.1462301137710065, -0.8003080819007085, 0.5199709513182025, \
0.1690610471818295, -0.5029572669668763, 0.5814840736176077, \
0.1690610471818295, -0.9290896358111570, 0.5117775422752575, \
0.5117775422752575, -0.9936353489298798, 0.4993089623069012, \
0.4993089623069012, -1.005686003698882, 0.4957142172486279, \
0.4957142172486279, -1.010806389590204, 0.4936317684206364, \
0.4936317684206364, -1.014531490097471, 0.4918563025302863, \
0.4918563025302863, -1.018058182890484, 0.4900598904927172, \
0.4900598904927172, -1.021774609550457, 0.4881205868044634, \
0.4881205868044634, -1.025841984888401, 0.4859827196734157, \
0.4859827196734157, -1.030340397961640, 0.4836163644898592, \
0.4836163644898592, -1.035316267900590, 0.4810028587190524, \
0.4810028587190524, -1.040800676458759, 0.4781288225414502, \
0.4781288225414502, -1.046817383579288, 0.4749834079202532, \
0.4749834079202532, -1.053386687679176, 0.4715569170890371, \
0.4715569170890371, -1.060527441314262, 0.4678400539422029, \
0.4678400539422029, -1.068258183318933, 0.4638234883335870, \
0.4638234883335870, -1.076597821714499, 0.4594975834238079, \
0.4594975834238079, -1.085566077533035, 0.4548522113387669, \
0.4548522113387669, -1.095183797341148, 0.4498766177817665, \
0.4498766177817665, -1.105473192657283, 0.4445593138324722, \
0.4445593138324722, -1.116458039204279, 0.4388879823211569, \
0.4388879823211569, -1.128163855529709, 0.4328493911170718, \
0.4328493911170718, -1.140618073155180, 0.4264293084299539, \
0.4264293084299539, -1.153850206253517, 0.4196124167966930, \
0.4196124167966930, -1.167892026462263, 0.4123822233302808, \
0.4123822233302808, -1.182777747065755, 0.4047209643233051, \
0.4047209643233051, -1.198544220004396, 0.3966095025764327, \
0.3966095025764327, -1.215231148768601, 0.3880272159494908, \
0.3880272159494908, -1.232881320075440, 0.3789518756575990, \
0.3789518756575990, -1.251540857232832, 0.3693595127844090, \
0.3693595127844090, -1.271259498226205, 0.3592242713727277, \
0.3592242713727277, -1.292090901792132, 0.3485182462844618, \
0.3485182462844618, -1.314092985060910, 0.3372113037945634, \
0.3372113037945634, -1.337328296751899, 0.3252708825876591, \
0.3252708825876591, -1.361864430393882, 0.3126617724417560, \
0.3126617724417560, -1.387774482624432, 0.2993458673758396, \
0.2993458673758396, -1.415137562308096, 0.2852818893449547, \
0.2852818893449547, -1.444039357017578, 0.2704250775728045, \
0.2704250775728045, -1.474572764363655, 0.2547268370970683, \
0.2547268370970683, -1.506838596761410, 0.2381343376168658, \
0.2381343376168658, -1.540946369510745, 0.2205900493024097, \
0.2205900493024097, -1.577015183582633, 0.2020311935994785, \
0.2020311935994785, -1.615174716281116, 0.1823890685785954, \
0.1823890685785954, -1.655566335045787, 0.1615881644349673, \
0.1615881644349673, -1.698344352132657, 0.1395448669703842, \
0.1395448669703842, -1.743677440839071, 0.1161651811553210, \
0.1161651811553210, -1.791750237413910, 0.09133952515983286, \
0.09133952515983286, -1.842765156932309, 0.06492567199597812, \
0.06492567199597812, -1.896944456355994, 0.03665209424049841, \
0.03665209424049841, -1.954532583920982, 0.1462301137710065, \
-0.5029572669668763, 0.9698635715389761, 0.5109472943639593, \
0.5109472943639593, 0.9827291586666034, 0.5071050854362820, \
0.5071050854362820, 0.9881115351944895, 0.5049616651446849, \
0.5049616651446849, 0.9918750398065496, 0.5031931583932677, \
0.5031931583932677, 0.9953530012640495, 0.5014334988264360, \
0.5014334988264360, 0.9989771848927988, 0.4995478411688126, \
0.4995478411688126, 1.002924595667546, 0.4974755419412193, \
0.4974755419412193, 1.007281725006968, 0.4951845874750058, \
0.4951845874750058, 1.012097728802225, 0.4926554287455662, \
0.4926554287455662, 1.017404800027354, 0.4898743641929428, \
0.4898743641929428, 1.023227003627874, 0.4868305194753608, \
0.4868305194753608, 1.029584498367573, 0.4835143424269394, \
0.4835143424269394, 1.036495723960374, 0.4799167942000327, \
0.4799167942000327, 1.043978618746260, 0.4760288830163511, \
0.4760288830163511, 1.052051346368260, 0.4718413758908869, \
0.4718413758908869, 1.060732761699362, 0.4673446066543730, \
0.4673446066543730, 1.070042733509391, 0.4625283374816565, \
0.4625283374816565, 1.080002386982787, 0.4573816503838253, \
0.4573816503838253, 1.090634301615134, 0.4518928551061215, \
0.4518928551061215, 1.101962685414236, 0.4460494052584507, \
0.4460494052584507, 1.114013538320944, 0.4398378175038195, \
0.4398378175038195, 1.126814813243971, 0.4332435903403204, \
0.4332435903403204, 1.140396580500924, 0.4262511200009701, \
0.4262511200009701, 1.154791199949443, 0.4188436115654103, \
0.4188436115654103, 1.170033504229827, 0.4110029836945714, \
0.4110029836945714, 1.186160996074251, 0.4027097655574605, \
0.4027097655574605, 1.203214062425377, 0.3939429845716131, \
0.3939429845716131, 1.221236208066668, 0.3846800435557341, \
0.3846800435557341, 1.240274311550684, 0.3748965858110926, \
0.3748965858110926, 1.260378906393229, 0.3645663465148331, \
0.3645663465148331, 1.281604490766490, 0.3536609886245106, \
0.3536609886245106, 1.304009869267704, 0.3421499212540043, \
0.3421499212540043, 1.327658530761588, 0.3300000981750790, \
0.3300000981750790, 1.352619066799483, 0.3171757937054519, \
0.3171757937054519, 1.378965635714210, 0.3036383527272108, \
0.3036383527272108, 1.406778478188896, 0.2893459108752258, \
0.2893459108752258, 1.436144490915943, 0.2742530799273280, \
0.2742530799273280, 1.467157865918027, 0.2583105918924212, \
0.2583105918924212, 1.499920804220350, 0.2414648927736113, \
0.2414648927736113, 1.534544313871044, 0.2236576724951585, \
0.2236576724951585, 1.571149103839882, 0.2048253087401503, \
0.2048253087401503, 1.609866587126715, 0.1848981837175869, \
0.1848981837175869, 1.650840008532298, 0.1637997883495982, \
0.1637997883495982, 1.694225715048379, 0.1414454090279450, \
0.1414454090279450, 1.740194589788272, 0.1177398214887886, \
0.1177398214887886, 1.788933673897988, 0.09257201625348146, \
0.09257201625348146, 1.840648005077508, 0.06579791400992566, \
0.06579791400992566, 1.895562706344984, 0.03714242455714629, \
0.03714242455714629, 1.953925364670830})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.779359894829289*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"2835351b-48a2-4595-8a0e-b07d4d344697"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -3", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.779359280778961*^9}, 
   3.779359382792078*^9},ExpressionUUID->"d471b476-d82c-4a70-9862-\
9bfde319678d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, {3.779359285341239*^9, 
   3.779359286580131*^9}, 3.779359455652924*^9},
 CellLabel->"In[39]:=",ExpressionUUID->"16088a9f-b657-48fc-aacd-1509f1205c7a"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-3.000000000000000, \
-0.7818769970730661, 0.6141765447865052, 0.1070305250015839, \
-0.7818769970730661, 0.6055489719920239, 0.1274511493898093, \
-0.5157712452722260, 0.6141765447865052, 0.1274511493898093, \
-0.9150932656248305, 0.5136546749034019, 0.5136546749034019, \
-0.9929677562241461, 0.4991158939248755, 0.4991158939248755, \
-1.006482002662002, 0.4952254199946390, 0.4952254199946390, \
-1.011870638361837, 0.4930785706634111, 0.4930785706634111, \
-1.015656815588510, 0.4912906670168690, 0.4912906670168690, \
-1.019187692920314, 0.4894983977574309, 0.4894983977574309, \
-1.022888043780122, 0.4875696370890506, 0.4875696370890506, \
-1.026931060217096, 0.4854450304730851, 0.4854450304730851, \
-1.031401531054120, 0.4830931083801311, 0.4830931083801311, \
-1.036347959055039, 0.4804944910869953, 0.4804944910869953, \
-1.041802430712534, 0.4776354420835578, 0.4776354420835578, \
-1.047789217938784, 0.4745049283377965, 0.4745049283377965, \
-1.054328887565117, 0.4710931547976197, 0.4710931547976197, \
-1.061440432421664, 0.4673907754528990, 0.4673907754528990, \
-1.069142460736184, 0.4633884370253268, 0.4633884370253268, \
-1.077453909100974, 0.4590764952285226, 0.4590764952285226, \
-1.086394502833482, 0.4544448242011512, 0.4544448242011512, \
-1.095985077959545, 0.4494826774973243, 0.4494826774973243, \
-1.106247826218565, 0.4441785777167005, 0.4441785777167005, \
-1.117206497703186, 0.4385202215501990, 0.4385202215501990, \
-1.128886581572884, 0.4324943922415585, 0.4324943922415585, \
-1.141315477512678, 0.4260868743702386, 0.4260868743702386, \
-1.154522666231797, 0.4192823675138055, 0.4192823675138055, \
-1.168539884787205, 0.4120643962981633, 0.4120643962981633, \
-1.183401311072053, 0.4044152148854404, 0.4044152148854404, \
-1.199143760994903, 0.3963157042432571, 0.3963157042432571, \
-1.215806901449877, 0.3877452606759220, 0.3877452606759220, \
-1.233433482003160, 0.3786816741289935, 0.3786816741289935, \
-1.252069588218506, 0.3691009947321336, 0.3691009947321336, \
-1.271764919668160, 0.3589773859359445, 0.3589773859359445, \
-1.292573095901103, 0.3482829624318602, 0.3482829624318602, \
-1.314551993955128, 0.3369876108181013, 0.3369876108181013, \
-1.337764121399187, 0.3250587906795733, 0.3250587906795733, \
-1.362277029379419, 0.3124613133659755, 0.3124613133659755, \
-1.388163770722969, 0.2991570952453843, 0.2991570952453843, \
-1.415503408838645, 0.2851048815179057, 0.2851048815179057, \
-1.444381583957099, 0.2702599356810705, 0.2702599356810705, \
-1.474891144194152, 0.2545736882246459, 0.2545736882246459, \
-1.507132850022044, 0.2379933356480595, 0.2379933356480595, \
-1.541216162023165, 0.2204613764664990, 0.2204613764664990, \
-1.577260123313600, 0.2019150622487265, 0.2019150622487265, \
-1.615394349801631, 0.1822857232563269, 0.1822857232563269, \
-1.655760143540167, 0.1614978843327939, 0.1614978843327939, \
-1.698511746904296, 0.1394679689765159, 0.1394679689765159, \
-1.743817758251714, 0.1161020239869851, 0.1161020239869851, \
-1.791862733198026, 0.09129051607551122, 0.09129051607551122, \
-1.842848999775310, 0.06489128217838391, 0.06489128217838391, \
-1.896998720682268, 0.03663292384662767, 0.03663292384662767, \
-1.954556241752673, 0.1070305250015839, -0.5157712452722260, \
0.9668783844444286, 0.5119935608836126, 0.5119935608836126, \
0.9809426938044753, 0.5079368458432851, 0.5079368458432851, \
0.9865034436705292, 0.5057523983120168, 0.5057523983120168, \
0.9903061256595464, 0.5039751139023713, 0.5039751139023713, \
0.9937897270423671, 0.5022161470300025, 0.5022161470300025, \
0.9974081912101498, 0.5003347331222990, 0.5003347331222990, \
1.001345314618830, 0.4982681687265588, 0.4982681687265588, 1.005690206960279, \
0.4959835750751831, 0.4959835750751831, 1.010493208231263, \
0.4934609849410352, 0.4934609849410352, 1.015787120330390, \
0.4906864686068844, 0.4906864686068844, 1.021596360153148, \
0.4876490120857537, 0.4876490120857537, 1.027941314526525, \
0.4843389674415194, 0.4843389674415194, 1.034840588516779, \
0.4807472225669724, 0.4807472225669724, 1.042312253490719, \
0.4768647239510198, 0.4768647239510198, 1.050374589931641, \
0.4726821823830971, 0.4726821823830971, 1.059046562485280, \
0.4681898774692740, 0.4681898774692740, 1.068348148104493, \
0.4633775169865330, 0.4633775169865330, 1.078300582077023, \
0.4582341269328968, 0.4582341269328968, 1.088926558335455, \
0.4527479583957519, 0.4527479583957519, 1.100250405449390, \
0.4469064028874916, 0.4469064028874916, 1.112298251484045, \
0.4406959108709969, 0.4406959108709969, 1.125098186278252, \
0.4341019099486329, 0.4341019099486329, 1.138680427031768, \
0.4271087202001046, 0.4271087202001046, 1.153077491548637, \
0.4196994647374239, 0.4196994647374239, 1.168324382600729, \
0.4118559738700396, 0.4118559738700396, 1.184458786397432, \
0.4035586814357374, 0.4035586814357374, 1.201521287928339, \
0.3947865119078664, 0.3947865119078664, 1.219555605901421, \
0.3855167568677900, 0.3855167568677900, 1.238608850081248, \
0.3757249393500661, 0.3757249393500661, 1.258731804012738, \
0.3653846644344654, 0.3653846644344654, 1.279979236381504, \
0.3544674542746596, 0.3544674542746596, 1.302410244606228, \
0.3429425655134742, 0.3429425655134742, 1.326088634681758, \
0.3307767867275630, 0.3307767867275630, 1.351083341798448, \
0.3179342131494108, 0.3179342131494108, 1.377468896861938, \
0.3043759953955092, 0.3043759953955092, 1.405325944740056, \
0.2900600582226142, 0.2900600582226142, 1.434741820885195, \
0.2749407843223330, 0.2749407843223330, 1.465811193940790, \
0.2589686566231481, 0.2589686566231481, 1.498636783063109, \
0.2420898500412113, 0.2420898500412113, 1.533330160003523, \
0.2242457591181101, 0.2242457591181101, 1.570012647536969, \
0.2053724392138999, 0.2053724392138999, 1.608816327632260, \
0.1853999201369080, 0.1853999201369080, 1.649885174891279, \
0.1642513064266157, 0.1642513064266157, 1.693376333300389, \
0.1418414587996126, 0.1418414587996126, 1.739461557315982, \
0.1180746795404630, 0.1180746795404630, 1.788328841841926, \
0.09283942026429516, 0.09283942026429516, 1.840184269866344, \
0.06599094295150015, 0.06599094295150015, 1.895254111552578, \
0.03725307949753140, 0.03725307949753140, 1.953787214602251, \
-3.000000000000000, -0.7818769970730661, 0.6141765447865052, \
0.1070305250015839, -0.7818769970730661, 0.6055489719920239, \
0.1274511493898093, -0.5157712452722260, 0.6141765447865052, \
0.1274511493898093, -0.9150932656248305, 0.5136546749034019, \
0.5136546749034019, -0.9929677562241461, 0.4991158939248755, \
0.4991158939248755, -1.006482002662002, 0.4952254199946390, \
0.4952254199946390, -1.011870638361837, 0.4930785706634111, \
0.4930785706634111, -1.015656815588510, 0.4912906670168690, \
0.4912906670168690, -1.019187692920314, 0.4894983977574309, \
0.4894983977574309, -1.022888043780122, 0.4875696370890506, \
0.4875696370890506, -1.026931060217096, 0.4854450304730851, \
0.4854450304730851, -1.031401531054120, 0.4830931083801311, \
0.4830931083801311, -1.036347959055039, 0.4804944910869953, \
0.4804944910869953, -1.041802430712534, 0.4776354420835578, \
0.4776354420835578, -1.047789217938784, 0.4745049283377965, \
0.4745049283377965, -1.054328887565117, 0.4710931547976197, \
0.4710931547976197, -1.061440432421664, 0.4673907754528990, \
0.4673907754528990, -1.069142460736184, 0.4633884370253268, \
0.4633884370253268, -1.077453909100974, 0.4590764952285226, \
0.4590764952285226, -1.086394502833482, 0.4544448242011512, \
0.4544448242011512, -1.095985077959545, 0.4494826774973243, \
0.4494826774973243, -1.106247826218565, 0.4441785777167005, \
0.4441785777167005, -1.117206497703186, 0.4385202215501990, \
0.4385202215501990, -1.128886581572884, 0.4324943922415585, \
0.4324943922415585, -1.141315477512678, 0.4260868743702386, \
0.4260868743702386, -1.154522666231797, 0.4192823675138055, \
0.4192823675138055, -1.168539884787205, 0.4120643962981633, \
0.4120643962981633, -1.183401311072053, 0.4044152148854404, \
0.4044152148854404, -1.199143760994903, 0.3963157042432571, \
0.3963157042432571, -1.215806901449877, 0.3877452606759220, \
0.3877452606759220, -1.233433482003160, 0.3786816741289935, \
0.3786816741289935, -1.252069588218506, 0.3691009947321336, \
0.3691009947321336, -1.271764919668160, 0.3589773859359445, \
0.3589773859359445, -1.292573095901103, 0.3482829624318602, \
0.3482829624318602, -1.314551993955128, 0.3369876108181013, \
0.3369876108181013, -1.337764121399187, 0.3250587906795733, \
0.3250587906795733, -1.362277029379419, 0.3124613133659755, \
0.3124613133659755, -1.388163770722969, 0.2991570952453843, \
0.2991570952453843, -1.415503408838645, 0.2851048815179057, \
0.2851048815179057, -1.444381583957099, 0.2702599356810705, \
0.2702599356810705, -1.474891144194152, 0.2545736882246459, \
0.2545736882246459, -1.507132850022044, 0.2379933356480595, \
0.2379933356480595, -1.541216162023165, 0.2204613764664990, \
0.2204613764664990, -1.577260123313600, 0.2019150622487265, \
0.2019150622487265, -1.615394349801631, 0.1822857232563269, \
0.1822857232563269, -1.655760143540167, 0.1614978843327939, \
0.1614978843327939, -1.698511746904296, 0.1394679689765159, \
0.1394679689765159, -1.743817758251714, 0.1161020239869851, \
0.1161020239869851, -1.791862733198026, 0.09129051607551122, \
0.09129051607551122, -1.842848999775310, 0.06489128217838391, \
0.06489128217838391, -1.896998720682268, 0.03663292384662767, \
0.03663292384662767, -1.954556241752673, 0.1070305250015839, \
-0.5157712452722260, 0.9668783844444286, 0.5119935608836126, \
0.5119935608836126, 0.9809426938044753, 0.5079368458432851, \
0.5079368458432851, 0.9865034436705292, 0.5057523983120168, \
0.5057523983120168, 0.9903061256595464, 0.5039751139023713, \
0.5039751139023713, 0.9937897270423671, 0.5022161470300025, \
0.5022161470300025, 0.9974081912101498, 0.5003347331222990, \
0.5003347331222990, 1.001345314618830, 0.4982681687265588, \
0.4982681687265588, 1.005690206960279, 0.4959835750751831, \
0.4959835750751831, 1.010493208231263, 0.4934609849410352, \
0.4934609849410352, 1.015787120330390, 0.4906864686068844, \
0.4906864686068844, 1.021596360153148, 0.4876490120857537, \
0.4876490120857537, 1.027941314526525, 0.4843389674415194, \
0.4843389674415194, 1.034840588516779, 0.4807472225669724, \
0.4807472225669724, 1.042312253490719, 0.4768647239510198, \
0.4768647239510198, 1.050374589931641, 0.4726821823830971, \
0.4726821823830971, 1.059046562485280, 0.4681898774692740, \
0.4681898774692740, 1.068348148104493, 0.4633775169865330, \
0.4633775169865330, 1.078300582077023, 0.4582341269328968, \
0.4582341269328968, 1.088926558335455, 0.4527479583957519, \
0.4527479583957519, 1.100250405449390, 0.4469064028874916, \
0.4469064028874916, 1.112298251484045, 0.4406959108709969, \
0.4406959108709969, 1.125098186278252, 0.4341019099486329, \
0.4341019099486329, 1.138680427031768, 0.4271087202001046, \
0.4271087202001046, 1.153077491548637, 0.4196994647374239, \
0.4196994647374239, 1.168324382600729, 0.4118559738700396, \
0.4118559738700396, 1.184458786397432, 0.4035586814357374, \
0.4035586814357374, 1.201521287928339, 0.3947865119078664, \
0.3947865119078664, 1.219555605901421, 0.3855167568677900, \
0.3855167568677900, 1.238608850081248, 0.3757249393500661, \
0.3757249393500661, 1.258731804012738, 0.3653846644344654, \
0.3653846644344654, 1.279979236381504, 0.3544674542746596, \
0.3544674542746596, 1.302410244606228, 0.3429425655134742, \
0.3429425655134742, 1.326088634681758, 0.3307767867275630, \
0.3307767867275630, 1.351083341798448, 0.3179342131494108, \
0.3179342131494108, 1.377468896861938, 0.3043759953955092, \
0.3043759953955092, 1.405325944740056, 0.2900600582226142, \
0.2900600582226142, 1.434741820885195, 0.2749407843223330, \
0.2749407843223330, 1.465811193940790, 0.2589686566231481, \
0.2589686566231481, 1.498636783063109, 0.2420898500412113, \
0.2420898500412113, 1.533330160003523, 0.2242457591181101, \
0.2242457591181101, 1.570012647536969, 0.2053724392138999, \
0.2053724392138999, 1.608816327632260, 0.1853999201369080, \
0.1853999201369080, 1.649885174891279, 0.1642513064266157, \
0.1642513064266157, 1.693376333300389, 0.1418414587996126, \
0.1418414587996126, 1.739461557315982, 0.1180746795404630, \
0.1180746795404630, 1.788328841841926, 0.09283942026429516, \
0.09283942026429516, 1.840184269866344, 0.06599094295150015, \
0.06599094295150015, 1.895254111552578, 0.03725307949753140, \
0.03725307949753140, 1.953787214602251})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.7793599638809757`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"2a0da20b-a886-4f31-8277-d920cbd8599c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -4", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.779359280778961*^9}, 
   3.779359383670624*^9},ExpressionUUID->"8e0aaf75-9b18-4d2d-8dcd-\
3bafd2df6b4c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, {3.779359285341239*^9, 
   3.779359286580131*^9}, 3.7793594513062153`*^9},
 CellLabel->"In[44]:=",ExpressionUUID->"08e3dc48-6400-4aa3-8b65-f600bca13390"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-4.000000000000000, \
-0.7695643972995068, 0.6330124843520016, 0.08405850976286574, \
-0.7695643972995068, 0.6551149418017047, 0.1019334742126064, \
-0.5220079714435750, 0.6330124843520016, 0.1019334742126064, \
-0.9059540865957644, 0.5148800309917754, 0.5148800309917754, \
-0.9924916383814540, 0.4990271543995733, 0.4990271543995733, \
-1.006905519390243, 0.4949604926967328, 0.4949604926967328, \
-1.012450468673876, 0.4927765602498833, 0.4927765602498833, \
-1.016271813070777, 0.4909813281175063, 0.4909813281175063, \
-1.019805758109009, 0.4891909902144873, 0.4891909902144873, \
-1.023497937957363, 0.4872676971779745, 0.4872676971779745, \
-1.027528213061143, 0.4851500596285501, 0.4851500596285501, \
-1.031983953586258, 0.4828057634338155, 0.4828057634338155, \
-1.036914797387561, 0.4802150391639031, 0.4802150391639031, \
-1.042353376044179, 0.4773639569236482, 0.4773639569236482, \
-1.048324239137995, 0.4742413831999994, 0.4742413831999994, \
-1.054848099696732, 0.4708374697174989, 0.4708374697174989, \
-1.061944027800891, 0.4671428427135920, 0.4671428427135920, \
-1.069630670838989, 0.4631481355468019, 0.4631481355468019, \
-1.077926982606874, 0.4588436990159994, 0.4588436990159994, \
-1.086852692517060, 0.4542194074660737, 0.4542194074660737, \
-1.096428632633652, 0.4492645178453905, 0.4492645178453905, \
-1.106676985658776, 0.4439675581788496, 0.4439675581788496, \
-1.117621489379577, 0.4383162319043561, 0.4383162319043561, \
-1.129287618500223, 0.4322973298921030, 0.4322973298921030, \
-1.141702756802133, 0.4258966449490774, 0.4258966449490774, \
-1.154896368084725, 0.4190988853063973, 0.4190988853063973, \
-1.168900171765307, 0.4118875845613575, 0.4118875845613575, \
-1.183748327535329, 0.4042450061014964, 0.4042450061014964, \
-1.199477632634457, 0.3961520403402737, 0.3961520403402737, \
-1.216127734865173, 0.3875880932358823, 0.3875880932358823, \
-1.233741364287843, 0.3785309645988154, 0.3785309645988154, \
-1.252364586528262, 0.3689567146493505, 0.3689567146493505, \
-1.272047080750202, 0.3588395171782292, 0.3588395171782292, \
-1.292842445568699, 0.3481514974981008, 0.3481514974981008, \
-1.314808536493034, 0.3368625531478702, 0.3368625531478702, \
-1.338007838887137, 0.3249401550174267, 0.3249401550174267, \
-1.362507880921451, 0.3123491261769817, 0.3123491261769817, \
-1.388381691570355, 0.2990513951885510, 0.2990513951885510, \
-1.415708309393725, 0.2850057199847560, 0.2850057199847560, \
-1.444573348644489, 0.2701673774075471, 0.2701673774075471, \
-1.475069630184546, 0.2544878119859226, 0.2544878119859226, \
-1.507297885792288, 0.2379142350479641, 0.2379142350479641, \
-1.541367545734320, 0.2203891608366485, 0.2203891608366485, \
-1.577397620986403, 0.2018498576783398, 0.2018498576783398, \
-1.615517693265983, 0.1822276737848554, 0.1822276737848554, \
-1.655869028132062, 0.1614471533613705, 0.1614471533613705, \
-1.698605828879765, 0.1394247410121588, 0.1394247410121588, \
-1.743896651882922, 0.1160665069974430, 0.1160665069974430, \
-1.791926007511398, 0.09126294529735365, 0.09126294529735365, \
-1.842896174885447, 0.06487192880892726, 0.06487192880892726, \
-1.897029263668151, 0.03662213170856658, 0.03662213170856658, \
-1.954569562014164, 0.08405850976286574, -0.5220079714435750, \
0.9650139775197283, 0.5126113409365141, 0.5126113409365141, \
0.9799221216719215, 0.5084041856616196, 0.5084041856616196, \
0.9856071698434561, 0.5061914353739795, 0.5061914353739795, \
0.9894363912746566, 0.5044084586208114, 0.5044084586208114, \
0.9929230077691251, 0.5026504657792166, 0.5026504657792166, \
0.9965364295381246, 0.5007725782407024, 0.5007725782407024, \
1.000465158088812, 0.4987106700187821, 0.4987106700187821, 1.004800105076505, \
0.4964312691768525, 0.4964312691768525, 1.009592418982182, \
0.4939141243304481, 0.4939141243304481, 1.014875313147652, \
0.4911451525782432, 0.4911451525782432, 1.020673439097440, \
0.4881132475495365, 0.4881132475495365, 1.027007333343515, \
0.4848086989432838, 0.4848086989432838, 1.033895707846702, \
0.4812223475921723, 0.4812223475921723, 1.041356719002580, \
0.4773451006629788, 0.4773451006629788, 1.049408721586871, \
0.4731676332022884, 0.4731676332022884, 1.058070750119620, \
0.4686801902130358, 0.4686801902130358, 1.067362850843013, \
0.4638724444759007, 0.4638724444759007, 1.077306330247864, \
0.4587333855607160, 0.4587333855607160, 1.087923957146584, \
0.4532512259305048, 0.4532512259305048, 1.099240140018868, \
0.4474133156649335, 0.4474133156649335, 1.111281092999775, \
0.4412060604546013, 0.4412060604546013, 1.124074999173413, \
0.4346148392966256, 0.4346148392966256, 1.137652177130727, \
0.4276239193492471, 0.4276239193492471, 1.152045255183229, \
0.4202163659949867, 0.4202163659949867, 1.167289356728338, \
0.4123739464918070, 0.4123739464918070, 1.183422299776128, \
0.4040770257572034, 0.4040770257572034, 1.200484813423723, \
0.3953044528866794, 0.3953044528866794, 1.218520774017029, \
0.3860334369871432, 0.3860334369871432, 1.237577463820590, \
0.3762394108245412, 0.3762394108245412, 1.257705855197325, \
0.3658958806514193, 0.3658958806514193, 1.278960923566170, \
0.3549742603952720, 0.3549742603952720, 1.301401992751218, \
0.3434436881477655, 0.3434436881477655, 1.325093116760944, \
0.3312708225867611, 0.3312708225867611, 1.350103502545046, \
0.3184196165666701, 0.3184196165666701, 1.376507978877750, \
0.3048510645917663, 0.3048510645917663, 1.404387517221977, \
0.2905229201777612, 0.2905229201777612, 1.433829811254137, \
0.2753893780920848, 0.2753893780920848, 1.464929922693840, \
0.2594007149176646, 0.2594007149176646, 1.497791002210428, \
0.2425028788503821, 0.2425028788503821, 1.532525095498062, \
0.2246370151259291, 0.2246370151259291, 1.569254046158503, \
0.2057389046811091, 0.2057389046811091, 1.608110508848767, \
0.1857382748251995, 0.1857382748251995, 1.649239088291718, \
0.1645578959331568, 0.1645578959331568, 1.692797622275176, \
0.1421122582057943, 0.1421122582057943, 1.738958629756974, \
0.1183052500115695, 0.1183052500115695, 1.787910948745035, \
0.09302485194837477, 0.09302485194837477, 1.839861592849956, \
0.06612575800880312, 0.06612575800880312, 1.895037860457435, \
0.03733092118746452, 0.03733092118746452, 1.953689736517830, \
-4.000000000000000, -0.7695643972995068, 0.6330124843520016, \
0.08405850976286574, -0.7695643972995068, 0.6551149418017047, \
0.1019334742126064, -0.5220079714435750, 0.6330124843520016, \
0.1019334742126064, -0.9059540865957644, 0.5148800309917754, \
0.5148800309917754, -0.9924916383814540, 0.4990271543995733, \
0.4990271543995733, -1.006905519390243, 0.4949604926967328, \
0.4949604926967328, -1.012450468673876, 0.4927765602498833, \
0.4927765602498833, -1.016271813070777, 0.4909813281175063, \
0.4909813281175063, -1.019805758109009, 0.4891909902144873, \
0.4891909902144873, -1.023497937957363, 0.4872676971779745, \
0.4872676971779745, -1.027528213061143, 0.4851500596285501, \
0.4851500596285501, -1.031983953586258, 0.4828057634338155, \
0.4828057634338155, -1.036914797387561, 0.4802150391639031, \
0.4802150391639031, -1.042353376044179, 0.4773639569236482, \
0.4773639569236482, -1.048324239137995, 0.4742413831999994, \
0.4742413831999994, -1.054848099696732, 0.4708374697174989, \
0.4708374697174989, -1.061944027800891, 0.4671428427135920, \
0.4671428427135920, -1.069630670838989, 0.4631481355468019, \
0.4631481355468019, -1.077926982606874, 0.4588436990159994, \
0.4588436990159994, -1.086852692517060, 0.4542194074660737, \
0.4542194074660737, -1.096428632633652, 0.4492645178453905, \
0.4492645178453905, -1.106676985658776, 0.4439675581788496, \
0.4439675581788496, -1.117621489379577, 0.4383162319043561, \
0.4383162319043561, -1.129287618500223, 0.4322973298921030, \
0.4322973298921030, -1.141702756802133, 0.4258966449490774, \
0.4258966449490774, -1.154896368084725, 0.4190988853063973, \
0.4190988853063973, -1.168900171765307, 0.4118875845613575, \
0.4118875845613575, -1.183748327535329, 0.4042450061014964, \
0.4042450061014964, -1.199477632634457, 0.3961520403402737, \
0.3961520403402737, -1.216127734865173, 0.3875880932358823, \
0.3875880932358823, -1.233741364287843, 0.3785309645988154, \
0.3785309645988154, -1.252364586528262, 0.3689567146493505, \
0.3689567146493505, -1.272047080750202, 0.3588395171782292, \
0.3588395171782292, -1.292842445568699, 0.3481514974981008, \
0.3481514974981008, -1.314808536493034, 0.3368625531478702, \
0.3368625531478702, -1.338007838887137, 0.3249401550174267, \
0.3249401550174267, -1.362507880921451, 0.3123491261769817, \
0.3123491261769817, -1.388381691570355, 0.2990513951885510, \
0.2990513951885510, -1.415708309393725, 0.2850057199847560, \
0.2850057199847560, -1.444573348644489, 0.2701673774075471, \
0.2701673774075471, -1.475069630184546, 0.2544878119859226, \
0.2544878119859226, -1.507297885792288, 0.2379142350479641, \
0.2379142350479641, -1.541367545734320, 0.2203891608366485, \
0.2203891608366485, -1.577397620986403, 0.2018498576783398, \
0.2018498576783398, -1.615517693265983, 0.1822276737848554, \
0.1822276737848554, -1.655869028132062, 0.1614471533613705, \
0.1614471533613705, -1.698605828879765, 0.1394247410121588, \
0.1394247410121588, -1.743896651882922, 0.1160665069974430, \
0.1160665069974430, -1.791926007511398, 0.09126294529735365, \
0.09126294529735365, -1.842896174885447, 0.06487192880892726, \
0.06487192880892726, -1.897029263668151, 0.03662213170856658, \
0.03662213170856658, -1.954569562014164, 0.08405850976286574, \
-0.5220079714435750, 0.9650139775197283, 0.5126113409365141, \
0.5126113409365141, 0.9799221216719215, 0.5084041856616196, \
0.5084041856616196, 0.9856071698434561, 0.5061914353739795, \
0.5061914353739795, 0.9894363912746566, 0.5044084586208114, \
0.5044084586208114, 0.9929230077691251, 0.5026504657792166, \
0.5026504657792166, 0.9965364295381246, 0.5007725782407024, \
0.5007725782407024, 1.000465158088812, 0.4987106700187821, \
0.4987106700187821, 1.004800105076505, 0.4964312691768525, \
0.4964312691768525, 1.009592418982182, 0.4939141243304481, \
0.4939141243304481, 1.014875313147652, 0.4911451525782432, \
0.4911451525782432, 1.020673439097440, 0.4881132475495365, \
0.4881132475495365, 1.027007333343515, 0.4848086989432838, \
0.4848086989432838, 1.033895707846702, 0.4812223475921723, \
0.4812223475921723, 1.041356719002580, 0.4773451006629788, \
0.4773451006629788, 1.049408721586871, 0.4731676332022884, \
0.4731676332022884, 1.058070750119620, 0.4686801902130358, \
0.4686801902130358, 1.067362850843013, 0.4638724444759007, \
0.4638724444759007, 1.077306330247864, 0.4587333855607160, \
0.4587333855607160, 1.087923957146584, 0.4532512259305048, \
0.4532512259305048, 1.099240140018868, 0.4474133156649335, \
0.4474133156649335, 1.111281092999775, 0.4412060604546013, \
0.4412060604546013, 1.124074999173413, 0.4346148392966256, \
0.4346148392966256, 1.137652177130727, 0.4276239193492471, \
0.4276239193492471, 1.152045255183229, 0.4202163659949867, \
0.4202163659949867, 1.167289356728338, 0.4123739464918070, \
0.4123739464918070, 1.183422299776128, 0.4040770257572034, \
0.4040770257572034, 1.200484813423723, 0.3953044528866794, \
0.3953044528866794, 1.218520774017029, 0.3860334369871432, \
0.3860334369871432, 1.237577463820590, 0.3762394108245412, \
0.3762394108245412, 1.257705855197325, 0.3658958806514193, \
0.3658958806514193, 1.278960923566170, 0.3549742603952720, \
0.3549742603952720, 1.301401992751218, 0.3434436881477655, \
0.3434436881477655, 1.325093116760944, 0.3312708225867611, \
0.3312708225867611, 1.350103502545046, 0.3184196165666701, \
0.3184196165666701, 1.376507978877750, 0.3048510645917663, \
0.3048510645917663, 1.404387517221977, 0.2905229201777612, \
0.2905229201777612, 1.433829811254137, 0.2753893780920848, \
0.2753893780920848, 1.464929922693840, 0.2594007149176646, \
0.2594007149176646, 1.497791002210428, 0.2425028788503821, \
0.2425028788503821, 1.532525095498062, 0.2246370151259291, \
0.2246370151259291, 1.569254046158503, 0.2057389046811091, \
0.2057389046811091, 1.608110508848767, 0.1857382748251995, \
0.1857382748251995, 1.649239088291718, 0.1645578959331568, \
0.1645578959331568, 1.692797622275176, 0.1421122582057943, \
0.1421122582057943, 1.738958629756974, 0.1183052500115695, \
0.1183052500115695, 1.787910948745035, 0.09302485194837477, \
0.09302485194837477, 1.839861592849956, 0.06612575800880312, \
0.06612575800880312, 1.895037860457435, 0.03733092118746452, \
0.03733092118746452, 1.953689736517830})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.7793600305941267`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"7e809dfe-622e-461a-a5e8-4d1623b626da"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -5", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.779359280778961*^9}, 
   3.779359384768524*^9},ExpressionUUID->"af405e26-d093-41c2-ab4e-\
bcf2849b819d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, {3.779359285341239*^9, 
   3.779359286580131*^9}, 3.7793594468236322`*^9},
 CellLabel->"In[49]:=",ExpressionUUID->"94a00175-135d-400d-b020-2950e3fe4142"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-5.000000000000000, \
-0.7609230998987977, 0.6451517227815950, 0.06910347771526625, \
-0.7609230998987977, 0.6871284512254478, 0.08482732986841036, \
-0.5255644350395376, 0.6451517227815950, 0.08482732986841036, \
-0.8996138963021735, 0.5157270611443916, 0.5157270611443916, \
-0.9921514020355521, 0.4989776892229326, 0.4989776892229326, \
-1.007166178402008, 0.4947958056425984, 0.4947958056425984, \
-1.012811784699518, 0.4925882076362137, 0.4925882076362137, \
-1.016655523492265, 0.4907882660354490, 0.4907882660354490, \
-1.020191609466177, 0.4889990231545625, 0.4889990231545625, \
-1.023878915008522, 0.4870790272128977, 0.4870790272128977, \
-1.027901471915058, 0.4849656219440368, 0.4849656219440368, \
-1.032348251651405, 0.4826259707451153, 0.4826259707451153, \
-1.037269592766972, 0.4800400639736588, 0.4800400639736588, \
-1.042698462532070, 0.4771938526735618, 0.4771938526735618, \
-1.048659581535952, 0.4740761413865373, 0.4740761413865373, \
-1.055173753097158, 0.4706770488745427, 0.4706770488745427, \
-1.062260095334682, 0.4669871840150758, 0.4669871840150758, \
-1.069937280345647, 0.4629971716222484, 0.4629971716222484, \
-1.078224273174225, 0.4586973591349450, 0.4586973591349450, \
-1.087140806425165, 0.4540776206916017, 0.4540776206916017, \
-1.096707710380503, 0.4491272150088633, 0.4491272150088633, \
-1.106947162803786, 0.4438346731491573, 0.4438346731491573, \
-1.117882894489209, 0.4381877024245137, 0.4381877024245137, \
-1.129540371776221, 0.4321730981457237, 0.4321730981457237, \
-1.141946969138610, 0.4257766579564583, 0.4257766579564583, \
-1.155132140396202, 0.4189830952131352, 0.4189830952131352, \
-1.169127594484778, 0.4117759488602348, 0.4117759488602348, \
-1.183967480216163, 0.4041374878147248, 0.4041374878147248, \
-1.199688583611518, 0.3960486081806023, 0.3960486081806023, \
-1.216330540944265, 0.3874887217596090, 0.3874887217596090, \
-1.233936070441347, 0.3784356343602136, 0.3784356343602136, \
-1.252551225580531, 0.3688654123637496, 0.3688654123637496, \
-1.272225673039937, 0.3587522358995262, 0.3587522358995262, \
-1.293012998577890, 0.3480682368155796, 0.3480682368155796, \
-1.314971044433458, 0.3367833194066846, 0.3367833194066846, \
-1.338162282236242, 0.3248649615668737, 0.3248649615668737, \
-1.362654225899748, 0.3122779936506796, 0.3122779936506796, \
-1.388519889552433, 0.2989843518208232, 0.2989843518208232, \
-1.415838296244710, 0.2849428019678970, 0.2849428019678970, \
-1.444695043973177, 0.2701086292952448, 0.2701086292952448, \
-1.475182936503697, 0.2544332871490045, 0.2544332871490045, \
-1.507402687575512, 0.2378639961899961, 0.2378639961899961, \
-1.541463708357792, 0.2203432805790748, 0.2203432805790748, \
-1.577484989542117, 0.2018084192285952, 0.2018084192285952, \
-1.615596091231534, 0.1821907717080016, 0.1821907717080016, \
-1.655938255879829, 0.1614148944910037, 0.1614148944910037, \
-1.698665662005962, 0.1393972455732479, 0.1393972455732479, \
-1.743946839334117, 0.1160439101181749, 0.1160439101181749, \
-1.791966269482767, 0.09124539944674211, 0.09124539944674211, \
-1.842926200461068, 0.06485960934522295, 0.06485960934522295, \
-1.897048708169068, 0.03661526024375511, 0.03661526024375511, \
-1.954578044014448, 0.06910347771526625, -0.5255644350395376, \
0.9637674485685126, 0.5130128296610228, 0.5130128296610228, \
0.9792705574237019, 0.5086998036985540, 0.5086998036985540, \
0.9850428060138783, 0.5064672860926227, 0.5064672860926227, \
0.9888904259123205, 0.5046804330930057, 0.5046804330930057, \
0.9923789117755779, 0.5029232541124522, 0.5029232541124522, \
0.9959885152464196, 0.5010479928319782, 0.5010479928319782, \
0.9999110224550995, 0.4989895321660908, 0.4989895321660908, \
1.004238597832828, 0.4967139887824587, 0.4967139887824587, 1.009022949018098, \
0.4942009154241570, 0.4942009154241570, 1.014297571842615, \
0.4914361245070972, 0.4914361245070972, 1.020087277309055, \
0.4884084472462412, 0.4884084472462412, 1.026412702398780, \
0.4851081317623701, 0.4851081317623701, 1.033292629871159, \
0.4815259879079306, 0.4815259879079306, 1.040745271809461, \
0.4776528972002895, 0.4776528972002895, 1.048789031319354, \
0.4734795114664368, 0.4734795114664368, 1.057442988309779, \
0.4689960532090180, 0.4689960532090180, 1.066727234169531, \
0.4641921723426251, 0.4641921723426251, 1.076663122074745, \
0.4590568344586037, 0.4590568344586037, 1.087273470341689, \
0.4535782263680217, 0.4535782263680217, 1.098582740778382, \
0.4477436703641882, 0.4477436703641882, 1.110617205534552, \
0.4415395418062101, 0.4415395418062101, 1.123405111190913, \
0.4349511864233572, 0.4349511864233572, 1.136976846095367, \
0.4279628347779705, 0.4279628347779705, 1.151365115371039, \
0.4205575119225110, 0.4205575119225110, 1.166605127115736, \
0.4127169406196697, 0.4127169406196697, 1.182734792821473, \
0.4044214366618116, 0.4044214366618116, 1.199794944816448, \
0.3956497948834739, 0.3956497948834739, 1.217829573484062, \
0.3863791644400462, 0.3863791644400462, 1.236886087094489, \
0.3765849118444433, 0.3765849118444433, 1.257015597265698, \
0.3662404701195541, 0.3662404701195541, 1.278273233338100, \
0.3553171722387588, 0.3553171722387588, 1.300718489293992, \
0.3437840667851423, 0.3437840667851423, 1.324415607279801, \
0.3316077134507338, 0.3316077134507338, 1.349434002300303, \
0.3187519555992968, 0.3187519555992968, 1.375848733257986, \
0.3051776665935451, 0.3051776665935451, 1.403741026219372, \
0.2908424658761309, 0.2908424658761309, 1.433198856619133, \
0.2757003997760375, 0.2757003997760375, 1.464317598081591, \
0.2597015804624550, 0.2597015804624550, 1.497200746671730, \
0.2427917739279168, 0.2427917739279168, 1.531960730713411, \
0.2249119233589341, 0.2249119233589341, 1.568719817866565, \
0.2059975854455263, 0.2059975854455263, 1.607611132980994, \
0.1859782383192618, 0.1859782383192618, 1.648779802394448, \
0.1647763749718571, 0.1647763749718571, 1.692384242880910, \
0.1423061758468755, 0.1423061758468755, 1.738597616459561, \
0.1184711811747906, 0.1184711811747906, 1.787609475841512, \
0.09315897402117844, 0.09315897402117844, 1.839627629537605, \
0.06622377105889224, 0.06622377105889224, 1.894880260721602, \
0.03738780959341101, 0.03738780959341101, 1.953618340018361, \
-5.000000000000000, -0.7609230998987977, 0.6451517227815950, \
0.06910347771526625, -0.7609230998987977, 0.6871284512254478, \
0.08482732986841036, -0.5255644350395376, 0.6451517227815950, \
0.08482732986841036, -0.8996138963021735, 0.5157270611443916, \
0.5157270611443916, -0.9921514020355521, 0.4989776892229326, \
0.4989776892229326, -1.007166178402008, 0.4947958056425984, \
0.4947958056425984, -1.012811784699518, 0.4925882076362137, \
0.4925882076362137, -1.016655523492265, 0.4907882660354490, \
0.4907882660354490, -1.020191609466177, 0.4889990231545625, \
0.4889990231545625, -1.023878915008522, 0.4870790272128977, \
0.4870790272128977, -1.027901471915058, 0.4849656219440368, \
0.4849656219440368, -1.032348251651405, 0.4826259707451153, \
0.4826259707451153, -1.037269592766972, 0.4800400639736588, \
0.4800400639736588, -1.042698462532070, 0.4771938526735618, \
0.4771938526735618, -1.048659581535952, 0.4740761413865373, \
0.4740761413865373, -1.055173753097158, 0.4706770488745427, \
0.4706770488745427, -1.062260095334682, 0.4669871840150758, \
0.4669871840150758, -1.069937280345647, 0.4629971716222484, \
0.4629971716222484, -1.078224273174225, 0.4586973591349450, \
0.4586973591349450, -1.087140806425165, 0.4540776206916017, \
0.4540776206916017, -1.096707710380503, 0.4491272150088633, \
0.4491272150088633, -1.106947162803786, 0.4438346731491573, \
0.4438346731491573, -1.117882894489209, 0.4381877024245137, \
0.4381877024245137, -1.129540371776221, 0.4321730981457237, \
0.4321730981457237, -1.141946969138610, 0.4257766579564583, \
0.4257766579564583, -1.155132140396202, 0.4189830952131352, \
0.4189830952131352, -1.169127594484778, 0.4117759488602348, \
0.4117759488602348, -1.183967480216163, 0.4041374878147248, \
0.4041374878147248, -1.199688583611518, 0.3960486081806023, \
0.3960486081806023, -1.216330540944265, 0.3874887217596090, \
0.3874887217596090, -1.233936070441347, 0.3784356343602136, \
0.3784356343602136, -1.252551225580531, 0.3688654123637496, \
0.3688654123637496, -1.272225673039937, 0.3587522358995262, \
0.3587522358995262, -1.293012998577890, 0.3480682368155796, \
0.3480682368155796, -1.314971044433458, 0.3367833194066846, \
0.3367833194066846, -1.338162282236242, 0.3248649615668737, \
0.3248649615668737, -1.362654225899748, 0.3122779936506796, \
0.3122779936506796, -1.388519889552433, 0.2989843518208232, \
0.2989843518208232, -1.415838296244710, 0.2849428019678970, \
0.2849428019678970, -1.444695043973177, 0.2701086292952448, \
0.2701086292952448, -1.475182936503697, 0.2544332871490045, \
0.2544332871490045, -1.507402687575512, 0.2378639961899961, \
0.2378639961899961, -1.541463708357792, 0.2203432805790748, \
0.2203432805790748, -1.577484989542117, 0.2018084192285952, \
0.2018084192285952, -1.615596091231534, 0.1821907717080016, \
0.1821907717080016, -1.655938255879829, 0.1614148944910037, \
0.1614148944910037, -1.698665662005962, 0.1393972455732479, \
0.1393972455732479, -1.743946839334117, 0.1160439101181749, \
0.1160439101181749, -1.791966269482767, 0.09124539944674211, \
0.09124539944674211, -1.842926200461068, 0.06485960934522295, \
0.06485960934522295, -1.897048708169068, 0.03661526024375511, \
0.03661526024375511, -1.954578044014448, 0.06910347771526625, \
-0.5255644350395376, 0.9637674485685126, 0.5130128296610228, \
0.5130128296610228, 0.9792705574237019, 0.5086998036985540, \
0.5086998036985540, 0.9850428060138783, 0.5064672860926227, \
0.5064672860926227, 0.9888904259123205, 0.5046804330930057, \
0.5046804330930057, 0.9923789117755779, 0.5029232541124522, \
0.5029232541124522, 0.9959885152464196, 0.5010479928319782, \
0.5010479928319782, 0.9999110224550995, 0.4989895321660908, \
0.4989895321660908, 1.004238597832828, 0.4967139887824587, \
0.4967139887824587, 1.009022949018098, 0.4942009154241570, \
0.4942009154241570, 1.014297571842615, 0.4914361245070972, \
0.4914361245070972, 1.020087277309055, 0.4884084472462412, \
0.4884084472462412, 1.026412702398780, 0.4851081317623701, \
0.4851081317623701, 1.033292629871159, 0.4815259879079306, \
0.4815259879079306, 1.040745271809461, 0.4776528972002895, \
0.4776528972002895, 1.048789031319354, 0.4734795114664368, \
0.4734795114664368, 1.057442988309779, 0.4689960532090180, \
0.4689960532090180, 1.066727234169531, 0.4641921723426251, \
0.4641921723426251, 1.076663122074745, 0.4590568344586037, \
0.4590568344586037, 1.087273470341689, 0.4535782263680217, \
0.4535782263680217, 1.098582740778382, 0.4477436703641882, \
0.4477436703641882, 1.110617205534552, 0.4415395418062101, \
0.4415395418062101, 1.123405111190913, 0.4349511864233572, \
0.4349511864233572, 1.136976846095367, 0.4279628347779705, \
0.4279628347779705, 1.151365115371039, 0.4205575119225110, \
0.4205575119225110, 1.166605127115736, 0.4127169406196697, \
0.4127169406196697, 1.182734792821473, 0.4044214366618116, \
0.4044214366618116, 1.199794944816448, 0.3956497948834739, \
0.3956497948834739, 1.217829573484062, 0.3863791644400462, \
0.3863791644400462, 1.236886087094489, 0.3765849118444433, \
0.3765849118444433, 1.257015597265698, 0.3662404701195541, \
0.3662404701195541, 1.278273233338100, 0.3553171722387588, \
0.3553171722387588, 1.300718489293992, 0.3437840667851423, \
0.3437840667851423, 1.324415607279801, 0.3316077134507338, \
0.3316077134507338, 1.349434002300303, 0.3187519555992968, \
0.3187519555992968, 1.375848733257986, 0.3051776665935451, \
0.3051776665935451, 1.403741026219372, 0.2908424658761309, \
0.2908424658761309, 1.433198856619133, 0.2757003997760375, \
0.2757003997760375, 1.464317598081591, 0.2597015804624550, \
0.2597015804624550, 1.497200746671730, 0.2427917739279168, \
0.2427917739279168, 1.531960730713411, 0.2249119233589341, \
0.2249119233589341, 1.568719817866565, 0.2059975854455263, \
0.2059975854455263, 1.607611132980994, 0.1859782383192618, \
0.1859782383192618, 1.648779802394448, 0.1647763749718571, \
0.1647763749718571, 1.692384242880910, 0.1423061758468755, \
0.1423061758468755, 1.738597616459561, 0.1184711811747906, \
0.1184711811747906, 1.787609475841512, 0.09315897402117844, \
0.09315897402117844, 1.839627629537605, 0.06622377105889224, \
0.06622377105889224, 1.894880260721602, 0.03738780959341101, \
0.03738780959341101, 1.953618340018361})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.779360097248602*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"556e76bd-1ffa-4383-a3d0-4bd6f902cff6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -6", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.779359280778961*^9}, 
   3.779359386319755*^9},ExpressionUUID->"6b73f7b4-75c8-4787-aacd-\
c1a43b6dcc3a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, {3.779359285341239*^9, 
   3.779359286580131*^9}, 3.779359442127905*^9},
 CellLabel->"In[54]:=",ExpressionUUID->"77939a13-86f3-4830-92a7-19a774f9d348"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-6.000000000000000, \
-0.7545679984476595, 0.6535976335179146, 0.05862822851216641, \
-0.7545679984476595, 0.7094244092874384, 0.07259922030682658, \
-0.5278193243804891, 0.6535976335179146, 0.07259922030682658, \
-0.8949827193029702, 0.5163435902080513, 0.5163435902080513, \
-0.9918997250869379, 0.4989465724932815, 0.4989465724932815, \
-1.007342230508896, 0.4946838953944992, 0.4946838953944992, \
-1.013057631991125, 0.4924599980725741, 0.4924599980725741, \
-1.016916759946603, 0.4906568058833607, 0.4906568058833607, \
-1.020454387101829, 0.4888682632797144, 0.4888682632797144, \
-1.024138472527319, 0.4869504598042742, 0.4869504598042742, \
-1.028155883072479, 0.4848398808865426, 0.4848398808865426, \
-1.032596672433234, 0.4825033374702070, 0.4825033374702070, \
-1.037511651189681, 0.4799206582456541, 0.4799206582456541, \
-1.042934012411578, 0.4770777141848665, 0.4770777141848665, \
-1.048888591723842, 0.4739632681301448, 0.4739632681301448, \
-1.055396253300252, 0.4705674165853208, 0.4705674165853208, \
-1.062476147785773, 0.4668807566283474, 0.4668807566283474, \
-1.070146964165794, 0.4628939071839344, 0.4628939071839344, \
-1.078427675344509, 0.4585972132815118, 0.4585972132815118, \
-1.087338016373477, 0.4539805487720445, 0.4539805487720445, \
-1.096898816628335, 0.4490331734188945, 0.4490331734188945, \
-1.107132250827710, 0.4437436201939812, 0.4437436201939812, \
-1.118062045318897, 0.4380995988924118, 0.4380995988924118, \
-1.129713661048866, 0.4320879077009471, 0.4320879077009471, \
-1.142114466440382, 0.4256943474180013, 0.4256943474180013, \
-1.155293908785341, 0.4189036347613884, 0.4189036347613884, \
-1.169283690128925, 0.4116993121987420, 0.4116993121987420, \
-1.184117952099674, 0.4040636523051589, 0.4040636523051589, \
-1.199833473282901, 0.3959775549633704, 0.3959775549633704, \
-1.216469882282996, 0.3874204358688508, 0.3874204358688508, \
-1.234069889429153, 0.3783701048396146, 0.3783701048396146, \
-1.252679540066028, 0.3688026323880791, 0.3688026323880791, \
-1.272348492487930, 0.3586922029058411, 0.3586922029058411, \
-1.293130323796212, 0.3480109526474372, 0.3480109526474372, \
-1.315082867271163, 0.3367287904743707, 0.3367287904743707, \
-1.338268585247477, 0.3248131990265016, 0.3248131990265016, \
-1.362754981967870, 0.3122290136050199, 0.3122290136050199, \
-1.388615061468869, 0.2989381755448553, 0.2989381755448553, \
-1.415927836236862, 0.2848994561623382, 0.2848994561623382, \
-1.444778893175276, 0.2700681463717302, 0.2700681463717302, \
-1.475261024363945, 0.2543957055512084, 0.2543957055512084, \
-1.507474931192181, 0.2378293607559271, 0.2378293607559271, \
-1.541530011736062, 0.2203116429512734, 0.2203116429512734, \
-1.577545242762424, 0.2017798383215479, 0.2017798383215479, \
-1.615650169518954, 0.1821653142470052, 0.1821653142470052, \
-1.655986018562623, 0.1613926356472169, 0.1613926356472169, \
-1.698706951349682, 0.1393782697451632, 0.1393782697451632, \
-1.743981479235723, 0.1160283119818855, 0.1160283119818855, \
-1.791994064006867, 0.09123328564584249, 0.09123328564584249, \
-1.842946932197688, 0.06485110232983227, 0.06485110232983227, \
-1.897062136389138, 0.03661051441715305, 0.03661051441715305, \
-1.954583902595419, 0.05862822851216641, -0.5278193243804891, \
0.9628821831142423, 0.5132931120718531, 0.5132931120718531, \
0.9788207296608818, 0.5089026940895291, 0.5089026940895291, \
0.9846566016758360, 0.5066557899270025, 0.5066557899270025, \
0.9885175598836753, 0.5048661524292229, 0.5048661524292229, \
0.9920073205320070, 0.5031096139638312, 0.5031096139638312, \
0.9956140377984044, 0.5012363235643781, 0.5012363235643781, \
0.9995318854406536, 0.4991804446850867, 0.4991804446850867, \
1.003853935972794, 0.4969077962905525, 0.4969077962905525, 1.008632300860875, \
0.4943977900022682, 0.4943977900022682, 1.013900678873562, \
0.4916361632960978, 0.4916361632960978, 1.019683994710653, \
0.4886117031003102, 0.4886117031003102, 1.026002956269727, \
0.4853146283510872, 0.4853146283510872, 1.032876395726719, \
0.4817357273930401, 0.4817357273930401, 1.040322563641360, \
0.4778658640917701, 0.4778658640917701, 1.048359896282404, \
0.4736956743713735, 0.4736956743713735, 1.057007504620997, \
0.4692153653338933, 0.4692153653338933, 1.066285510979395, \
0.4644145711998118, 0.4644145711998118, 1.076215300650584, \
0.4592822410197347, 0.4592822410197347, 1.086819726205483, \
0.4538065437958399, 0.4538065437958399, 1.098123286606460, \
0.4479747823922980, 0.4479747823922980, 1.110152294721439, \
0.4417733107995911, 0.4417733107995911, 1.122935042036760, \
0.4351874511297980, 0.4351874511297980, 1.136501966613027, \
0.4282014077655381, 0.4282014077655381, 1.150885828734003, \
0.4207981766874142, 0.4207981766874142, 1.166121897786915, \
0.4129594483404854, 0.4129594483404854, 1.182248153418097, \
0.4046655025688776, 0.4046655025688776, 1.199305503779968, \
0.3958950942056314, 0.3958950942056314, 1.217338023636933, \
0.3866253278843641, 0.3866253278843641, 1.236393215178892, \
0.3768315205577627, 0.3768315205577627, 1.256522294573156, \
0.3664870500734016, 0.3664870500734016, 1.277780507553954, \
0.3555631879711795, 0.3555631879711795, 1.300227477697298, \
0.3440289144240851, 0.3440289144240851, 1.323927591457653, \
0.3318507129335775, 0.3318507129335775, 1.348950424556346, \
0.3189923419916783, 0.3189923419916783, 1.375371214918280, \
0.3054145803975464, 0.3054145803975464, 1.403271388065322, \
0.2910749422026967, 0.2910749422026967, 1.432739141707377, \
0.2759273562386743, 0.2759273562386743, 1.463870097245100, \
0.2599218036279398, 0.2599218036279398, 1.496768027035679, \
0.2430039041334771, 0.2430039041334771, 1.531545667604307, \
0.2251144376714596, 0.2251144376714596, 1.568325630544712, \
0.2061887784913567, 0.2061887784913567, 1.607241424685623, \
0.1861562006404638, 0.1861562006404638, 1.648438605259139, \
0.1649389684350120, 0.1649389684350120, 1.692076068355741, \
0.1424510053522772, 0.1424510053522772, 1.738327511967695, \
0.1185955611834409, 0.1185955611834409, 1.787383088503728, \
0.09325988598994563, 0.09325988598994563, 1.839451277921476, \
0.06629779690844637, 0.06629779690844637, 1.894761015715626, \
0.03743094341386652, 0.03743094341386652, 1.953564116099473, \
-6.000000000000000, -0.7545679984476595, 0.6535976335179146, \
0.05862822851216641, -0.7545679984476595, 0.7094244092874384, \
0.07259922030682658, -0.5278193243804891, 0.6535976335179146, \
0.07259922030682658, -0.8949827193029702, 0.5163435902080513, \
0.5163435902080513, -0.9918997250869379, 0.4989465724932815, \
0.4989465724932815, -1.007342230508896, 0.4946838953944992, \
0.4946838953944992, -1.013057631991125, 0.4924599980725741, \
0.4924599980725741, -1.016916759946603, 0.4906568058833607, \
0.4906568058833607, -1.020454387101829, 0.4888682632797144, \
0.4888682632797144, -1.024138472527319, 0.4869504598042742, \
0.4869504598042742, -1.028155883072479, 0.4848398808865426, \
0.4848398808865426, -1.032596672433234, 0.4825033374702070, \
0.4825033374702070, -1.037511651189681, 0.4799206582456541, \
0.4799206582456541, -1.042934012411578, 0.4770777141848665, \
0.4770777141848665, -1.048888591723842, 0.4739632681301448, \
0.4739632681301448, -1.055396253300252, 0.4705674165853208, \
0.4705674165853208, -1.062476147785773, 0.4668807566283474, \
0.4668807566283474, -1.070146964165794, 0.4628939071839344, \
0.4628939071839344, -1.078427675344509, 0.4585972132815118, \
0.4585972132815118, -1.087338016373477, 0.4539805487720445, \
0.4539805487720445, -1.096898816628335, 0.4490331734188945, \
0.4490331734188945, -1.107132250827710, 0.4437436201939812, \
0.4437436201939812, -1.118062045318897, 0.4380995988924118, \
0.4380995988924118, -1.129713661048866, 0.4320879077009471, \
0.4320879077009471, -1.142114466440382, 0.4256943474180013, \
0.4256943474180013, -1.155293908785341, 0.4189036347613884, \
0.4189036347613884, -1.169283690128925, 0.4116993121987420, \
0.4116993121987420, -1.184117952099674, 0.4040636523051589, \
0.4040636523051589, -1.199833473282901, 0.3959775549633704, \
0.3959775549633704, -1.216469882282996, 0.3874204358688508, \
0.3874204358688508, -1.234069889429153, 0.3783701048396146, \
0.3783701048396146, -1.252679540066028, 0.3688026323880791, \
0.3688026323880791, -1.272348492487930, 0.3586922029058411, \
0.3586922029058411, -1.293130323796212, 0.3480109526474372, \
0.3480109526474372, -1.315082867271163, 0.3367287904743707, \
0.3367287904743707, -1.338268585247477, 0.3248131990265016, \
0.3248131990265016, -1.362754981967870, 0.3122290136050199, \
0.3122290136050199, -1.388615061468869, 0.2989381755448553, \
0.2989381755448553, -1.415927836236862, 0.2848994561623382, \
0.2848994561623382, -1.444778893175276, 0.2700681463717302, \
0.2700681463717302, -1.475261024363945, 0.2543957055512084, \
0.2543957055512084, -1.507474931192181, 0.2378293607559271, \
0.2378293607559271, -1.541530011736062, 0.2203116429512734, \
0.2203116429512734, -1.577545242762424, 0.2017798383215479, \
0.2017798383215479, -1.615650169518954, 0.1821653142470052, \
0.1821653142470052, -1.655986018562623, 0.1613926356472169, \
0.1613926356472169, -1.698706951349682, 0.1393782697451632, \
0.1393782697451632, -1.743981479235723, 0.1160283119818855, \
0.1160283119818855, -1.791994064006867, 0.09123328564584249, \
0.09123328564584249, -1.842946932197688, 0.06485110232983227, \
0.06485110232983227, -1.897062136389138, 0.03661051441715305, \
0.03661051441715305, -1.954583902595419, 0.05862822851216641, \
-0.5278193243804891, 0.9628821831142423, 0.5132931120718531, \
0.5132931120718531, 0.9788207296608818, 0.5089026940895291, \
0.5089026940895291, 0.9846566016758360, 0.5066557899270025, \
0.5066557899270025, 0.9885175598836753, 0.5048661524292229, \
0.5048661524292229, 0.9920073205320070, 0.5031096139638312, \
0.5031096139638312, 0.9956140377984044, 0.5012363235643781, \
0.5012363235643781, 0.9995318854406536, 0.4991804446850867, \
0.4991804446850867, 1.003853935972794, 0.4969077962905525, \
0.4969077962905525, 1.008632300860875, 0.4943977900022682, \
0.4943977900022682, 1.013900678873562, 0.4916361632960978, \
0.4916361632960978, 1.019683994710653, 0.4886117031003102, \
0.4886117031003102, 1.026002956269727, 0.4853146283510872, \
0.4853146283510872, 1.032876395726719, 0.4817357273930401, \
0.4817357273930401, 1.040322563641360, 0.4778658640917701, \
0.4778658640917701, 1.048359896282404, 0.4736956743713735, \
0.4736956743713735, 1.057007504620997, 0.4692153653338933, \
0.4692153653338933, 1.066285510979395, 0.4644145711998118, \
0.4644145711998118, 1.076215300650584, 0.4592822410197347, \
0.4592822410197347, 1.086819726205483, 0.4538065437958399, \
0.4538065437958399, 1.098123286606460, 0.4479747823922980, \
0.4479747823922980, 1.110152294721439, 0.4417733107995911, \
0.4417733107995911, 1.122935042036760, 0.4351874511297980, \
0.4351874511297980, 1.136501966613027, 0.4282014077655381, \
0.4282014077655381, 1.150885828734003, 0.4207981766874142, \
0.4207981766874142, 1.166121897786915, 0.4129594483404854, \
0.4129594483404854, 1.182248153418097, 0.4046655025688776, \
0.4046655025688776, 1.199305503779968, 0.3958950942056314, \
0.3958950942056314, 1.217338023636933, 0.3866253278843641, \
0.3866253278843641, 1.236393215178892, 0.3768315205577627, \
0.3768315205577627, 1.256522294573156, 0.3664870500734016, \
0.3664870500734016, 1.277780507553954, 0.3555631879711795, \
0.3555631879711795, 1.300227477697298, 0.3440289144240851, \
0.3440289144240851, 1.323927591457653, 0.3318507129335775, \
0.3318507129335775, 1.348950424556346, 0.3189923419916783, \
0.3189923419916783, 1.375371214918280, 0.3054145803975464, \
0.3054145803975464, 1.403271388065322, 0.2910749422026967, \
0.2910749422026967, 1.432739141707377, 0.2759273562386743, \
0.2759273562386743, 1.463870097245100, 0.2599218036279398, \
0.2599218036279398, 1.496768027035679, 0.2430039041334771, \
0.2430039041334771, 1.531545667604307, 0.2251144376714596, \
0.2251144376714596, 1.568325630544712, 0.2061887784913567, \
0.2061887784913567, 1.607241424685623, 0.1861562006404638, \
0.1861562006404638, 1.648438605259139, 0.1649389684350120, \
0.1649389684350120, 1.692076068355741, 0.1424510053522772, \
0.1424510053522772, 1.738327511967695, 0.1185955611834409, \
0.1185955611834409, 1.787383088503728, 0.09325988598994563, \
0.09325988598994563, 1.839451277921476, 0.06629779690844637, \
0.06629779690844637, 1.894761015715626, 0.03743094341386652, \
0.03743094341386652, 1.953564116099473})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.7793601639425297`*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"a4a7f762-d2c1-4929-b62c-0e09a6210e2f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -7", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.779359280778961*^9}, 
   3.779359387205945*^9},ExpressionUUID->"6c20a027-702c-4884-a069-\
60fe4684f42a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "7"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, {3.779359285341239*^9, 
   3.779359286580131*^9}, 3.779359437185754*^9},
 CellLabel->"In[59]:=",ExpressionUUID->"4aeba750-76e2-45aa-8618-58e286c75a0c"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-7.000000000000000, \
-0.7497127956078083, 0.6598033845464348, 0.05089418280112285, \
-0.7497127956078083, 0.7258147612409342, 0.06343546292089766, \
-0.5293593286736059, 0.6598033845464348, 0.06343546292089766, \
-0.8914600685193469, 0.5168111418068238, 0.5168111418068238, \
-0.9917071184841647, 0.4989253415004101, 0.4989253415004101, \
-1.007468947464037, 0.4946030187146181, 0.4946030187146181, \
-1.013235442722319, 0.4923672510478589, 0.4923672510478589, \
-1.017105756004748, 0.4905616905130336, 0.4905616905130336, \
-1.020644534525566, 0.4887736328731602, 0.4887736328731602, \
-1.024326339819435, 0.4868573885787551, 0.4868573885787551, \
-1.028340083950012, 0.4847488252892902, 0.4847488252892902, \
-1.032776598205326, 0.4824145010411372, 0.4824145010411372, \
-1.037687031547762, 0.4798341287087976, 0.4798341287087976, \
-1.043104738743906, 0.4769935219301753, 0.4769935219301753, \
-1.049054637803305, 0.4738814136686706, 0.4738814136686706, \
-1.055557636542709, 0.4704878844442066, 0.4704878844442066, \
-1.062632909009101, 0.4668035228221335, 0.4668035228221335, \
-1.070299156418841, 0.4628189434372570, 0.4628189434372570, \
-1.078575357454321, 0.4585244895177103, 0.4585244895177103, \
-1.087481249071143, 0.4539100346334049, 0.4539100346334049, \
-1.097037660143493, 0.4489648392253293, 0.4489648392253293, \
-1.107266763348852, 0.4436774375657031, 0.4436774375657031, \
-1.118192281978676, 0.4380355411664453, 0.4380355411664453, \
-1.129839673234842, 0.4320259502187616, 0.4320259502187616, \
-1.142236301310573, 0.4256344677316782, 0.4256344677316782, \
-1.155411608913508, 0.4188458127882445, 0.4188458127882445, \
-1.169397293231573, 0.4116435303438077, 0.4116435303438077, \
-1.184227490813201, 0.4040098955644406, 0.4040098955644406, \
-1.199938974969604, 0.3959258110167597, 0.3959258110167597, \
-1.216571368851060, 0.3873706951689594, 0.3873706951689594, \
-1.234167377155968, 0.3783223607011471, 0.3783223607011471, \
-1.252773039416808, 0.3687568810812803, 0.3687568810812803, \
-1.272438007923382, 0.3586484437568725, 0.3586484437568725, \
-1.293215853564069, 0.3479691881481119, 0.3479691881481119, \
-1.315164403177088, 0.3366890264034401, 0.3366890264034401, \
-1.338346112401194, 0.3247754445845845, 0.3247754445845845, \
-1.362828478500519, 0.3121932815652714, 0.3121932815652714, \
-1.388684498217571, 0.2989044824215739, 0.2989044824215739, \
-1.415993176392284, 0.2848678223999048, 0.2848678223999048, \
-1.444840091887716, 0.2700385965565771, 0.2700385965565771, \
-1.475318028303047, 0.2543682686499744, 0.2543682686499744, \
-1.507527678054873, 0.2378040703836399, 0.2378040703836399, \
-1.541578429696674, 0.2202885376744987, 0.2202885376744987, \
-1.577589249858210, 0.2017589620033344, 0.2017589620033344, \
-1.615689672963316, 0.1821467164440550, 0.1821467164440550, \
-1.656020913977300, 0.1613763720773925, 0.1613763720773925, \
-1.698737121905933, 0.1393644028620883, 0.1393644028620883, \
-1.744006794693071, 0.1160169117461552, 0.1160169117461552, \
-1.792014379636283, 0.09122443076406135, 0.09122443076406135, \
-1.842962087574086, 0.06484488306537736, 0.06484488306537736, \
-1.897071954035712, 0.03660704440146263, 0.03660704440146263, \
-1.954588186459583, 0.05089418280112285, -0.5293593286736059, \
0.9622232294443704, 0.5134993568808651, 0.5134993568808651, \
0.9784922398201396, 0.5090502523948203, 0.5090502523948203, \
0.9843762959261164, 0.5067924703354701, 0.5067924703354701, \
0.9882473158328892, 0.5050007436266805, 0.5050007436266805, \
0.9917380030418796, 0.5032447103262310, 0.5032447103262310, \
0.9953424914969191, 0.5013729360939767, 0.5013729360939767, \
0.9992567580483348, 0.4993190415959130, 0.4993190415959130, \
1.003574559571752, 0.4970486217128755, 0.4970486217128755, 1.008348311052856, \
0.4945409821880261, 0.4945409821880261, 1.013611863182861, \
0.4917818045455718, 0.4917818045455718, 1.019390225278842, \
0.4887598428771119, 0.4887598428771119, 1.025704157598872, \
0.4854652946687840, 0.4854652946687840, 1.032572528468650, \
0.4818889326039231, 0.4818889326039231, 1.040013616347303, \
0.4780216077950916, 0.4780216077950916, 1.048045881396005, \
0.4738539447315747, 0.4738539447315747, 1.056688456897503, \
0.4693761394561552, 0.4693761394561552, 1.065961487398909, \
0.4645778149012506, 0.4645778149012506, 1.075886381330908, \
0.4594479081776259, 0.4594479081776259, 1.086486016048072, \
0.4539745753704071, 0.4539745753704071, 1.097784917533883, \
0.4481451051745562, 0.4481451051745562, 1.109809428436567, \
0.4419458359069335, 0.4419458359069335, 1.122587873277535, \
0.4353620722546014, 0.4353620722546014, 1.136150726904979, \
0.4283779991703600, 0.4283779991703600, 1.150530790662392, \
0.4209765909318106, 0.4209765909318106, 1.165763379825505, \
0.4131395137176370, 0.4131395137176370, 1.181886525364196, \
0.4048470202242165, 0.4048470202242165, 1.198941192856907, \
0.3960778349039606, 0.3960778349039606, 1.216971521336506, \
0.3868090283862093, 0.3868090283862093, 1.236025084927944, \
0.3770158795596208, 0.3770158795596208, 1.256153180321044, \
0.3666717236599459, 0.3666717236599459, 1.277411143391325, \
0.3557477845201621, 0.3557477845201621, 1.299858698631886, \
0.3442129888964564, 0.3442129888964564, 1.323560345489943, \
0.3320337604720219, 0.3320337604720219, 1.348585786217341, \
0.3191737907401220, 0.3191737907401220, 1.375010400453608, \
0.3055937834419427, 0.3055937834419427, 1.402915772475005, \
0.2912511685191882, 0.2912511685191882, 1.432390277879206, \
0.2760997805185659, 0.2760997805185659, 1.463529737452344, \
0.2600894948290575, 0.2600894948290575, 1.496438147107433, \
0.2431658125832223, 0.2431658125832223, 1.531228494119954, \
0.2252693805160027, 0.2252693805160027, 1.568023671453659, \
0.2063354232435335, 0.2063354232435335, 1.606957503810743, \
0.1862930465161190, 0.1862930465161190, 1.648175901208492, \
0.1650643250587821, 0.1650643250587821, 1.691838158443725, \
0.1425629681875415, 0.1425629681875415, 1.738118421835493, \
0.1186919824584100, 0.1186919824584100, 1.787207348232120, \
0.09333833797567642, 0.09333833797567642, 1.839313985549165, \
0.06635551578330730, 0.06635551578330730, 1.894667909216529, \
0.03746467684088871, 0.03746467684088871, 1.953521655036570, \
-7.000000000000000, -0.7497127956078083, 0.6598033845464348, \
0.05089418280112285, -0.7497127956078083, 0.7258147612409342, \
0.06343546292089766, -0.5293593286736059, 0.6598033845464348, \
0.06343546292089766, -0.8914600685193469, 0.5168111418068238, \
0.5168111418068238, -0.9917071184841647, 0.4989253415004101, \
0.4989253415004101, -1.007468947464037, 0.4946030187146181, \
0.4946030187146181, -1.013235442722319, 0.4923672510478589, \
0.4923672510478589, -1.017105756004748, 0.4905616905130336, \
0.4905616905130336, -1.020644534525566, 0.4887736328731602, \
0.4887736328731602, -1.024326339819435, 0.4868573885787551, \
0.4868573885787551, -1.028340083950012, 0.4847488252892902, \
0.4847488252892902, -1.032776598205326, 0.4824145010411372, \
0.4824145010411372, -1.037687031547762, 0.4798341287087976, \
0.4798341287087976, -1.043104738743906, 0.4769935219301753, \
0.4769935219301753, -1.049054637803305, 0.4738814136686706, \
0.4738814136686706, -1.055557636542709, 0.4704878844442066, \
0.4704878844442066, -1.062632909009101, 0.4668035228221335, \
0.4668035228221335, -1.070299156418841, 0.4628189434372570, \
0.4628189434372570, -1.078575357454321, 0.4585244895177103, \
0.4585244895177103, -1.087481249071143, 0.4539100346334049, \
0.4539100346334049, -1.097037660143493, 0.4489648392253293, \
0.4489648392253293, -1.107266763348852, 0.4436774375657031, \
0.4436774375657031, -1.118192281978676, 0.4380355411664453, \
0.4380355411664453, -1.129839673234842, 0.4320259502187616, \
0.4320259502187616, -1.142236301310573, 0.4256344677316782, \
0.4256344677316782, -1.155411608913508, 0.4188458127882445, \
0.4188458127882445, -1.169397293231573, 0.4116435303438077, \
0.4116435303438077, -1.184227490813201, 0.4040098955644406, \
0.4040098955644406, -1.199938974969604, 0.3959258110167597, \
0.3959258110167597, -1.216571368851060, 0.3873706951689594, \
0.3873706951689594, -1.234167377155968, 0.3783223607011471, \
0.3783223607011471, -1.252773039416808, 0.3687568810812803, \
0.3687568810812803, -1.272438007923382, 0.3586484437568725, \
0.3586484437568725, -1.293215853564069, 0.3479691881481119, \
0.3479691881481119, -1.315164403177088, 0.3366890264034401, \
0.3366890264034401, -1.338346112401194, 0.3247754445845845, \
0.3247754445845845, -1.362828478500519, 0.3121932815652714, \
0.3121932815652714, -1.388684498217571, 0.2989044824215739, \
0.2989044824215739, -1.415993176392284, 0.2848678223999048, \
0.2848678223999048, -1.444840091887716, 0.2700385965565771, \
0.2700385965565771, -1.475318028303047, 0.2543682686499744, \
0.2543682686499744, -1.507527678054873, 0.2378040703836399, \
0.2378040703836399, -1.541578429696674, 0.2202885376744987, \
0.2202885376744987, -1.577589249858210, 0.2017589620033344, \
0.2017589620033344, -1.615689672963316, 0.1821467164440550, \
0.1821467164440550, -1.656020913977300, 0.1613763720773925, \
0.1613763720773925, -1.698737121905933, 0.1393644028620883, \
0.1393644028620883, -1.744006794693071, 0.1160169117461552, \
0.1160169117461552, -1.792014379636283, 0.09122443076406135, \
0.09122443076406135, -1.842962087574086, 0.06484488306537736, \
0.06484488306537736, -1.897071954035712, 0.03660704440146263, \
0.03660704440146263, -1.954588186459583, 0.05089418280112285, \
-0.5293593286736059, 0.9622232294443704, 0.5134993568808651, \
0.5134993568808651, 0.9784922398201396, 0.5090502523948203, \
0.5090502523948203, 0.9843762959261164, 0.5067924703354701, \
0.5067924703354701, 0.9882473158328892, 0.5050007436266805, \
0.5050007436266805, 0.9917380030418796, 0.5032447103262310, \
0.5032447103262310, 0.9953424914969191, 0.5013729360939767, \
0.5013729360939767, 0.9992567580483348, 0.4993190415959130, \
0.4993190415959130, 1.003574559571752, 0.4970486217128755, \
0.4970486217128755, 1.008348311052856, 0.4945409821880261, \
0.4945409821880261, 1.013611863182861, 0.4917818045455718, \
0.4917818045455718, 1.019390225278842, 0.4887598428771119, \
0.4887598428771119, 1.025704157598872, 0.4854652946687840, \
0.4854652946687840, 1.032572528468650, 0.4818889326039231, \
0.4818889326039231, 1.040013616347303, 0.4780216077950916, \
0.4780216077950916, 1.048045881396005, 0.4738539447315747, \
0.4738539447315747, 1.056688456897503, 0.4693761394561552, \
0.4693761394561552, 1.065961487398909, 0.4645778149012506, \
0.4645778149012506, 1.075886381330908, 0.4594479081776259, \
0.4594479081776259, 1.086486016048072, 0.4539745753704071, \
0.4539745753704071, 1.097784917533883, 0.4481451051745562, \
0.4481451051745562, 1.109809428436567, 0.4419458359069335, \
0.4419458359069335, 1.122587873277535, 0.4353620722546014, \
0.4353620722546014, 1.136150726904979, 0.4283779991703600, \
0.4283779991703600, 1.150530790662392, 0.4209765909318106, \
0.4209765909318106, 1.165763379825505, 0.4131395137176370, \
0.4131395137176370, 1.181886525364196, 0.4048470202242165, \
0.4048470202242165, 1.198941192856907, 0.3960778349039606, \
0.3960778349039606, 1.216971521336506, 0.3868090283862093, \
0.3868090283862093, 1.236025084927944, 0.3770158795596208, \
0.3770158795596208, 1.256153180321044, 0.3666717236599459, \
0.3666717236599459, 1.277411143391325, 0.3557477845201621, \
0.3557477845201621, 1.299858698631886, 0.3442129888964564, \
0.3442129888964564, 1.323560345489943, 0.3320337604720219, \
0.3320337604720219, 1.348585786217341, 0.3191737907401220, \
0.3191737907401220, 1.375010400453608, 0.3055937834419427, \
0.3055937834419427, 1.402915772475005, 0.2912511685191882, \
0.2912511685191882, 1.432390277879206, 0.2760997805185659, \
0.2760997805185659, 1.463529737452344, 0.2600894948290575, \
0.2600894948290575, 1.496438147107433, 0.2431658125832223, \
0.2431658125832223, 1.531228494119954, 0.2252693805160027, \
0.2252693805160027, 1.568023671453659, 0.2063354232435335, \
0.2063354232435335, 1.606957503810743, 0.1862930465161190, \
0.1862930465161190, 1.648175901208492, 0.1650643250587821, \
0.1650643250587821, 1.691838158443725, 0.1425629681875415, \
0.1425629681875415, 1.738118421835493, 0.1186919824584100, \
0.1186919824584100, 1.787207348232120, 0.09333833797567642, \
0.09333833797567642, 1.839313985549165, 0.06635551578330730, \
0.06635551578330730, 1.894667909216529, 0.03746467684088871, \
0.03746467684088871, 1.953521655036570})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.77936023058401*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"41890aad-7341-40c2-bbc3-d8d907d3ad26"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -8", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.779359280778961*^9}, 
   3.779359388191762*^9},ExpressionUUID->"e5205a1a-4402-4781-98a5-\
9e3a17fe87a3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "8"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, {3.779359285341239*^9, 
   3.779359286580131*^9}, 3.7793594324442787`*^9},
 CellLabel->"In[64]:=",ExpressionUUID->"27465fc7-3b4b-47b0-9664-984f3abc7782"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-8.000000000000000, \
-0.7458886021154532, 0.6645519332238317, 0.04495465807592131, \
-0.7458886021154532, 0.7383594591805913, 0.05631742137339214, \
-0.5304700428966110, 0.6645519332238317, 0.05631742137339214, \
-0.8886938529772608, 0.5171773850899694, 0.5171773850899694, \
-0.9915553890487158, 0.4989099929084896, 0.4989099929084896, \
-1.007564453644875, 0.4945418866494049, 0.4945418866494049, \
-1.013369911632015, 0.4922971038303371, 0.4922971038303371, \
-1.017248705533150, 0.4904897450491537, 0.4904897450491537, \
-1.020788372759076, 0.4887020426375244, 0.4887020426375244, \
-1.024468480947418, 0.4867869623695373, 0.4867869623695373, \
-1.028479484429609, 0.4846799068522664, 0.4846799068522664, \
-1.032912799099277, 0.4823472441692478, 0.4823472441692478, \
-1.037819827886524, 0.4797686003141464, 0.4797686003141464, \
-1.043234046822683, 0.4769297459302527, 0.4769297459302527, \
-1.049180435706164, 0.4738193915630440, 0.4738193915630440, \
-1.055679935120273, 0.4704276057200363, 0.4704276057200363, \
-1.062751736724229, 0.4667449705472623, 0.4667449705472623, \
-1.070414550983853, 0.4627620974217875, 0.4627620974217875, \
-1.078687360998433, 0.4584693281785465, 0.4584693281785465, \
-1.087589905236103, 0.4538565361348418, 0.4538565361348418, \
-1.097143012277016, 0.4489129821999335, 0.4489129821999335, \
-1.107368853345095, 0.4436272015840848, 0.4436272015840848, \
-1.118291149511087, 0.4379869070529395, 0.4379869070529395, \
-1.129935355232285, 0.4319789002707483, 0.4319789002707483, \
-1.142328831586621, 0.4255889858779563, 0.4255889858779563, \
-1.155501017892830, 0.4188018847088123, 0.4188018847088123, \
-1.169483607737536, 0.4116011435655489, 0.4116011435655489, \
-1.184310733893104, 0.4039690395423833, 0.4039690395423833, \
-1.200019165741567, 0.3958864772075482, 0.3958864772075482, \
-1.216648522361481, 0.3873328771012455, 0.3873328771012455, \
-1.234241504239498, 0.3782860540463692, 0.3782860540463692, \
-1.252844146552834, 0.3687220837274974, 0.3687220837274974, \
-1.272506097084280, 0.3586151558878095, 0.3586151558878095, \
-1.293280922051315, 0.3479374123292613, 0.3479374123292613, \
-1.315226443441792, 0.3366587676768884, 0.3366587676768884, \
-1.338405111845920, 0.3247467105741579, 0.3247467105741579, \
-1.362884419259327, 0.3121660825936043, 0.3121660825936043, \
-1.388737356911202, 0.2988788316407807, 0.2988788316407807, \
-1.416042923855285, 0.2848437359376883, 0.2848437359376883, \
-1.444886692864052, 0.2700160936798396, 0.2700160936798396, \
-1.475361441106470, 0.2543473719483450, 0.2543473719483450, \
-1.507567854189896, 0.2377848059758584, 0.2377848059758584, \
-1.541615313435537, 0.2202709354414326, 0.2202709354414326, \
-1.577622777768627, 0.2017430558528476, 0.2017430558528476, \
-1.615719773381128, 0.1821325446156933, 0.1821325446156933, \
-1.656047506417338, 0.1613639775007101, 0.1613639775007101, \
-1.698760116403465, 0.1393538335966607, 0.1393538335966607, \
-1.744026091067076, 0.1160082215715578, 0.1160082215715578, \
-1.792029866664533, 0.09121768012666553, 0.09121768012666553, \
-1.842973642068455, 0.06484014122383102, 0.06484014122383102, \
-1.897079439804355, 0.03660439843618685, 0.03660439843618685, \
-1.954591453140504, 0.04495465807592131, -0.5304700428966110, \
0.9617145049738918, 0.5136572733231244, 0.5136572733231244, \
0.9782421162386464, 0.5091622720403828, 0.5091622720403828, \
0.9841638206870301, 0.5068960001106505, 0.5068960001106505, \
0.9880426813171772, 0.5051026509607854, 0.5051026509607854, \
0.9915340732285451, 0.5033470221778483, 0.5033470221778483, \
0.9951367992857782, 0.5014764441027626, 0.5014764441027626, \
0.9990482420490272, 0.4994241145530633, 0.4994241145530633, \
1.003362691101530, 0.4971554541454063, 0.4971554541454063, 1.008132797203973, \
0.4946496864896592, 0.4946496864896592, 1.013392528698270, \
0.4918924498711576, 0.4918924498711576, 1.019166960127407, \
0.4888724731455659, 0.4888724731455659, 1.025476891852811, \
0.4855799374319080, 0.4855799374319080, 1.032341219675430, \
0.4820056035569579, 0.4820056035569579, 1.039778243098797, \
0.4781403130446336, 0.4781403130446336, 1.047806440201933, \
0.4739746818249304, 0.4739746818249304, 1.056444960949889, \
0.4694988976752879, 0.4694988976752879, 1.065713966503586, \
0.4647025750838488, 0.4647025750838488, 1.075634882622872, \
0.4595746422055907, 0.4595746422055907, 1.086230605285132, \
0.4541032454007000, 0.4541032454007000, 1.097525680860463, \
0.4482756626505960, 0.4482756626505960, 1.109546474565700, \
0.4420782203669376, 0.4420782203669376, 1.122321336073462, \
0.4354962099395021, 0.4354962099395021, 1.135880768371173, \
0.4285138014245785, 0.4285138014245785, 1.150257604355792, \
0.4211139523832246, 0.4211139523832246, 1.165487194730089, \
0.4132783102174064, 0.4132783102174064, 1.181607610267646, \
0.4049871065220537, 0.4049871065220537, 1.198659861283989, \
0.3962190420295130, 0.3962190420295130, 1.216688137102639, \
0.3869511607021752, 0.3869511607021752, 1.235740068386781, \
0.3771587114468228, 0.3771587114468228, 1.255867015391066, \
0.3668149957886640, 0.3668149957886640, 1.277124385458834, \
0.3558911996554099, 0.3558911996554099, 1.299571983441632, \
0.3443562071774033, 0.3443562071774033, 1.323274399150327, \
0.3321763940972435, 0.3321763940972435, 1.348301436464944, \
0.3193153979805804, 0.3193153979805804, 1.374728589342144, \
0.3057338618923116, 0.3057338618923116, 1.402637570677105, \
0.2913891474850109, 0.2913891474850109, 1.432116900816135, \
0.2762350124213264, 0.2762350124213264, 1.463262563497514, \
0.2602212454929020, 0.2602212454929020, 1.496178738144910, \
0.2432932502447540, 0.2432932502447540, 1.530978618779995, \
0.2253915633704446, 0.2253915633704446, 1.567785331394423, \
0.2064512853029599, 0.2064512853029599, 1.606732963469896, \
0.1864013815003182, 0.1864013815003182, 1.647967721511625, \
0.1651637679463704, 0.1651637679463704, 1.691649235029914, \
0.1426519738664633, 0.1426519738664633, 1.737952028445710, \
0.1187688004384359, 0.1187688004384359, 1.787067186005689, \
0.09340098057461166, 0.09340098057461166, 1.839204239089649, \
0.06640171025064600, 0.06640171025064600, 1.894593310424366, \
0.03749173948021364, 0.03749173948021364, 1.953487555865242, \
-8.000000000000000, -0.7458886021154532, 0.6645519332238317, \
0.04495465807592131, -0.7458886021154532, 0.7383594591805913, \
0.05631742137339214, -0.5304700428966110, 0.6645519332238317, \
0.05631742137339214, -0.8886938529772608, 0.5171773850899694, \
0.5171773850899694, -0.9915553890487158, 0.4989099929084896, \
0.4989099929084896, -1.007564453644875, 0.4945418866494049, \
0.4945418866494049, -1.013369911632015, 0.4922971038303371, \
0.4922971038303371, -1.017248705533150, 0.4904897450491537, \
0.4904897450491537, -1.020788372759076, 0.4887020426375244, \
0.4887020426375244, -1.024468480947418, 0.4867869623695373, \
0.4867869623695373, -1.028479484429609, 0.4846799068522664, \
0.4846799068522664, -1.032912799099277, 0.4823472441692478, \
0.4823472441692478, -1.037819827886524, 0.4797686003141464, \
0.4797686003141464, -1.043234046822683, 0.4769297459302527, \
0.4769297459302527, -1.049180435706164, 0.4738193915630440, \
0.4738193915630440, -1.055679935120273, 0.4704276057200363, \
0.4704276057200363, -1.062751736724229, 0.4667449705472623, \
0.4667449705472623, -1.070414550983853, 0.4627620974217875, \
0.4627620974217875, -1.078687360998433, 0.4584693281785465, \
0.4584693281785465, -1.087589905236103, 0.4538565361348418, \
0.4538565361348418, -1.097143012277016, 0.4489129821999335, \
0.4489129821999335, -1.107368853345095, 0.4436272015840848, \
0.4436272015840848, -1.118291149511087, 0.4379869070529395, \
0.4379869070529395, -1.129935355232285, 0.4319789002707483, \
0.4319789002707483, -1.142328831586621, 0.4255889858779563, \
0.4255889858779563, -1.155501017892830, 0.4188018847088123, \
0.4188018847088123, -1.169483607737536, 0.4116011435655489, \
0.4116011435655489, -1.184310733893104, 0.4039690395423833, \
0.4039690395423833, -1.200019165741567, 0.3958864772075482, \
0.3958864772075482, -1.216648522361481, 0.3873328771012455, \
0.3873328771012455, -1.234241504239498, 0.3782860540463692, \
0.3782860540463692, -1.252844146552834, 0.3687220837274974, \
0.3687220837274974, -1.272506097084280, 0.3586151558878095, \
0.3586151558878095, -1.293280922051315, 0.3479374123292613, \
0.3479374123292613, -1.315226443441792, 0.3366587676768884, \
0.3366587676768884, -1.338405111845920, 0.3247467105741579, \
0.3247467105741579, -1.362884419259327, 0.3121660825936043, \
0.3121660825936043, -1.388737356911202, 0.2988788316407807, \
0.2988788316407807, -1.416042923855285, 0.2848437359376883, \
0.2848437359376883, -1.444886692864052, 0.2700160936798396, \
0.2700160936798396, -1.475361441106470, 0.2543473719483450, \
0.2543473719483450, -1.507567854189896, 0.2377848059758584, \
0.2377848059758584, -1.541615313435537, 0.2202709354414326, \
0.2202709354414326, -1.577622777768627, 0.2017430558528476, \
0.2017430558528476, -1.615719773381128, 0.1821325446156933, \
0.1821325446156933, -1.656047506417338, 0.1613639775007101, \
0.1613639775007101, -1.698760116403465, 0.1393538335966607, \
0.1393538335966607, -1.744026091067076, 0.1160082215715578, \
0.1160082215715578, -1.792029866664533, 0.09121768012666553, \
0.09121768012666553, -1.842973642068455, 0.06484014122383102, \
0.06484014122383102, -1.897079439804355, 0.03660439843618685, \
0.03660439843618685, -1.954591453140504, 0.04495465807592131, \
-0.5304700428966110, 0.9617145049738918, 0.5136572733231244, \
0.5136572733231244, 0.9782421162386464, 0.5091622720403828, \
0.5091622720403828, 0.9841638206870301, 0.5068960001106505, \
0.5068960001106505, 0.9880426813171772, 0.5051026509607854, \
0.5051026509607854, 0.9915340732285451, 0.5033470221778483, \
0.5033470221778483, 0.9951367992857782, 0.5014764441027626, \
0.5014764441027626, 0.9990482420490272, 0.4994241145530633, \
0.4994241145530633, 1.003362691101530, 0.4971554541454063, \
0.4971554541454063, 1.008132797203973, 0.4946496864896592, \
0.4946496864896592, 1.013392528698270, 0.4918924498711576, \
0.4918924498711576, 1.019166960127407, 0.4888724731455659, \
0.4888724731455659, 1.025476891852811, 0.4855799374319080, \
0.4855799374319080, 1.032341219675430, 0.4820056035569579, \
0.4820056035569579, 1.039778243098797, 0.4781403130446336, \
0.4781403130446336, 1.047806440201933, 0.4739746818249304, \
0.4739746818249304, 1.056444960949889, 0.4694988976752879, \
0.4694988976752879, 1.065713966503586, 0.4647025750838488, \
0.4647025750838488, 1.075634882622872, 0.4595746422055907, \
0.4595746422055907, 1.086230605285132, 0.4541032454007000, \
0.4541032454007000, 1.097525680860463, 0.4482756626505960, \
0.4482756626505960, 1.109546474565700, 0.4420782203669376, \
0.4420782203669376, 1.122321336073462, 0.4354962099395021, \
0.4354962099395021, 1.135880768371173, 0.4285138014245785, \
0.4285138014245785, 1.150257604355792, 0.4211139523832246, \
0.4211139523832246, 1.165487194730089, 0.4132783102174064, \
0.4132783102174064, 1.181607610267646, 0.4049871065220537, \
0.4049871065220537, 1.198659861283989, 0.3962190420295130, \
0.3962190420295130, 1.216688137102639, 0.3869511607021752, \
0.3869511607021752, 1.235740068386781, 0.3771587114468228, \
0.3771587114468228, 1.255867015391066, 0.3668149957886640, \
0.3668149957886640, 1.277124385458834, 0.3558911996554099, \
0.3558911996554099, 1.299571983441632, 0.3443562071774033, \
0.3443562071774033, 1.323274399150327, 0.3321763940972435, \
0.3321763940972435, 1.348301436464944, 0.3193153979805804, \
0.3193153979805804, 1.374728589342144, 0.3057338618923116, \
0.3057338618923116, 1.402637570677105, 0.2913891474850109, \
0.2913891474850109, 1.432116900816135, 0.2762350124213264, \
0.2762350124213264, 1.463262563497514, 0.2602212454929020, \
0.2602212454929020, 1.496178738144910, 0.2432932502447540, \
0.2432932502447540, 1.530978618779995, 0.2253915633704446, \
0.2253915633704446, 1.567785331394423, 0.2064512853029599, \
0.2064512853029599, 1.606732963469896, 0.1864013815003182, \
0.1864013815003182, 1.647967721511625, 0.1651637679463704, \
0.1651637679463704, 1.691649235029914, 0.1426519738664633, \
0.1426519738664633, 1.737952028445710, 0.1187688004384359, \
0.1187688004384359, 1.787067186005689, 0.09340098057461166, \
0.09340098057461166, 1.839204239089649, 0.06640171025064600, \
0.06640171025064600, 1.894593310424366, 0.03749173948021364, \
0.03749173948021364, 1.953487555865242})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.779360298570725*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"a6f912da-21ca-4d34-8159-c071090d6f60"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -9", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.779359280778961*^9}, {
  3.779359388191762*^9, 
  3.7793594076951942`*^9}},ExpressionUUID->"b06620ef-ef21-40c3-9615-\
ab3a8adea170"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "9"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, {3.779359285341239*^9, 
   3.779359286580131*^9}, 3.779359427614942*^9},
 CellLabel->"In[69]:=",ExpressionUUID->"189d329e-4566-4ef9-aa59-7ab23c8e4aea"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-9.000000000000000, \
-0.7428013050289997, 0.6683008178679325, 0.04025218111192845, \
-0.7428013050289997, 0.7482643549999599, 0.05063110918420330, \
-0.5313050808387739, 0.6683008178679325, 0.05063110918420330, \
-0.8864655736475872, 0.5174718019049293, 0.5174718019049293, \
-0.9914329547769220, 0.4988984083561874, 0.4988984083561874, \
-1.007638987322751, 0.4944940765914369, 0.4944940765914369, \
-1.013475112797981, 0.4922422212637564, 0.4922422212637564, \
-1.017360550397930, 0.4904334524574564, 0.4904334524574564, \
-1.020900922554917, 0.4886460212593210, 0.4886460212593210, \
-1.024579719365849, 0.4867318424626217, 0.4867318424626217, \
-1.028588598410716, 0.4846259563343261, 0.4846259563343261, \
-1.033019430612976, 0.4822945832198654, 0.4822945832198654, \
-1.037923816319207, 0.4797172816036086, 0.4797172816036086, \
-1.043335325767135, 0.4768797887296151, 0.4768797887296151, \
-1.049278986759719, 0.4737707977213830, 0.4737707977213830, \
-1.055775765357619, 0.4703803677391315, 0.4703803677391315, \
-1.062844866939708, 0.4666990759207071, 0.4666990759207071, \
-1.070505009203577, 0.4627175310880170, 0.4627175310880170, \
-1.078775178729959, 0.4584260739683081, 0.4584260739683081, \
-1.087675115212677, 0.4538145776576141, 0.4538145776576141, \
-1.097225647052480, 0.4488723034051484, 0.4488723034051484, \
-1.107448944390116, 0.4435877871278005, 0.4435877871278005, \
-1.118368726613381, 0.4379487425451189, 0.4379487425451189, \
-1.130010446085360, 0.4319419724478555, 0.4319419724478555, \
-1.142401461497250, 0.4255532827282984, 0.4255532827282984, \
-1.155571209563834, 0.4187673955679402, 0.4187673955679402, \
-1.169551381098069, 0.4115678591929504, 0.4115678591929504, \
-1.184376105958163, 0.4039369521869646, 0.4039369521869646, \
-1.200082150488365, 0.3958555806670544, 0.3958555806670544, \
-1.216709130614027, 0.3873031667792792, 0.3873031667792792, \
-1.234299743555162, 0.3782575270097061, 0.3782575270097061, \
-1.252900021106202, 0.3686947387657789, 0.3686947387657789, \
-1.272559607544589, 0.3585889935773003, 0.3585889935773003, \
-1.293332065450415, 0.3479124351021180, 0.3479124351021180, \
-1.315275213029946, 0.3366349798972488, 0.3366349798972488, \
-1.338451496932952, 0.3247241186223100, 0.3247241186223100, \
-1.362928405038721, 0.3121446949594955, 0.3121446949594955, \
-1.388778924264724, 0.2988586590281976, 0.2988586590281976, \
-1.416082049135574, 0.2848247913805518, 0.2848247913805518, \
-1.444923347652491, 0.2699983926722481, 0.2699983926722481, \
-1.475395591943354, 0.2543309325902717, 0.2543309325902717, \
-1.507599462273637, 0.2377696491368240, 0.2377696491368240, \
-1.541644334287254, 0.2202570849451331, 0.2202570849451331, \
-1.577649160858006, 0.2017305386868527, 0.2017305386868527, \
-1.615743461708913, 0.1821213911724978, 0.1821213911724978, \
-1.656068436049167, 0.1613542218610286, 0.1613542218610286, \
-1.698778215949017, 0.1393455138770627, 0.1393455138770627, \
-1.744041281097642, 0.1160013803902210, 0.1160013803902210, \
-1.792042059061075, 0.09121236535015525, 0.09121236535015525, \
-1.842982739291024, 0.06483640765789139, 0.06483640765789139, \
-1.897085334072333, 0.03660231492204224, 0.03660231492204224, \
-1.954594025511448, 0.04025218111192845, -0.5313050808387739, \
0.9613102764069414, 0.5137819755807233, 0.5137819755807233, \
0.9780454334131336, 0.5092501558988451, 0.5092501558988451, \
0.9839973181523311, 0.5069770837823111, 0.5069770837823111, \
0.9878824521915084, 0.5051824395702626, 0.5051824395702626, \
0.9913743985360664, 0.5034271403289280, 0.5034271403289280, \
0.9949757005987355, 0.5015575273120312, 0.5015575273120312, \
0.9988848658105982, 0.4995064601639646, 0.4995064601639646, \
1.003196609518523, 0.4972392203237130, 0.4972392203237130, 1.007963770620839, \
0.4947349659340494, 0.4947349659340494, 1.013220411109740, \
0.4919793009198803, 0.4919793009198803, 1.018991657254979, \
0.4889609341725584, 0.4889609341725584, 1.025298341054938, \
0.4856700339396743, 0.4856700339396743, 1.032159379846194, \
0.4820973517856904, 0.4820973517856904, 1.039593089520043, \
0.4782337217887836, 0.4782337217887836, 1.047617962036818, \
0.4740697532594434, 0.4740697532594434, 1.056253160249084, \
0.4695956275931993, 0.4695956275931993, 1.065518858146477, \
0.4648009527545592, 0.4648009527545592, 1.075436494888533, \
0.4596746499653969, 0.4596746499653969, 1.086028980889974, \
0.4542048580348597, 0.4542048580348597, 1.097320878377413, \
0.4483788465967493, 0.4483788465967493, 1.109338570184913, \
0.4421829327521757, 0.4421829327521757, 1.122110425692236, \
0.4356023974522406, 0.4356023974522406, 1.135666970018995, \
0.4286213990147523, 0.4286213990147523, 1.150041060973528, \
0.4212228817785693, 0.4212228817785693, 1.165268077332660, \
0.4133884782388219, 0.4133884782388219, 1.181386121528534, \
0.4050984031767003, 0.4050984031767003, 1.198436239588421, \
0.3963313383560245, 0.3963313383560245, 1.216462661124910, \
0.3870643063379400, 0.3870643063379400, 1.235513062256311, \
0.3772725318825023, 0.3772725318825023, 1.255638854521733, \
0.3669292892698225, 0.3669292892698225, 1.276895503127253, \
0.3560057336851825, 0.3560057336851825, 1.299342878212543, \
0.3444707145673713, 0.3444707145673713, 1.323045643261499, \
0.3322905685059463, 0.3322905685059463, 1.348073685300240, \
0.3194288888701871, 0.3194288888701871, 1.374502592140032, \
0.3058462688236521, 0.3058462688236521, 1.402414182643323, \
0.2915000136591372, 0.2915000136591372, 1.431897096833909, \
0.2763438173616256, 0.2763438173616256, 1.463047453657195, \
0.2603273967449421, 0.2603273967449421, 1.495969585347867, \
0.2433960739505946, 0.2433960739505946, 1.530776858709724, \
0.2254902935485145, 0.2254902935485145, 1.567592595192080, \
0.2065450516307168, 0.2065450516307168, 1.606551103502839, \
0.1864891953480219, 0.1864891953480219, 1.647798840683341, \
0.1652445063296792, 0.1652445063296792, 1.691495720149357, \
0.1427243608256403, 0.1427243608256403, 1.737816588255367, \
0.1188313849544558, 0.1188313849544558, 1.786952894562783, \
0.09345210885136326, 0.09345210885136326, 1.839114585306215, \
0.06643948447713374, 0.06643948447713374, 1.894532254702656, \
0.03751391213749663, 0.03751391213749663, 1.953459594918627, \
-9.000000000000000, -0.7428013050289997, 0.6683008178679325, \
0.04025218111192845, -0.7428013050289997, 0.7482643549999599, \
0.05063110918420330, -0.5313050808387739, 0.6683008178679325, \
0.05063110918420330, -0.8864655736475872, 0.5174718019049293, \
0.5174718019049293, -0.9914329547769220, 0.4988984083561874, \
0.4988984083561874, -1.007638987322751, 0.4944940765914369, \
0.4944940765914369, -1.013475112797981, 0.4922422212637564, \
0.4922422212637564, -1.017360550397930, 0.4904334524574564, \
0.4904334524574564, -1.020900922554917, 0.4886460212593210, \
0.4886460212593210, -1.024579719365849, 0.4867318424626217, \
0.4867318424626217, -1.028588598410716, 0.4846259563343261, \
0.4846259563343261, -1.033019430612976, 0.4822945832198654, \
0.4822945832198654, -1.037923816319207, 0.4797172816036086, \
0.4797172816036086, -1.043335325767135, 0.4768797887296151, \
0.4768797887296151, -1.049278986759719, 0.4737707977213830, \
0.4737707977213830, -1.055775765357619, 0.4703803677391315, \
0.4703803677391315, -1.062844866939708, 0.4666990759207071, \
0.4666990759207071, -1.070505009203577, 0.4627175310880170, \
0.4627175310880170, -1.078775178729959, 0.4584260739683081, \
0.4584260739683081, -1.087675115212677, 0.4538145776576141, \
0.4538145776576141, -1.097225647052480, 0.4488723034051484, \
0.4488723034051484, -1.107448944390116, 0.4435877871278005, \
0.4435877871278005, -1.118368726613381, 0.4379487425451189, \
0.4379487425451189, -1.130010446085360, 0.4319419724478555, \
0.4319419724478555, -1.142401461497250, 0.4255532827282984, \
0.4255532827282984, -1.155571209563834, 0.4187673955679402, \
0.4187673955679402, -1.169551381098069, 0.4115678591929504, \
0.4115678591929504, -1.184376105958163, 0.4039369521869646, \
0.4039369521869646, -1.200082150488365, 0.3958555806670544, \
0.3958555806670544, -1.216709130614027, 0.3873031667792792, \
0.3873031667792792, -1.234299743555162, 0.3782575270097061, \
0.3782575270097061, -1.252900021106202, 0.3686947387657789, \
0.3686947387657789, -1.272559607544589, 0.3585889935773003, \
0.3585889935773003, -1.293332065450415, 0.3479124351021180, \
0.3479124351021180, -1.315275213029946, 0.3366349798972488, \
0.3366349798972488, -1.338451496932952, 0.3247241186223100, \
0.3247241186223100, -1.362928405038721, 0.3121446949594955, \
0.3121446949594955, -1.388778924264724, 0.2988586590281976, \
0.2988586590281976, -1.416082049135574, 0.2848247913805518, \
0.2848247913805518, -1.444923347652491, 0.2699983926722481, \
0.2699983926722481, -1.475395591943354, 0.2543309325902717, \
0.2543309325902717, -1.507599462273637, 0.2377696491368240, \
0.2377696491368240, -1.541644334287254, 0.2202570849451331, \
0.2202570849451331, -1.577649160858006, 0.2017305386868527, \
0.2017305386868527, -1.615743461708913, 0.1821213911724978, \
0.1821213911724978, -1.656068436049167, 0.1613542218610286, \
0.1613542218610286, -1.698778215949017, 0.1393455138770627, \
0.1393455138770627, -1.744041281097642, 0.1160013803902210, \
0.1160013803902210, -1.792042059061075, 0.09121236535015525, \
0.09121236535015525, -1.842982739291024, 0.06483640765789139, \
0.06483640765789139, -1.897085334072333, 0.03660231492204224, \
0.03660231492204224, -1.954594025511448, 0.04025218111192845, \
-0.5313050808387739, 0.9613102764069414, 0.5137819755807233, \
0.5137819755807233, 0.9780454334131336, 0.5092501558988451, \
0.5092501558988451, 0.9839973181523311, 0.5069770837823111, \
0.5069770837823111, 0.9878824521915084, 0.5051824395702626, \
0.5051824395702626, 0.9913743985360664, 0.5034271403289280, \
0.5034271403289280, 0.9949757005987355, 0.5015575273120312, \
0.5015575273120312, 0.9988848658105982, 0.4995064601639646, \
0.4995064601639646, 1.003196609518523, 0.4972392203237130, \
0.4972392203237130, 1.007963770620839, 0.4947349659340494, \
0.4947349659340494, 1.013220411109740, 0.4919793009198803, \
0.4919793009198803, 1.018991657254979, 0.4889609341725584, \
0.4889609341725584, 1.025298341054938, 0.4856700339396743, \
0.4856700339396743, 1.032159379846194, 0.4820973517856904, \
0.4820973517856904, 1.039593089520043, 0.4782337217887836, \
0.4782337217887836, 1.047617962036818, 0.4740697532594434, \
0.4740697532594434, 1.056253160249084, 0.4695956275931993, \
0.4695956275931993, 1.065518858146477, 0.4648009527545592, \
0.4648009527545592, 1.075436494888533, 0.4596746499653969, \
0.4596746499653969, 1.086028980889974, 0.4542048580348597, \
0.4542048580348597, 1.097320878377413, 0.4483788465967493, \
0.4483788465967493, 1.109338570184913, 0.4421829327521757, \
0.4421829327521757, 1.122110425692236, 0.4356023974522406, \
0.4356023974522406, 1.135666970018995, 0.4286213990147523, \
0.4286213990147523, 1.150041060973528, 0.4212228817785693, \
0.4212228817785693, 1.165268077332660, 0.4133884782388219, \
0.4133884782388219, 1.181386121528534, 0.4050984031767003, \
0.4050984031767003, 1.198436239588421, 0.3963313383560245, \
0.3963313383560245, 1.216462661124910, 0.3870643063379400, \
0.3870643063379400, 1.235513062256311, 0.3772725318825023, \
0.3772725318825023, 1.255638854521733, 0.3669292892698225, \
0.3669292892698225, 1.276895503127253, 0.3560057336851825, \
0.3560057336851825, 1.299342878212543, 0.3444707145673713, \
0.3444707145673713, 1.323045643261499, 0.3322905685059463, \
0.3322905685059463, 1.348073685300240, 0.3194288888701871, \
0.3194288888701871, 1.374502592140032, 0.3058462688236521, \
0.3058462688236521, 1.402414182643323, 0.2915000136591372, \
0.2915000136591372, 1.431897096833909, 0.2763438173616256, \
0.2763438173616256, 1.463047453657195, 0.2603273967449421, \
0.2603273967449421, 1.495969585347867, 0.2433960739505946, \
0.2433960739505946, 1.530776858709724, 0.2254902935485145, \
0.2254902935485145, 1.567592595192080, 0.2065450516307168, \
0.2065450516307168, 1.606551103502839, 0.1864891953480219, \
0.1864891953480219, 1.647798840683341, 0.1652445063296792, \
0.1652445063296792, 1.691495720149357, 0.1427243608256403, \
0.1427243608256403, 1.737816588255367, 0.1188313849544558, \
0.1188313849544558, 1.786952894562783, 0.09345210885136326, \
0.09345210885136326, 1.839114585306215, 0.06643948447713374, \
0.06643948447713374, 1.894532254702656, 0.03751391213749663, \
0.03751391213749663, 1.953459594918627})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.779360366229598*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"6f80e5c2-c60d-444b-afc1-9e46c3169add"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = -10", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.779359280778961*^9}, {
  3.779359388191762*^9, 
  3.779359410232892*^9}},ExpressionUUID->"436b62c4-53ce-4c50-bfb2-\
37e3758aaff9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", 
   RowBox[{"-", "10"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBmIQzcN8LKtH443jNLPTOSD6n9q7MhD95NuschC9JCvj
Doh28E6/B6K3+B57BqIX2zq8ANFS2Qf+guiAsBP/QfS5g4tKe4G0HM8eMF16
c/VKEN2iuBFMH5rYvBVENymEbQfR9yy0doNoiTbzA2B5penHQPT2Q4/Pg2jZ
+aXXQPQ3O6/rIPrjCaZHIHrNUW4wPaF9whcQzZO8HEy3SS75C6IXSDIy9AHp
q5NPyoDoZ95b5UH0IcUubRDdZlNjAKLPsqw0A9E6j7eB6bzXq9xAdP6ES2D6
3q1d4SBaz3wvmAYACSqZ/A==
  "],
 CellLabel->"In[74]:=",ExpressionUUID->"e1717882-8c7d-4c97-8bb1-8374dfde073e"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{0, 0, 0, 0, 2, 2, 2, \
2, 4, 4, 4, 4, 6, 6, 6, 8, 8, 8, 10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, \
16, 18, 18, 18, 20, 20, 20, 22, 22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, \
30, 30, 30, 32, 32, 32, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, \
42, 42, 44, 44, 44, 46, 46, 46, 48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, \
54, 56, 56, 56, 58, 58, 58, 60, 60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, \
68, 68, 68, 70, 70, 70, 72, 72, 72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, \
80, 80, 82, 82, 82, 84, 84, 84, 86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, \
92, 94, 94, 94, 96, 96, 96, 98, 98, 98, 100, 100, 102, 102, 102, 102, 104, \
104, 104, 106, 106, 106, 108, 108, 108, 110, 110, 110, 112, 112, 112, 114, \
114, 114, 116, 116, 116, 118, 118, 118, 120, 120, 120, 122, 122, 122, 124, \
124, 124, 126, 126, 126, 128, 128, 128, 130, 130, 130, 132, 132, 132, 134, \
134, 134, 136, 136, 136, 138, 138, 138, 140, 140, 140, 142, 142, 142, 144, \
144, 144, 146, 146, 146, 148, 148, 148, 150, 150, 150, 152, 152, 152, 154, \
154, 154, 156, 156, 156, 158, 158, 158, 160, 160, 160, 162, 162, 162, 164, \
164, 164, 166, 166, 166, 168, 168, 168, 170, 170, 170, 172, 172, 172, 174, \
174, 174, 176, 176, 176, 178, 178, 178, 180, 180, 180, 182, 182, 182, 184, \
184, 184, 186, 186, 186, 188, 188, 188, 190, 190, 190, 192, 192, 192, 194, \
194, 194, 196, 196, 196, 198, 198, 1, 1, 1, 1, 3, 3, 3, 3, 5, 5, 5, 5, 7, 7, \
7, 9, 9, 9, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, \
21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, \
33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, \
47, 47, 47, 49, 49, 49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, \
59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, \
71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, \
85, 85, 85, 87, 87, 87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, \
97, 97, 99, 99, 99, 101, 101, 103, 103, 103, 103, 105, 105, 105, 107, 107, \
107, 109, 109, 109, 111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, \
117, 119, 119, 119, 121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, \
127, 129, 129, 129, 131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, \
137, 139, 139, 139, 141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, \
147, 149, 149, 149, 151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, \
157, 159, 159, 159, 161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, \
167, 169, 169, 169, 171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, \
177, 179, 179, 179, 181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, \
187, 189, 189, 189, 191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, \
197, 199, 199}, {0, 2, 4, 102, 0, 2, 4, 102, 0, 2, 4, 6, 4, 6, 8, 6, 8, 10, \
8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, \
22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, \
36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, \
46, 48, 50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, \
60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, \
74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, \
84, 86, 88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, \
98, 100, 98, 100, 0, 2, 102, 104, 102, 104, 106, 104, 106, 108, 106, 108, \
110, 108, 110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, \
120, 118, 120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, \
130, 128, 130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, \
140, 138, 140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, \
150, 148, 150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, \
160, 158, 160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, \
170, 168, 170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, \
180, 178, 180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, \
190, 188, 190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 1, \
3, 5, 103, 1, 3, 5, 103, 1, 3, 5, 7, 5, 7, 9, 7, 9, 11, 9, 11, 13, 11, 13, \
15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, \
25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, \
39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, 51, \
53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, \
63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, \
77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, 89, \
91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, 1, \
3, 103, 105, 103, 105, 107, 105, 107, 109, 107, 109, 111, 109, 111, 113, 111, \
113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, 121, \
123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, 131, \
133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, 141, \
143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, 151, \
153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, 161, \
163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, 171, \
173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, 181, \
183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, 191, \
193, 195, 193, 195, 197, 195, 197, 199, 197, 199},{-10.00000000000000, \
-0.7402580178872066, 0.6713347547548919, 0.03643781019618619, \
-0.7402580178872066, 0.7562806150256073, 0.04598515205418873, \
-0.5319536258798506, 0.6713347547548919, 0.04598515205418873, \
-0.8846329789243443, 0.5177135236429278, 0.5177135236429278, \
-0.9913321667246581, 0.4988893691973210, 0.4988893691973210, \
-1.007698759460138, 0.4944556720890713, 0.4944556720890713, \
-1.013559638535894, 0.4921981235272023, 0.4921981235272023, \
-1.017450417723762, 0.4903882203676870, 0.4903882203676870, \
-1.020991361834546, 0.4886010029342095, 0.4886010029342095, \
-1.024669115382660, 0.4866875425256713, 0.4866875425256713, \
-1.028676300253547, 0.4845825893339623, 0.4845825893339623, \
-1.033105151356518, 0.4822522455978952, 0.4822522455978952, \
-1.038007426789443, 0.4796760158728756, 0.4796760158728756, \
-1.043416772032838, 0.4768396107280450, 0.4768396107280450, \
-1.049358253232944, 0.4737317093678931, 0.4737317093678931, \
-1.055852856813414, 0.4703423634771873, 0.4703423634771873, \
-1.062919799134802, 0.4666621461802123, 0.4666621461802123, \
-1.070577803700090, 0.4626816642426105, 0.4626816642426105, \
-1.078845859902450, 0.4583912574908326, 0.4583912574908326, \
-1.087743708446767, 0.4537807988283350, 0.4537807988283350, \
-1.097292177621529, 0.4488395497607833, 0.4488395497607833, \
-1.107513436731436, 0.4435560467554979, 0.4435560467554979, \
-1.118431203846738, 0.4379180042812769, 0.4379180042812769, \
-1.130070929681735, 0.4319122260174048, 0.4319122260174048, \
-1.142459971042274, 0.4255245188463050, 0.4255245188463050, \
-1.155627762581274, 0.4187396060173202, 0.4187396060173202, \
-1.169605992911232, 0.4115410368872527, 0.4115410368872527, \
-1.184428789574634, 0.4039110912241981, 0.4039110912241981, \
-1.200132916498211, 0.3958306763786704, 0.3958306763786704, \
-1.216757987094577, 0.3872792157772313, 0.3872792157772313, \
-1.234346695977374, 0.3782345272337473, 0.3782345272337473, \
-1.252945072238849, 0.3686726895326636, 0.3686726895326636, \
-1.272602757353321, 0.3585678956332459, 0.3585678956332459, \
-1.293373310989204, 0.3478922906796893, 0.3478922906796893, \
-1.315314548322770, 0.3366157927777238, 0.3366157927777238, \
-1.338488912843709, 0.3247058942045393, 0.3247058942045393, \
-1.362963889127429, 0.3121274403362799, 0.3121274403362799, \
-1.388812460628037, 0.2988423830712554, 0.2988423830712554, \
-1.416113618229571, 0.2848095048352486, 0.2848095048352486, \
-1.444952926095526, 0.2699841082634085, 0.2699841082634085, \
-1.475423152296583, 0.2543176651406180, 0.2543176651406180, \
-1.507624972796568, 0.2377574156999183, 0.2377574156999183, \
-1.541667758665354, 0.2202459049552347, 0.2202459049552347, \
-1.577670457899051, 0.2017204341290199, 0.2017204341290199, \
-1.615762585004317, 0.1821123867780104, 0.1821123867780104, \
-1.656085333596001, 0.1613463453369359, 0.1613463453369359, \
-1.698792829727856, 0.1393387961877081, 0.1393387961877081, \
-1.744053546600648, 0.1159958561341884, 0.1159958561341884, \
-1.792051904763894, 0.09120807336422794, 0.09120807336422794, \
-1.842990086061131, 0.06483339238354526, 0.06483339238354526, \
-1.897090094505269, 0.03660063213816318, 0.03660063213816318, \
-1.954596103185083, 0.03643781019618619, -0.5319536258798506, \
0.9609815343205316, 0.5138829004766956, 0.5138829004766956, \
0.9778867809335267, 0.5093209181679777, 0.5093209181679777, \
0.9838633765465700, 0.5070422817438535, 0.5070422817438535, \
0.9877536397354086, 0.5052465804836853, 0.5052465804836853, \
0.9912460339045340, 0.5034915541017365, 0.5034915541017365, \
0.9948461636017920, 0.5016227348109523, 0.5016227348109523, \
0.9987534559433242, 0.4995727058972288, 0.4995727058972288, \
1.003062974037627, 0.4973066351869213, 0.4973066351869213, 1.007827710252950, \
0.4948036274663923, 0.4948036274663923, 1.013081802823297, \
0.4920492587257604, 0.4920492587257604, 1.018850420001147, \
0.4890322216855831, 0.4890322216855831, 1.025154419350267, \
0.4857426742196023, 0.4857426742196023, 1.032012735515238, \
0.4821713604696485, 0.4821713604696485, 1.039443697484002, \
0.4783091085783202, 0.4783091085783202, 1.047465808259852, \
0.4741465225984851, 0.4741465225984851, 1.056098240920818, \
0.4696737788647247, 0.4696737788647247, 1.065361179629497, \
0.4648804801666315, 0.4648804801666315, 1.075276074182270, \
0.4597555422173307, 0.4597555422173307, 1.085865846478493, \
0.4542870978115347, 0.4542870978115347, 1.097155071392450, \
0.4484624099149687, 0.4484624099149687, 1.109170145852467, \
0.4422677881685687, 0.4422677881685687, 1.121939455053826, \
0.4356885051330255, 0.4356885051330255, 1.135493541933785, \
0.4287087096613133, 0.4287087096613133, 1.149865284418480, \
0.4213113353979687, 0.4213113353979687, 1.165090084026635, \
0.4134780027443013, 0.4134780027443013, 1.181206068913935, \
0.4051889127994779, 0.4051889127994779, 1.198254314211402, \
0.3964227318459698, 0.3964227318459698, 1.216279082462713, \
0.3871564649268041, 0.3871564649268041, 1.235328087048354, \
0.3773653169791336, 0.3773653169791336, 1.255452781669990, \
0.3670225398520730, 0.3670225398520730, 1.276708679241360, \
0.3560992633478709, 0.3560992633478709, 1.299155703886386, \
0.3445643081795755, 0.3445643081795755, 1.322858580180865, \
0.3323839784238999, 0.3323839784238999, 1.347887264295883, \
0.3195218306439623, 0.3195218306439623, 1.374317422317499, \
0.3059384163264169, 0.3059384163264169, 1.402230961740467, \
0.2915909935567865, 0.2915909935567865, 1.431716622979693, \
0.2764332028276487, 0.2764332028276487, 1.462870638731662, \
0.2604147003099703, 0.2604147003099703, 1.495797470173603, \
0.2434807393573727, 0.2434807393573727, 1.530610630340576, \
0.2255716864596811, 0.2255716864596811, 1.567433606606115, \
0.2066224490061318, 0.2066224490061318, 1.606400896054572, \
0.1865617732647262, 0.1865617732647262, 1.647659169726388, \
0.1653113259468367, 0.1653113259468367, 1.691368584306258, \
0.1427843520591253, 0.1427843520591253, 1.737704262888206, \
0.1188833270887461, 0.1188833270887461, 1.786857970088352, \
0.09349460624011585, 0.09349460624011585, 1.839040011105478, \
0.06647093070149338, 0.06647093070149338, 1.894481389499031, \
0.03753240001484863, 0.03753240001484863, 1.953436264646821, \
-10.00000000000000, -0.7402580178872066, 0.6713347547548919, \
0.03643781019618619, -0.7402580178872066, 0.7562806150256073, \
0.04598515205418873, -0.5319536258798506, 0.6713347547548919, \
0.04598515205418873, -0.8846329789243443, 0.5177135236429278, \
0.5177135236429278, -0.9913321667246581, 0.4988893691973210, \
0.4988893691973210, -1.007698759460138, 0.4944556720890713, \
0.4944556720890713, -1.013559638535894, 0.4921981235272023, \
0.4921981235272023, -1.017450417723762, 0.4903882203676870, \
0.4903882203676870, -1.020991361834546, 0.4886010029342095, \
0.4886010029342095, -1.024669115382660, 0.4866875425256713, \
0.4866875425256713, -1.028676300253547, 0.4845825893339623, \
0.4845825893339623, -1.033105151356518, 0.4822522455978952, \
0.4822522455978952, -1.038007426789443, 0.4796760158728756, \
0.4796760158728756, -1.043416772032838, 0.4768396107280450, \
0.4768396107280450, -1.049358253232944, 0.4737317093678931, \
0.4737317093678931, -1.055852856813414, 0.4703423634771873, \
0.4703423634771873, -1.062919799134802, 0.4666621461802123, \
0.4666621461802123, -1.070577803700090, 0.4626816642426105, \
0.4626816642426105, -1.078845859902450, 0.4583912574908326, \
0.4583912574908326, -1.087743708446767, 0.4537807988283350, \
0.4537807988283350, -1.097292177621529, 0.4488395497607833, \
0.4488395497607833, -1.107513436731436, 0.4435560467554979, \
0.4435560467554979, -1.118431203846738, 0.4379180042812769, \
0.4379180042812769, -1.130070929681735, 0.4319122260174048, \
0.4319122260174048, -1.142459971042274, 0.4255245188463050, \
0.4255245188463050, -1.155627762581274, 0.4187396060173202, \
0.4187396060173202, -1.169605992911232, 0.4115410368872527, \
0.4115410368872527, -1.184428789574634, 0.4039110912241981, \
0.4039110912241981, -1.200132916498211, 0.3958306763786704, \
0.3958306763786704, -1.216757987094577, 0.3872792157772313, \
0.3872792157772313, -1.234346695977374, 0.3782345272337473, \
0.3782345272337473, -1.252945072238849, 0.3686726895326636, \
0.3686726895326636, -1.272602757353321, 0.3585678956332459, \
0.3585678956332459, -1.293373310989204, 0.3478922906796893, \
0.3478922906796893, -1.315314548322770, 0.3366157927777238, \
0.3366157927777238, -1.338488912843709, 0.3247058942045393, \
0.3247058942045393, -1.362963889127429, 0.3121274403362799, \
0.3121274403362799, -1.388812460628037, 0.2988423830712554, \
0.2988423830712554, -1.416113618229571, 0.2848095048352486, \
0.2848095048352486, -1.444952926095526, 0.2699841082634085, \
0.2699841082634085, -1.475423152296583, 0.2543176651406180, \
0.2543176651406180, -1.507624972796568, 0.2377574156999183, \
0.2377574156999183, -1.541667758665354, 0.2202459049552347, \
0.2202459049552347, -1.577670457899051, 0.2017204341290199, \
0.2017204341290199, -1.615762585004317, 0.1821123867780104, \
0.1821123867780104, -1.656085333596001, 0.1613463453369359, \
0.1613463453369359, -1.698792829727856, 0.1393387961877081, \
0.1393387961877081, -1.744053546600648, 0.1159958561341884, \
0.1159958561341884, -1.792051904763894, 0.09120807336422794, \
0.09120807336422794, -1.842990086061131, 0.06483339238354526, \
0.06483339238354526, -1.897090094505269, 0.03660063213816318, \
0.03660063213816318, -1.954596103185083, 0.03643781019618619, \
-0.5319536258798506, 0.9609815343205316, 0.5138829004766956, \
0.5138829004766956, 0.9778867809335267, 0.5093209181679777, \
0.5093209181679777, 0.9838633765465700, 0.5070422817438535, \
0.5070422817438535, 0.9877536397354086, 0.5052465804836853, \
0.5052465804836853, 0.9912460339045340, 0.5034915541017365, \
0.5034915541017365, 0.9948461636017920, 0.5016227348109523, \
0.5016227348109523, 0.9987534559433242, 0.4995727058972288, \
0.4995727058972288, 1.003062974037627, 0.4973066351869213, \
0.4973066351869213, 1.007827710252950, 0.4948036274663923, \
0.4948036274663923, 1.013081802823297, 0.4920492587257604, \
0.4920492587257604, 1.018850420001147, 0.4890322216855831, \
0.4890322216855831, 1.025154419350267, 0.4857426742196023, \
0.4857426742196023, 1.032012735515238, 0.4821713604696485, \
0.4821713604696485, 1.039443697484002, 0.4783091085783202, \
0.4783091085783202, 1.047465808259852, 0.4741465225984851, \
0.4741465225984851, 1.056098240920818, 0.4696737788647247, \
0.4696737788647247, 1.065361179629497, 0.4648804801666315, \
0.4648804801666315, 1.075276074182270, 0.4597555422173307, \
0.4597555422173307, 1.085865846478493, 0.4542870978115347, \
0.4542870978115347, 1.097155071392450, 0.4484624099149687, \
0.4484624099149687, 1.109170145852467, 0.4422677881685687, \
0.4422677881685687, 1.121939455053826, 0.4356885051330255, \
0.4356885051330255, 1.135493541933785, 0.4287087096613133, \
0.4287087096613133, 1.149865284418480, 0.4213113353979687, \
0.4213113353979687, 1.165090084026635, 0.4134780027443013, \
0.4134780027443013, 1.181206068913935, 0.4051889127994779, \
0.4051889127994779, 1.198254314211402, 0.3964227318459698, \
0.3964227318459698, 1.216279082462713, 0.3871564649268041, \
0.3871564649268041, 1.235328087048354, 0.3773653169791336, \
0.3773653169791336, 1.255452781669990, 0.3670225398520730, \
0.3670225398520730, 1.276708679241360, 0.3560992633478709, \
0.3560992633478709, 1.299155703886386, 0.3445643081795755, \
0.3445643081795755, 1.322858580180865, 0.3323839784238999, \
0.3323839784238999, 1.347887264295883, 0.3195218306439623, \
0.3195218306439623, 1.374317422317499, 0.3059384163264169, \
0.3059384163264169, 1.402230961740467, 0.2915909935567865, \
0.2915909935567865, 1.431716622979693, 0.2764332028276487, \
0.2764332028276487, 1.462870638731662, 0.2604147003099703, \
0.2604147003099703, 1.495797470173603, 0.2434807393573727, \
0.2434807393573727, 1.530610630340576, 0.2255716864596811, \
0.2255716864596811, 1.567433606606115, 0.2066224490061318, \
0.2066224490061318, 1.606400896054572, 0.1865617732647262, \
0.1865617732647262, 1.647659169726388, 0.1653113259468367, \
0.1653113259468367, 1.691368584306258, 0.1427843520591253, \
0.1427843520591253, 1.737704262888206, 0.1188833270887461, \
0.1188833270887461, 1.786857970088352, 0.09349460624011585, \
0.09349460624011585, 1.839040011105478, 0.06647093070149338, \
0.06647093070149338, 1.894481389499031, 0.03753240001484863, \
0.03753240001484863, 1.953436264646821})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.7793593501925592`*^9, 3.779360433009015*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"e8324558-d0e1-4b35-b5d8-8856db9aeba6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 5    Epsilond = 0 with core orbitals", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.7793592558686867`*^9}, {
  3.7795515401251583`*^9, 
  3.779551540713271*^9}},ExpressionUUID->"6113eb02-8060-4c8c-a064-\
9cd95b00c76c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, 3.779359230885201*^9, 
   3.779551547489818*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"c3a5240e-67c3-4331-9889-06aa10799b1a"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{6, 6, 6, 8, 8, 8, 10, \
10, 10, 10, 12, 12, 14, 14, 14, 14, 16, 16, 7, 7, 7, 9, 9, 9, 11, 11, 11, 11, \
13, 13, 15, 15, 15, 15, 17, 17}, {8, 10, 14, 6, 10, 14, 6, 8, 10, 12, 10, 12, \
6, 8, 14, 16, 14, 16, 9, 11, 15, 7, 11, 15, 7, 9, 11, 13, 11, 13, 7, 9, 15, \
17, 15, 17},{0.8711192398635158, 0.3472400250112380, 0.3472400250112380, \
0.8711192398635158, -0.3472400250112380, 0.3472400250112380, \
0.3472400250112380, -0.3472400250112380, -1.133575598779010, \
0.3577336521481784, 0.3577336521481784, -1.489264368792409, \
0.3472400250112380, 0.3472400250112380, 1.133575598779010, \
0.3577336521481784, 0.3577336521481784, 1.489264368792409, \
0.8711192398635158, 0.3472400250112380, 0.3472400250112380, \
0.8711192398635158, -0.3472400250112380, 0.3472400250112380, \
0.3472400250112380, -0.3472400250112380, -1.133575598779010, \
0.3577336521481784, 0.3577336521481784, -1.489264368792409, \
0.3472400250112380, 0.3472400250112380, 1.133575598779010, \
0.3577336521481784, 0.3577336521481784, 1.489264368792409})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, {
   3.779359220138113*^9, 3.7793592312112217`*^9}, 3.7793594991073437`*^9, 
   3.779550283480158*^9, 3.7795515486246357`*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"eb6d350d-3702-4b06-b1d2-9389b7c3b873"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 11    Epsilond = 0 with core orbitals", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.7793592558686867`*^9}, {
  3.779550253827518*^9, 3.7795502540345907`*^9}, {3.779551538430015*^9, 
  3.779551538878499*^9}},ExpressionUUID->"738a77ba-22ff-4778-a9a6-\
d1ad655b6edb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "11"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, 3.779359230885201*^9, {
   3.7795502943317337`*^9, 3.779550294530637*^9}, 3.779551556409005*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"8305051e-73d0-4ea1-8b58-277ac14386b6"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{6, 6, 6, 8, 8, 8, 10, \
10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, 16, 18, 18, 20, 20, 20, 20, 22, \
22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 7, 7, 7, 9, 9, 9, 11, 11, 11, 11, 13, \
13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 21, 21, 21, 21, 23, 23, 23, 25, 25, \
25, 27, 27, 27, 29, 29}, {8, 10, 20, 6, 10, 20, 6, 8, 10, 12, 10, 12, 14, 12, \
14, 16, 14, 16, 18, 16, 18, 6, 8, 20, 22, 20, 22, 24, 22, 24, 26, 24, 26, 28, \
26, 28, 9, 11, 21, 7, 11, 21, 7, 9, 11, 13, 11, 13, 15, 13, 15, 17, 15, 17, \
19, 17, 19, 7, 9, 21, 23, 21, 23, 25, 23, 25, 27, 25, 27, 29, 27, \
29},{-0.8550976851855241, 0.3666114760822132, 0.3666114760822132, \
-0.8550976851855241, 0.3666114760822132, -0.3666114760822132, \
0.3666114760822132, 0.3666114760822132, -1.015230218408785, \
0.4711704775408612, 0.4711704775408612, -1.103069038676347, \
0.4209553704382022, 0.4209553704382022, -1.224241080048528, \
0.3460825268674989, 0.3460825268674989, -1.407777364267011, \
0.2305702589219096, 0.2305702589219096, -1.690814423972560, \
0.3666114760822132, -0.3666114760822132, 1.015230218408785, \
0.4711704775408612, 0.4711704775408612, 1.103069038676347, \
0.4209553704382022, 0.4209553704382022, 1.224241080048528, \
0.3460825268674989, 0.3460825268674989, 1.407777364267011, \
0.2305702589219096, 0.2305702589219096, 1.690814423972560, \
-0.8550976851855241, 0.3666114760822132, 0.3666114760822132, \
-0.8550976851855241, 0.3666114760822132, -0.3666114760822132, \
0.3666114760822132, 0.3666114760822132, -1.015230218408785, \
0.4711704775408612, 0.4711704775408612, -1.103069038676347, \
0.4209553704382022, 0.4209553704382022, -1.224241080048528, \
0.3460825268674989, 0.3460825268674989, -1.407777364267011, \
0.2305702589219096, 0.2305702589219096, -1.690814423972560, \
0.3666114760822132, -0.3666114760822132, 1.015230218408785, \
0.4711704775408612, 0.4711704775408612, 1.103069038676347, \
0.4209553704382022, 0.4209553704382022, 1.224241080048528, \
0.3460825268674989, 0.3460825268674989, 1.407777364267011, \
0.2305702589219096, 0.2305702589219096, 1.690814423972560})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, {
   3.779359220138113*^9, 3.7793592312112217`*^9}, 3.7793594991073437`*^9, {
   3.779550290244526*^9, 3.7795502950994587`*^9}, 3.7795515569946213`*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"e78d8873-df75-4bb3-a286-01e24bdaf9c5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 21    Epsilond = 0 with core orbitals", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.7793592558686867`*^9}, {
  3.779550260425435*^9, 3.779550260524317*^9}, {3.7795515367057734`*^9, 
  3.7795515373015003`*^9}},ExpressionUUID->"58fdff1a-c040-4df7-956d-\
b5df9588dacc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "21"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, 3.779359230885201*^9, {
   3.7795502998501453`*^9, 3.779550299988348*^9}, 3.779558806501871*^9},
 CellLabel->"In[41]:=",ExpressionUUID->"f16dfe66-26c6-4c68-bfa0-18c7186b9925"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{6, 6, 6, 8, 8, 8, 10, \
10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, 16, 18, 18, 18, 20, 20, 20, 22, \
22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 30, 30, 30, 30, 32, 32, 32, 34, 34, \
34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, 42, 42, 44, 44, 44, 46, 46, 46, \
48, 48, 7, 7, 7, 9, 9, 9, 11, 11, 11, 11, 13, 13, 13, 15, 15, 15, 17, 17, 17, \
19, 19, 19, 21, 21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, 29, 31, 31, \
31, 31, 33, 33, 33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, 41, 43, 43, \
43, 45, 45, 45, 47, 47, 47, 49, 49}, {8, 10, 30, 6, 10, 30, 6, 8, 10, 12, 10, \
12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, 22, 24, 22, 24, \
26, 24, 26, 28, 26, 28, 6, 8, 30, 32, 30, 32, 34, 32, 34, 36, 34, 36, 38, 36, \
38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, 46, 48, 9, 11, 31, 7, \
11, 31, 7, 9, 11, 13, 11, 13, 15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, \
23, 21, 23, 25, 23, 25, 27, 25, 27, 29, 27, 29, 7, 9, 31, 33, 31, 33, 35, 33, \
35, 37, 35, 37, 39, 37, 39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, \
49, 47, 49},{0.8508135156344978, 0.3715618129017473, 0.3715618129017473, \
0.8508135156344978, -0.3715618129017473, 0.3715618129017473, \
0.3715618129017473, -0.3715618129017473, -0.9863917223894534, \
0.4963249202903262, 0.4963249202903262, -1.024380564774505, \
0.4791651511535990, 0.4791651511535990, -1.060565128580510, \
0.4590017663462531, 0.4590017663462531, -1.106188470311259, \
0.4330639709245659, 0.4330639709245659, -1.164992786960643, \
0.3997214526481756, 0.3997214526481756, -1.240246751069489, \
0.3571726949331372, 0.3571726949331372, -1.335990541136208, \
0.3030296550878047, 0.3030296550878047, -1.457704916849321, \
0.2339051214406751, 0.2339051214406751, -1.613094699843629, \
0.1445150150036315, 0.1445150150036315, -1.813274446037396, \
0.3715618129017473, 0.3715618129017473, 0.9863917223894534, \
0.4963249202903262, 0.4963249202903262, 1.024380564774505, \
0.4791651511535990, 0.4791651511535990, 1.060565128580510, \
0.4590017663462531, 0.4590017663462531, 1.106188470311259, \
0.4330639709245659, 0.4330639709245659, 1.164992786960643, \
0.3997214526481756, 0.3997214526481756, 1.240246751069489, \
0.3571726949331372, 0.3571726949331372, 1.335990541136208, \
0.3030296550878047, 0.3030296550878047, 1.457704916849321, \
0.2339051214406751, 0.2339051214406751, 1.613094699843629, \
0.1445150150036315, 0.1445150150036315, 1.813274446037396, \
0.8508135156344978, 0.3715618129017473, 0.3715618129017473, \
0.8508135156344978, -0.3715618129017473, 0.3715618129017473, \
0.3715618129017473, -0.3715618129017473, -0.9863917223894534, \
0.4963249202903262, 0.4963249202903262, -1.024380564774505, \
0.4791651511535990, 0.4791651511535990, -1.060565128580510, \
0.4590017663462531, 0.4590017663462531, -1.106188470311259, \
0.4330639709245659, 0.4330639709245659, -1.164992786960643, \
0.3997214526481756, 0.3997214526481756, -1.240246751069489, \
0.3571726949331372, 0.3571726949331372, -1.335990541136208, \
0.3030296550878047, 0.3030296550878047, -1.457704916849321, \
0.2339051214406751, 0.2339051214406751, -1.613094699843629, \
0.1445150150036315, 0.1445150150036315, -1.813274446037396, \
0.3715618129017473, 0.3715618129017473, 0.9863917223894534, \
0.4963249202903262, 0.4963249202903262, 1.024380564774505, \
0.4791651511535990, 0.4791651511535990, 1.060565128580510, \
0.4590017663462531, 0.4590017663462531, 1.106188470311259, \
0.4330639709245659, 0.4330639709245659, 1.164992786960643, \
0.3997214526481756, 0.3997214526481756, 1.240246751069489, \
0.3571726949331372, 0.3571726949331372, 1.335990541136208, \
0.3030296550878047, 0.3030296550878047, 1.457704916849321, \
0.2339051214406751, 0.2339051214406751, 1.613094699843629, \
0.1445150150036315, 0.1445150150036315, 1.813274446037396})\"\>"], "Output",
 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, {
   3.779359220138113*^9, 3.7793592312112217`*^9}, 3.7793594991073437`*^9, 
   3.779550301165957*^9, 3.779558807702737*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"d0f9327c-0996-433b-92d7-ca3d2b54850d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 41    Epsilond = 0 with core orbitals", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.7793592558686867`*^9}, {
  3.779550272334642*^9, 3.779550272488977*^9}, {3.7795515344140177`*^9, 
  3.779551534813614*^9}},ExpressionUUID->"4857a49a-9aff-4d65-b9b4-\
9c9f67c6b27d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", "41"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, 3.779359230885201*^9, {
   3.7795503053244753`*^9, 3.779550306714127*^9}, 3.779591392772053*^9},
 CellLabel->"In[47]:=",ExpressionUUID->"cee78fb8-626e-4b2f-bf0c-2de284d48e87"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{6, 6, 6, 8, 8, 8, 10, \
10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, 16, 18, 18, 18, 20, 20, 20, 22, \
22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, 30, 30, 30, 32, 32, 32, 34, 34, \
34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, 42, 42, 44, 44, 44, 46, 46, 46, \
48, 48, 50, 50, 50, 50, 52, 52, 52, 54, 54, 54, 56, 56, 56, 58, 58, 58, 60, \
60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, 68, 68, 68, 70, 70, 70, 72, 72, \
72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, 80, 80, 82, 82, 82, 84, 84, 84, \
86, 86, 86, 88, 88, 7, 7, 7, 9, 9, 9, 11, 11, 11, 11, 13, 13, 13, 15, 15, 15, \
17, 17, 17, 19, 19, 19, 21, 21, 21, 23, 23, 23, 25, 25, 25, 27, 27, 27, 29, \
29, 29, 31, 31, 31, 33, 33, 33, 35, 35, 35, 37, 37, 37, 39, 39, 39, 41, 41, \
41, 43, 43, 43, 45, 45, 45, 47, 47, 47, 49, 49, 51, 51, 51, 51, 53, 53, 53, \
55, 55, 55, 57, 57, 57, 59, 59, 59, 61, 61, 61, 63, 63, 63, 65, 65, 65, 67, \
67, 67, 69, 69, 69, 71, 71, 71, 73, 73, 73, 75, 75, 75, 77, 77, 77, 79, 79, \
79, 81, 81, 81, 83, 83, 83, 85, 85, 85, 87, 87, 87, 89, 89}, {8, 10, 50, 6, \
10, 50, 6, 8, 10, 12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, \
22, 20, 22, 24, 22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, \
32, 34, 36, 34, 36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, \
46, 48, 46, 48, 6, 8, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, \
58, 60, 62, 60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, \
72, 74, 72, 74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, \
86, 84, 86, 88, 86, 88, 9, 11, 51, 7, 11, 51, 7, 9, 11, 13, 11, 13, 15, 13, \
15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, 27, 25, 27, \
29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, 37, 39, 41, \
39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 7, 9, 51, 53, 51, 53, \
55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, 65, 63, 65, 67, \
65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, 75, 77, 79, 77, \
79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, \
89},{0.8493933400039547, 0.3731829001688891, 0.3731829001688891, \
0.8493933400039547, -0.3731829001688891, 0.3731829001688891, \
0.3731829001688891, -0.3731829001688891, -0.9770705006379899, \
0.5042767798831333, 0.5042767798831333, -1.000064317842622, \
0.4965603680836179, 0.4965603680836179, -1.013234488124659, \
0.4901423447226700, 0.4901423447226700, -1.026571239104735, \
0.4830115097690691, 0.4830115097690691, -1.041998568489590, \
0.4746314928588816, 0.4746314928588816, -1.060205152697242, \
0.4647514290983590, 0.4647514290983590, -1.081599105145350, \
0.4531895670208550, 0.4531895670208550, -1.106526085655485, \
0.4397732950884204, 0.4397732950884204, -1.135340816454641, \
0.4243160198749000, 0.4243160198749000, -1.168439526221691, \
0.4066046656931699, 0.4066046656931699, -1.206280765644405, \
0.3863901565540565, 0.3863901565540565, -1.249403576770582, \
0.3633780301917777, 0.3633780301917777, -1.298446803111865, \
0.3372177224742490, 0.3372177224742490, -1.354171759367345, \
0.3074893665170716, 0.3074893665170716, -1.417490130249630, \
0.2736866955245105, 0.2736866955245105, -1.489499152668544, \
0.2351935923638701, 0.2351935923638701, -1.571526669801396, \
0.1912482099764827, 0.1912482099764827, -1.665189528340305, \
0.1408715308097474, 0.1408715308097474, -1.772470122495835, \
0.08259715566815579, 0.08259715566815579, -1.895817868839552, \
0.3731829001688891, 0.3731829001688891, 0.9770705006379899, \
0.5042767798831333, 0.5042767798831333, 1.000064317842622, \
0.4965603680836179, 0.4965603680836179, 1.013234488124659, \
0.4901423447226700, 0.4901423447226700, 1.026571239104735, \
0.4830115097690691, 0.4830115097690691, 1.041998568489590, \
0.4746314928588816, 0.4746314928588816, 1.060205152697242, \
0.4647514290983590, 0.4647514290983590, 1.081599105145350, \
0.4531895670208550, 0.4531895670208550, 1.106526085655485, \
0.4397732950884204, 0.4397732950884204, 1.135340816454641, \
0.4243160198749000, 0.4243160198749000, 1.168439526221691, \
0.4066046656931699, 0.4066046656931699, 1.206280765644405, \
0.3863901565540565, 0.3863901565540565, 1.249403576770582, \
0.3633780301917777, 0.3633780301917777, 1.298446803111865, \
0.3372177224742490, 0.3372177224742490, 1.354171759367345, \
0.3074893665170716, 0.3074893665170716, 1.417490130249630, \
0.2736866955245105, 0.2736866955245105, 1.489499152668544, \
0.2351935923638701, 0.2351935923638701, 1.571526669801396, \
0.1912482099764827, 0.1912482099764827, 1.665189528340305, \
0.1408715308097474, 0.1408715308097474, 1.772470122495835, \
0.08259715566815579, 0.08259715566815579, 1.895817868839552, \
0.8493933400039547, 0.3731829001688891, 0.3731829001688891, \
0.8493933400039547, -0.3731829001688891, 0.3731829001688891, \
0.3731829001688891, -0.3731829001688891, -0.9770705006379899, \
0.5042767798831333, 0.5042767798831333, -1.000064317842622, \
0.4965603680836179, 0.4965603680836179, -1.013234488124659, \
0.4901423447226700, 0.4901423447226700, -1.026571239104735, \
0.4830115097690691, 0.4830115097690691, -1.041998568489590, \
0.4746314928588816, 0.4746314928588816, -1.060205152697242, \
0.4647514290983590, 0.4647514290983590, -1.081599105145350, \
0.4531895670208550, 0.4531895670208550, -1.106526085655485, \
0.4397732950884204, 0.4397732950884204, -1.135340816454641, \
0.4243160198749000, 0.4243160198749000, -1.168439526221691, \
0.4066046656931699, 0.4066046656931699, -1.206280765644405, \
0.3863901565540565, 0.3863901565540565, -1.249403576770582, \
0.3633780301917777, 0.3633780301917777, -1.298446803111865, \
0.3372177224742490, 0.3372177224742490, -1.354171759367345, \
0.3074893665170716, 0.3074893665170716, -1.417490130249630, \
0.2736866955245105, 0.2736866955245105, -1.489499152668544, \
0.2351935923638701, 0.2351935923638701, -1.571526669801396, \
0.1912482099764827, 0.1912482099764827, -1.665189528340305, \
0.1408715308097474, 0.1408715308097474, -1.772470122495835, \
0.08259715566815579, 0.08259715566815579, -1.895817868839552, \
0.3731829001688891, 0.3731829001688891, 0.9770705006379899, \
0.5042767798831333, 0.5042767798831333, 1.000064317842622, \
0.4965603680836179, 0.4965603680836179, 1.013234488124659, \
0.4901423447226700, 0.4901423447226700, 1.026571239104735, \
0.4830115097690691, 0.4830115097690691, 1.041998568489590, \
0.4746314928588816, 0.4746314928588816, 1.060205152697242, \
0.4647514290983590, 0.4647514290983590, 1.081599105145350, \
0.4531895670208550, 0.4531895670208550, 1.106526085655485, \
0.4397732950884204, 0.4397732950884204, 1.135340816454641, \
0.4243160198749000, 0.4243160198749000, 1.168439526221691, \
0.4066046656931699, 0.4066046656931699, 1.206280765644405, \
0.3863901565540565, 0.3863901565540565, 1.249403576770582, \
0.3633780301917777, 0.3633780301917777, 1.298446803111865, \
0.3372177224742490, 0.3372177224742490, 1.354171759367345, \
0.3074893665170716, 0.3074893665170716, 1.417490130249630, \
0.2736866955245105, 0.2736866955245105, 1.489499152668544, \
0.2351935923638701, 0.2351935923638701, 1.571526669801396, \
0.1912482099764827, 0.1912482099764827, 1.665189528340305, \
0.1408715308097474, 0.1408715308097474, 1.772470122495835, \
0.08259715566815579, 0.08259715566815579, 1.895817868839552})\"\>"], "Output",\

 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, {
   3.779359220138113*^9, 3.7793592312112217`*^9}, 3.7793594991073437`*^9, 
   3.779550313636553*^9, 3.7795914021214247`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"e40ababa-02db-4561-a574-91cf627e0d52"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["NBat = 99    Epsilond = 0 with core orbitals", "Subsection",
 CellChangeTimes->{{3.779359238625634*^9, 3.7793592709990683`*^9}, {
  3.779363175778339*^9, 
  3.7793631794730587`*^9}},ExpressionUUID->"eb9f67a5-b16b-4703-b3aa-\
3aabbbf1546e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NBath", " ", "=", " ", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Epsilond", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ncore", " ", "=", " ", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DigitsUsed", "=", "1024"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CreateImpurityHamiltonian", "[", 
  RowBox[{"NBath", ",", "Epsilond", ",", "Ncore", ",", "DigitsUsed"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.779355478187872*^9, 3.7793554943504133`*^9}, {
   3.77935557544226*^9, 3.779355580842638*^9}, {3.7793563872630177`*^9, 
   3.779356403227936*^9}, {3.7793564701969852`*^9, 3.779356482007524*^9}, {
   3.779356654013074*^9, 3.779356670260536*^9}, {3.779357613086158*^9, 
   3.779357613876479*^9}, {3.779358029370295*^9, 3.7793580295353413`*^9}, {
   3.7793581241115427`*^9, 3.7793581386914682`*^9}, {3.779358169319442*^9, 
   3.779358209735119*^9}, {3.779358260722993*^9, 3.779358335117519*^9}, {
   3.779358387675673*^9, 3.7793583943201857`*^9}, {3.779358480087029*^9, 
   3.77935848036788*^9}, {3.779358628516548*^9, 3.7793586292308407`*^9}, {
   3.7793587011281157`*^9, 3.779358720034378*^9}, {3.779358950299296*^9, 
   3.779358973665515*^9}, {3.779359068316621*^9, 3.779359107882388*^9}, {
   3.779359157281836*^9, 3.779359157715231*^9}, 3.779363182037373*^9},
 CellLabel->"In[79]:=",ExpressionUUID->"61fb91f9-b6fd-4807-ac1f-0d09456a0482"],

Cell[BoxData["\<\"HTB = NewOperator(\\\"Number\\\",NF,{6, 6, 6, 8, 8, 8, 10, \
10, 10, 10, 12, 12, 12, 14, 14, 14, 16, 16, 16, 18, 18, 18, 20, 20, 20, 22, \
22, 22, 24, 24, 24, 26, 26, 26, 28, 28, 28, 30, 30, 30, 32, 32, 32, 34, 34, \
34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, 42, 42, 44, 44, 44, 46, 46, 46, \
48, 48, 48, 50, 50, 50, 52, 52, 52, 54, 54, 54, 56, 56, 56, 58, 58, 58, 60, \
60, 60, 62, 62, 62, 64, 64, 64, 66, 66, 66, 68, 68, 68, 70, 70, 70, 72, 72, \
72, 74, 74, 74, 76, 76, 76, 78, 78, 78, 80, 80, 80, 82, 82, 82, 84, 84, 84, \
86, 86, 86, 88, 88, 88, 90, 90, 90, 92, 92, 92, 94, 94, 94, 96, 96, 96, 98, \
98, 98, 100, 100, 100, 102, 102, 102, 104, 104, 104, 106, 106, 108, 108, 108, \
108, 110, 110, 110, 112, 112, 112, 114, 114, 114, 116, 116, 116, 118, 118, \
118, 120, 120, 120, 122, 122, 122, 124, 124, 124, 126, 126, 126, 128, 128, \
128, 130, 130, 130, 132, 132, 132, 134, 134, 134, 136, 136, 136, 138, 138, \
138, 140, 140, 140, 142, 142, 142, 144, 144, 144, 146, 146, 146, 148, 148, \
148, 150, 150, 150, 152, 152, 152, 154, 154, 154, 156, 156, 156, 158, 158, \
158, 160, 160, 160, 162, 162, 162, 164, 164, 164, 166, 166, 166, 168, 168, \
168, 170, 170, 170, 172, 172, 172, 174, 174, 174, 176, 176, 176, 178, 178, \
178, 180, 180, 180, 182, 182, 182, 184, 184, 184, 186, 186, 186, 188, 188, \
188, 190, 190, 190, 192, 192, 192, 194, 194, 194, 196, 196, 196, 198, 198, \
198, 200, 200, 200, 202, 202, 202, 204, 204, 7, 7, 7, 9, 9, 9, 11, 11, 11, \
11, 13, 13, 13, 15, 15, 15, 17, 17, 17, 19, 19, 19, 21, 21, 21, 23, 23, 23, \
25, 25, 25, 27, 27, 27, 29, 29, 29, 31, 31, 31, 33, 33, 33, 35, 35, 35, 37, \
37, 37, 39, 39, 39, 41, 41, 41, 43, 43, 43, 45, 45, 45, 47, 47, 47, 49, 49, \
49, 51, 51, 51, 53, 53, 53, 55, 55, 55, 57, 57, 57, 59, 59, 59, 61, 61, 61, \
63, 63, 63, 65, 65, 65, 67, 67, 67, 69, 69, 69, 71, 71, 71, 73, 73, 73, 75, \
75, 75, 77, 77, 77, 79, 79, 79, 81, 81, 81, 83, 83, 83, 85, 85, 85, 87, 87, \
87, 89, 89, 89, 91, 91, 91, 93, 93, 93, 95, 95, 95, 97, 97, 97, 99, 99, 99, \
101, 101, 101, 103, 103, 103, 105, 105, 105, 107, 107, 109, 109, 109, 109, \
111, 111, 111, 113, 113, 113, 115, 115, 115, 117, 117, 117, 119, 119, 119, \
121, 121, 121, 123, 123, 123, 125, 125, 125, 127, 127, 127, 129, 129, 129, \
131, 131, 131, 133, 133, 133, 135, 135, 135, 137, 137, 137, 139, 139, 139, \
141, 141, 141, 143, 143, 143, 145, 145, 145, 147, 147, 147, 149, 149, 149, \
151, 151, 151, 153, 153, 153, 155, 155, 155, 157, 157, 157, 159, 159, 159, \
161, 161, 161, 163, 163, 163, 165, 165, 165, 167, 167, 167, 169, 169, 169, \
171, 171, 171, 173, 173, 173, 175, 175, 175, 177, 177, 177, 179, 179, 179, \
181, 181, 181, 183, 183, 183, 185, 185, 185, 187, 187, 187, 189, 189, 189, \
191, 191, 191, 193, 193, 193, 195, 195, 195, 197, 197, 197, 199, 199, 199, \
201, 201, 201, 203, 203, 203, 205, 205}, {8, 10, 108, 6, 10, 108, 6, 8, 10, \
12, 10, 12, 14, 12, 14, 16, 14, 16, 18, 16, 18, 20, 18, 20, 22, 20, 22, 24, \
22, 24, 26, 24, 26, 28, 26, 28, 30, 28, 30, 32, 30, 32, 34, 32, 34, 36, 34, \
36, 38, 36, 38, 40, 38, 40, 42, 40, 42, 44, 42, 44, 46, 44, 46, 48, 46, 48, \
50, 48, 50, 52, 50, 52, 54, 52, 54, 56, 54, 56, 58, 56, 58, 60, 58, 60, 62, \
60, 62, 64, 62, 64, 66, 64, 66, 68, 66, 68, 70, 68, 70, 72, 70, 72, 74, 72, \
74, 76, 74, 76, 78, 76, 78, 80, 78, 80, 82, 80, 82, 84, 82, 84, 86, 84, 86, \
88, 86, 88, 90, 88, 90, 92, 90, 92, 94, 92, 94, 96, 94, 96, 98, 96, 98, 100, \
98, 100, 102, 100, 102, 104, 102, 104, 106, 104, 106, 6, 8, 108, 110, 108, \
110, 112, 110, 112, 114, 112, 114, 116, 114, 116, 118, 116, 118, 120, 118, \
120, 122, 120, 122, 124, 122, 124, 126, 124, 126, 128, 126, 128, 130, 128, \
130, 132, 130, 132, 134, 132, 134, 136, 134, 136, 138, 136, 138, 140, 138, \
140, 142, 140, 142, 144, 142, 144, 146, 144, 146, 148, 146, 148, 150, 148, \
150, 152, 150, 152, 154, 152, 154, 156, 154, 156, 158, 156, 158, 160, 158, \
160, 162, 160, 162, 164, 162, 164, 166, 164, 166, 168, 166, 168, 170, 168, \
170, 172, 170, 172, 174, 172, 174, 176, 174, 176, 178, 176, 178, 180, 178, \
180, 182, 180, 182, 184, 182, 184, 186, 184, 186, 188, 186, 188, 190, 188, \
190, 192, 190, 192, 194, 192, 194, 196, 194, 196, 198, 196, 198, 200, 198, \
200, 202, 200, 202, 204, 202, 204, 9, 11, 109, 7, 11, 109, 7, 9, 11, 13, 11, \
13, 15, 13, 15, 17, 15, 17, 19, 17, 19, 21, 19, 21, 23, 21, 23, 25, 23, 25, \
27, 25, 27, 29, 27, 29, 31, 29, 31, 33, 31, 33, 35, 33, 35, 37, 35, 37, 39, \
37, 39, 41, 39, 41, 43, 41, 43, 45, 43, 45, 47, 45, 47, 49, 47, 49, 51, 49, \
51, 53, 51, 53, 55, 53, 55, 57, 55, 57, 59, 57, 59, 61, 59, 61, 63, 61, 63, \
65, 63, 65, 67, 65, 67, 69, 67, 69, 71, 69, 71, 73, 71, 73, 75, 73, 75, 77, \
75, 77, 79, 77, 79, 81, 79, 81, 83, 81, 83, 85, 83, 85, 87, 85, 87, 89, 87, \
89, 91, 89, 91, 93, 91, 93, 95, 93, 95, 97, 95, 97, 99, 97, 99, 101, 99, 101, \
103, 101, 103, 105, 103, 105, 107, 105, 107, 7, 9, 109, 111, 109, 111, 113, \
111, 113, 115, 113, 115, 117, 115, 117, 119, 117, 119, 121, 119, 121, 123, \
121, 123, 125, 123, 125, 127, 125, 127, 129, 127, 129, 131, 129, 131, 133, \
131, 133, 135, 133, 135, 137, 135, 137, 139, 137, 139, 141, 139, 141, 143, \
141, 143, 145, 143, 145, 147, 145, 147, 149, 147, 149, 151, 149, 151, 153, \
151, 153, 155, 153, 155, 157, 155, 157, 159, 157, 159, 161, 159, 161, 163, \
161, 163, 165, 163, 165, 167, 165, 167, 169, 167, 169, 171, 169, 171, 173, \
171, 173, 175, 173, 175, 177, 175, 177, 179, 177, 179, 181, 179, 181, 183, \
181, 183, 185, 183, 185, 187, 185, 187, 189, 187, 189, 191, 189, 191, 193, \
191, 193, 195, 193, 195, 197, 195, 197, 199, 197, 199, 201, 199, 201, 203, \
201, 203, 205, 203, 205},{-0.8489290398016424, 0.3737107741164692, \
0.3737107741164692, -0.8489290398016424, 0.3737107741164692, \
-0.3737107741164692, 0.3737107741164692, 0.3737107741164692, \
-0.9740482257320762, 0.5068368984266726, 0.5068368984266726, \
-0.9922931542259100, 0.5020630844692045, 0.5020630844692045, \
-0.9984181150287332, 0.4997594140104044, 0.4997594140104044, \
-1.002317277554051, 0.4979692462624301, 0.4979692462624301, \
-1.005787703753603, 0.4962285205609439, 0.4962285205609439, \
-1.009354784949573, 0.4943778628396333, 0.4943778628396333, \
-1.013223137837993, 0.4923484262750797, 0.4923484262750797, \
-1.017489437291571, 0.4901049259970967, 0.4901049259970967, \
-1.022207163760450, 0.4876263513806559, 0.4876263513806559, \
-1.027410521667359, 0.4848983002345396, 0.4848983002345396, \
-1.033124559410564, 0.4819095529293429, 0.4819095529293429, \
-1.039369917081812, 0.4786503929780709, 0.4786503929780709, \
-1.046165249731204, 0.4751117167825077, 0.4751117167825077, \
-1.053528559146478, 0.4712845268145902, 0.4712845268145902, \
-1.061477978999492, 0.4671596220321726, 0.4671596220321726, \
-1.070032272158246, 0.4627273942463138, 0.4627273942463138, \
-1.079211170794960, 0.4579776830912797, 0.4579776830912797, \
-1.089035628804926, 0.4528996637780211, 0.4528996637780211, \
-1.099528025339815, 0.4474817528829836, 0.4474817528829836, \
-1.110712342127858, 0.4417115233527582, 0.4417115233527582, \
-1.122614328460667, 0.4355756231875203, 0.4355756231875203, \
-1.135261662789283, 0.4290596941304002, 0.4290596941304002, \
-1.148684117040381, 0.4221482877649873, 0.4221482877649873, \
-1.162913728124270, 0.4148247770429612, 0.4148247770429612, \
-1.177984980166640, 0.4070712616109387, 0.4070712616109387, \
-1.193935000482767, 0.3988684654823032, 0.3988684654823032, \
-1.210803772070887, 0.3901956256641870, 0.3901956256641870, \
-1.228634365341495, 0.3810303703349336, 0.3810303703349336, \
-1.247473191869689, 0.3713485850913122, 0.3713485850913122, \
-1.267370283129243, 0.3611242656559930, 0.3611242656559930, \
-1.288379597424376, 0.3503293552559101, 0.3503293552559101, \
-1.310559358571624, 0.3389335646467524, 0.3389335646467524, \
-1.333972430299457, 0.3269041724568382, 0.3269041724568382, \
-1.358686730831517, 0.3142058031346098, 0.3142058031346098, \
-1.384775692708616, 0.3008001792722893, 0.3008001792722893, \
-1.412318773596494, 0.2866458443809318, 0.2866458443809318, \
-1.441402024636008, 0.2716978511938388, 0.2716978511938388, \
-1.472118723838765, 0.2559074090540809, 0.2559074090540809, \
-1.504570083137827, 0.2392214814462007, 0.2392214814462007, \
-1.538866038998353, 0.2215823202854082, 0.2215823202854082, \
-1.575126138011842, 0.2029269149163467, 0.2029269149163467, \
-1.613480530681994, 0.1831863152179508, 0.1831863152179508, \
-1.654071088711601, 0.1622847440932148, 0.1622847440932148, \
-1.697052663580693, 0.1401382963804420, 0.1401382963804420, \
-1.742594507142841, 0.1166526540358445, 0.1166526540358445, \
-1.790881878452591, 0.09171786023148453, 0.09171786023148453, \
-1.842117865187462, 0.06519119401934156, 0.06519119401934156, \
-1.896525452984524, 0.03680013143341261, 0.03680013143341261, \
-1.954349881949963, 0.3737107741164692, -0.3737107741164692, \
0.9740482257320762, 0.5068368984266726, 0.5068368984266726, \
0.9922931542259100, 0.5020630844692045, 0.5020630844692045, \
0.9984181150287332, 0.4997594140104044, 0.4997594140104044, \
1.002317277554051, 0.4979692462624301, 0.4979692462624301, 1.005787703753603, \
0.4962285205609439, 0.4962285205609439, 1.009354784949573, \
0.4943778628396333, 0.4943778628396333, 1.013223137837993, \
0.4923484262750797, 0.4923484262750797, 1.017489437291571, \
0.4901049259970967, 0.4901049259970967, 1.022207163760450, \
0.4876263513806559, 0.4876263513806559, 1.027410521667359, \
0.4848983002345396, 0.4848983002345396, 1.033124559410564, \
0.4819095529293429, 0.4819095529293429, 1.039369917081812, \
0.4786503929780709, 0.4786503929780709, 1.046165249731204, \
0.4751117167825077, 0.4751117167825077, 1.053528559146478, \
0.4712845268145902, 0.4712845268145902, 1.061477978999492, \
0.4671596220321726, 0.4671596220321726, 1.070032272158246, \
0.4627273942463138, 0.4627273942463138, 1.079211170794960, \
0.4579776830912797, 0.4579776830912797, 1.089035628804926, \
0.4528996637780211, 0.4528996637780211, 1.099528025339815, \
0.4474817528829836, 0.4474817528829836, 1.110712342127858, \
0.4417115233527582, 0.4417115233527582, 1.122614328460667, \
0.4355756231875203, 0.4355756231875203, 1.135261662789283, \
0.4290596941304002, 0.4290596941304002, 1.148684117040381, \
0.4221482877649873, 0.4221482877649873, 1.162913728124270, \
0.4148247770429612, 0.4148247770429612, 1.177984980166640, \
0.4070712616109387, 0.4070712616109387, 1.193935000482767, \
0.3988684654823032, 0.3988684654823032, 1.210803772070887, \
0.3901956256641870, 0.3901956256641870, 1.228634365341495, \
0.3810303703349336, 0.3810303703349336, 1.247473191869689, \
0.3713485850913122, 0.3713485850913122, 1.267370283129243, \
0.3611242656559930, 0.3611242656559930, 1.288379597424376, \
0.3503293552559101, 0.3503293552559101, 1.310559358571624, \
0.3389335646467524, 0.3389335646467524, 1.333972430299457, \
0.3269041724568382, 0.3269041724568382, 1.358686730831517, \
0.3142058031346098, 0.3142058031346098, 1.384775692708616, \
0.3008001792722893, 0.3008001792722893, 1.412318773596494, \
0.2866458443809318, 0.2866458443809318, 1.441402024636008, \
0.2716978511938388, 0.2716978511938388, 1.472118723838765, \
0.2559074090540809, 0.2559074090540809, 1.504570083137827, \
0.2392214814462007, 0.2392214814462007, 1.538866038998353, \
0.2215823202854082, 0.2215823202854082, 1.575126138011842, \
0.2029269149163467, 0.2029269149163467, 1.613480530681994, \
0.1831863152179508, 0.1831863152179508, 1.654071088711601, \
0.1622847440932148, 0.1622847440932148, 1.697052663580693, \
0.1401382963804420, 0.1401382963804420, 1.742594507142841, \
0.1166526540358445, 0.1166526540358445, 1.790881878452591, \
0.09171786023148453, 0.09171786023148453, 1.842117865187462, \
0.06519119401934156, 0.06519119401934156, 1.896525452984524, \
0.03680013143341261, 0.03680013143341261, 1.954349881949963, \
-0.8489290398016424, 0.3737107741164692, 0.3737107741164692, \
-0.8489290398016424, 0.3737107741164692, -0.3737107741164692, \
0.3737107741164692, 0.3737107741164692, -0.9740482257320762, \
0.5068368984266726, 0.5068368984266726, -0.9922931542259100, \
0.5020630844692045, 0.5020630844692045, -0.9984181150287332, \
0.4997594140104044, 0.4997594140104044, -1.002317277554051, \
0.4979692462624301, 0.4979692462624301, -1.005787703753603, \
0.4962285205609439, 0.4962285205609439, -1.009354784949573, \
0.4943778628396333, 0.4943778628396333, -1.013223137837993, \
0.4923484262750797, 0.4923484262750797, -1.017489437291571, \
0.4901049259970967, 0.4901049259970967, -1.022207163760450, \
0.4876263513806559, 0.4876263513806559, -1.027410521667359, \
0.4848983002345396, 0.4848983002345396, -1.033124559410564, \
0.4819095529293429, 0.4819095529293429, -1.039369917081812, \
0.4786503929780709, 0.4786503929780709, -1.046165249731204, \
0.4751117167825077, 0.4751117167825077, -1.053528559146478, \
0.4712845268145902, 0.4712845268145902, -1.061477978999492, \
0.4671596220321726, 0.4671596220321726, -1.070032272158246, \
0.4627273942463138, 0.4627273942463138, -1.079211170794960, \
0.4579776830912797, 0.4579776830912797, -1.089035628804926, \
0.4528996637780211, 0.4528996637780211, -1.099528025339815, \
0.4474817528829836, 0.4474817528829836, -1.110712342127858, \
0.4417115233527582, 0.4417115233527582, -1.122614328460667, \
0.4355756231875203, 0.4355756231875203, -1.135261662789283, \
0.4290596941304002, 0.4290596941304002, -1.148684117040381, \
0.4221482877649873, 0.4221482877649873, -1.162913728124270, \
0.4148247770429612, 0.4148247770429612, -1.177984980166640, \
0.4070712616109387, 0.4070712616109387, -1.193935000482767, \
0.3988684654823032, 0.3988684654823032, -1.210803772070887, \
0.3901956256641870, 0.3901956256641870, -1.228634365341495, \
0.3810303703349336, 0.3810303703349336, -1.247473191869689, \
0.3713485850913122, 0.3713485850913122, -1.267370283129243, \
0.3611242656559930, 0.3611242656559930, -1.288379597424376, \
0.3503293552559101, 0.3503293552559101, -1.310559358571624, \
0.3389335646467524, 0.3389335646467524, -1.333972430299457, \
0.3269041724568382, 0.3269041724568382, -1.358686730831517, \
0.3142058031346098, 0.3142058031346098, -1.384775692708616, \
0.3008001792722893, 0.3008001792722893, -1.412318773596494, \
0.2866458443809318, 0.2866458443809318, -1.441402024636008, \
0.2716978511938388, 0.2716978511938388, -1.472118723838765, \
0.2559074090540809, 0.2559074090540809, -1.504570083137827, \
0.2392214814462007, 0.2392214814462007, -1.538866038998353, \
0.2215823202854082, 0.2215823202854082, -1.575126138011842, \
0.2029269149163467, 0.2029269149163467, -1.613480530681994, \
0.1831863152179508, 0.1831863152179508, -1.654071088711601, \
0.1622847440932148, 0.1622847440932148, -1.697052663580693, \
0.1401382963804420, 0.1401382963804420, -1.742594507142841, \
0.1166526540358445, 0.1166526540358445, -1.790881878452591, \
0.09171786023148453, 0.09171786023148453, -1.842117865187462, \
0.06519119401934156, 0.06519119401934156, -1.896525452984524, \
0.03680013143341261, 0.03680013143341261, -1.954349881949963, \
0.3737107741164692, -0.3737107741164692, 0.9740482257320762, \
0.5068368984266726, 0.5068368984266726, 0.9922931542259100, \
0.5020630844692045, 0.5020630844692045, 0.9984181150287332, \
0.4997594140104044, 0.4997594140104044, 1.002317277554051, \
0.4979692462624301, 0.4979692462624301, 1.005787703753603, \
0.4962285205609439, 0.4962285205609439, 1.009354784949573, \
0.4943778628396333, 0.4943778628396333, 1.013223137837993, \
0.4923484262750797, 0.4923484262750797, 1.017489437291571, \
0.4901049259970967, 0.4901049259970967, 1.022207163760450, \
0.4876263513806559, 0.4876263513806559, 1.027410521667359, \
0.4848983002345396, 0.4848983002345396, 1.033124559410564, \
0.4819095529293429, 0.4819095529293429, 1.039369917081812, \
0.4786503929780709, 0.4786503929780709, 1.046165249731204, \
0.4751117167825077, 0.4751117167825077, 1.053528559146478, \
0.4712845268145902, 0.4712845268145902, 1.061477978999492, \
0.4671596220321726, 0.4671596220321726, 1.070032272158246, \
0.4627273942463138, 0.4627273942463138, 1.079211170794960, \
0.4579776830912797, 0.4579776830912797, 1.089035628804926, \
0.4528996637780211, 0.4528996637780211, 1.099528025339815, \
0.4474817528829836, 0.4474817528829836, 1.110712342127858, \
0.4417115233527582, 0.4417115233527582, 1.122614328460667, \
0.4355756231875203, 0.4355756231875203, 1.135261662789283, \
0.4290596941304002, 0.4290596941304002, 1.148684117040381, \
0.4221482877649873, 0.4221482877649873, 1.162913728124270, \
0.4148247770429612, 0.4148247770429612, 1.177984980166640, \
0.4070712616109387, 0.4070712616109387, 1.193935000482767, \
0.3988684654823032, 0.3988684654823032, 1.210803772070887, \
0.3901956256641870, 0.3901956256641870, 1.228634365341495, \
0.3810303703349336, 0.3810303703349336, 1.247473191869689, \
0.3713485850913122, 0.3713485850913122, 1.267370283129243, \
0.3611242656559930, 0.3611242656559930, 1.288379597424376, \
0.3503293552559101, 0.3503293552559101, 1.310559358571624, \
0.3389335646467524, 0.3389335646467524, 1.333972430299457, \
0.3269041724568382, 0.3269041724568382, 1.358686730831517, \
0.3142058031346098, 0.3142058031346098, 1.384775692708616, \
0.3008001792722893, 0.3008001792722893, 1.412318773596494, \
0.2866458443809318, 0.2866458443809318, 1.441402024636008, \
0.2716978511938388, 0.2716978511938388, 1.472118723838765, \
0.2559074090540809, 0.2559074090540809, 1.504570083137827, \
0.2392214814462007, 0.2392214814462007, 1.538866038998353, \
0.2215823202854082, 0.2215823202854082, 1.575126138011842, \
0.2029269149163467, 0.2029269149163467, 1.613480530681994, \
0.1831863152179508, 0.1831863152179508, 1.654071088711601, \
0.1622847440932148, 0.1622847440932148, 1.697052663580693, \
0.1401382963804420, 0.1401382963804420, 1.742594507142841, \
0.1166526540358445, 0.1166526540358445, 1.790881878452591, \
0.09171786023148453, 0.09171786023148453, 1.842117865187462, \
0.06519119401934156, 0.06519119401934156, 1.896525452984524, \
0.03680013143341261, 0.03680013143341261, 1.954349881949963})\"\>"], "Output",\

 CellChangeTimes->{{3.779356404045822*^9, 3.7793564828063726`*^9}, {
   3.779356590664727*^9, 3.77935660845065*^9}, {3.779356640354384*^9, 
   3.779356671126733*^9}, 3.779356757200067*^9, 3.779357614738903*^9, 
   3.779358030371457*^9, {3.779358143102496*^9, 3.779358217727697*^9}, 
   3.779358262319421*^9, {3.779358296888651*^9, 3.779358328478388*^9}, {
   3.7793583778059263`*^9, 3.779358391164818*^9}, 3.779358459630886*^9, 
   3.779358502860091*^9, {3.779358614200708*^9, 3.779358635894579*^9}, {
   3.7793587015368643`*^9, 3.779358721094989*^9}, 3.779358760194491*^9, 
   3.7793588174425573`*^9, {3.7793589410992203`*^9, 3.7793589818573313`*^9}, {
   3.779359077807398*^9, 3.779359103473177*^9}, 3.779359153855007*^9, 
   3.779359220138113*^9, 3.779359567962748*^9, 3.779363249670315*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"66b2aa2d-0904-40f3-b10f-2060e905f322"]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
WindowSize->{991, 842},
WindowMargins->{{97, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 180, 3, 67, "Section",ExpressionUUID->"2b8eb12d-5629-4f5b-a078-2b8e5ffa1628"],
Cell[763, 27, 406, 8, 58, "Text",ExpressionUUID->"24d7cc16-da0a-4d49-85f3-2851555126e6"],
Cell[1172, 37, 231, 6, 35, "Text",ExpressionUUID->"fab746cb-3562-492c-a799-c12ca5c45ece"],
Cell[1406, 45, 221, 3, 30, "Input",ExpressionUUID->"1ee448e0-9ec8-40e5-a42f-ba0f36b2d1a5"],
Cell[1630, 50, 992, 26, 81, "Text",ExpressionUUID->"9d1eca54-2f2f-44e6-b3a3-a042115fb6e1"],
Cell[2625, 78, 2044, 54, 176, "Input",ExpressionUUID->"3a5a9429-75fb-48c2-bc6a-7d254eee32ad"],
Cell[4672, 134, 285, 6, 35, "Text",ExpressionUUID->"8d0de52b-7de9-4978-bc89-86cba72e200f"],
Cell[4960, 142, 3356, 79, 283, "Input",ExpressionUUID->"5f27b6dc-ccf0-4d4f-9713-d0dd1b81c199"],
Cell[CellGroupData[{
Cell[8341, 225, 174, 3, 54, "Subsection",ExpressionUUID->"88437b74-a9c5-43f9-9fec-4e344d75dbb4"],
Cell[CellGroupData[{
Cell[8540, 232, 1441, 24, 115, "Input",ExpressionUUID->"f3d6a97e-aa14-4831-ba44-c3554e992cd3"],
Cell[9984, 258, 1954, 28, 224, "Output",ExpressionUUID->"198e146b-2936-432e-99bc-721e17f89286"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11987, 292, 226, 4, 38, "Subsection",ExpressionUUID->"8e6b12de-568b-4f7e-a3b8-9f535636c664"],
Cell[CellGroupData[{
Cell[12238, 300, 1495, 25, 115, "Input",ExpressionUUID->"db533497-82d9-4992-ad7e-b0e92d1681a4"],
Cell[13736, 327, 3017, 43, 434, "Output",ExpressionUUID->"17dbf7e6-f34c-4ab0-b602-05924538fb5b"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16802, 376, 224, 4, 38, "Subsection",ExpressionUUID->"71c81e8d-79ff-4356-aff5-38189922f9d1"],
Cell[CellGroupData[{
Cell[17051, 384, 1495, 25, 115, "Input",ExpressionUUID->"9c41c71a-afcd-44cd-92b9-7fdfb452d7d9"],
Cell[18549, 411, 4715, 70, 791, "Output",ExpressionUUID->"282dce97-9d4b-4475-89d0-3f7ccb0b8ed0"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23313, 487, 224, 4, 38, "Subsection",ExpressionUUID->"2d3dfb5a-dace-4290-a63d-dd40b5979295"],
Cell[CellGroupData[{
Cell[23562, 495, 1490, 25, 115, "Input",ExpressionUUID->"bb706788-4e2c-42c4-a08a-6fa2cbf9c839"],
Cell[25055, 522, 8169, 123, 1505, "Output",ExpressionUUID->"9521ef2f-120f-4c57-ab40-45164323bbd9"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33273, 651, 175, 3, 38, "Subsection",ExpressionUUID->"d85708b3-fe01-41a0-8c6e-a2c3cce20c69"],
Cell[CellGroupData[{
Cell[33473, 658, 1409, 24, 115, "Input",ExpressionUUID->"3fee9fdb-44e8-400a-9aee-4f6cc93b90eb"],
Cell[34885, 684, 18747, 283, 3689, "Output",ExpressionUUID->"b255ec70-5281-450e-b1ac-2b12a146ec3b"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53681, 973, 176, 3, 38, "Subsection",ExpressionUUID->"b4d2f851-cedd-460e-b4c6-3b50dae401b8"],
Cell[CellGroupData[{
Cell[53882, 980, 1480, 26, 115, "Input",ExpressionUUID->"5917ceb5-6449-4f59-bb2e-faa704c96178"],
Cell[55365, 1008, 18883, 284, 4592, "Output",ExpressionUUID->"fdc3d5f5-8772-435d-befc-d598a9044008"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74297, 1298, 225, 4, 38, "Subsection",ExpressionUUID->"a08b710a-e53b-464a-bb92-6d5254e6117e"],
Cell[CellGroupData[{
Cell[74547, 1306, 1514, 26, 115, "Input",ExpressionUUID->"6eaa768e-9e23-47a6-858d-1662f056e4cf"],
Cell[76064, 1334, 18881, 284, 4592, "Output",ExpressionUUID->"a9b7c7ad-c5a1-422a-84f0-7bb5f47bd40c"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[94994, 1624, 225, 4, 38, "Subsection",ExpressionUUID->"52c2ca07-d3c9-484c-8e9f-ad58ca1e9186"],
Cell[CellGroupData[{
Cell[95244, 1632, 1514, 26, 115, "Input",ExpressionUUID->"88838bec-fd1e-4320-aabd-86518dde8792"],
Cell[96761, 1660, 18879, 284, 4592, "Output",ExpressionUUID->"5ec5f741-2d09-4348-99c2-de96576ee499"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[115689, 1950, 196, 3, 38, "Subsection",ExpressionUUID->"6343f24b-fca0-448a-86aa-056e6ef8eb2e"],
Cell[CellGroupData[{
Cell[115910, 1957, 1512, 26, 115, "Input",ExpressionUUID->"4741c6a3-65a6-4595-8929-1f1e1d1b996d"],
Cell[117425, 1985, 18879, 284, 4592, "Output",ExpressionUUID->"bbe34063-b062-4da1-8278-bfb37f6f40a4"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[136353, 2275, 197, 3, 38, "Subsection",ExpressionUUID->"6ba9f7cf-03b3-440e-88ba-52711f5e1f4c"],
Cell[CellGroupData[{
Cell[136575, 2282, 1512, 26, 115, "Input",ExpressionUUID->"334a50b6-1319-4878-b941-a2878d62fc3a"],
Cell[138090, 2310, 18881, 284, 4592, "Output",ExpressionUUID->"2835351b-48a2-4595-8a0e-b07d4d344697"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[157020, 2600, 197, 3, 38, "Subsection",ExpressionUUID->"d471b476-d82c-4a70-9862-9bfde319678d"],
Cell[CellGroupData[{
Cell[157242, 2607, 1512, 26, 115, "Input",ExpressionUUID->"16088a9f-b657-48fc-aacd-1509f1205c7a"],
Cell[158757, 2635, 18883, 284, 4592, "Output",ExpressionUUID->"2a0da20b-a886-4f31-8277-d920cbd8599c"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[177689, 2925, 197, 3, 38, "Subsection",ExpressionUUID->"8e0aaf75-9b18-4d2d-8dcd-3bafd2df6b4c"],
Cell[CellGroupData[{
Cell[177911, 2932, 1514, 26, 115, "Input",ExpressionUUID->"08e3dc48-6400-4aa3-8b65-f600bca13390"],
Cell[179428, 2960, 18887, 284, 4592, "Output",ExpressionUUID->"7e809dfe-622e-461a-a5e8-4d1623b626da"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[198364, 3250, 197, 3, 38, "Subsection",ExpressionUUID->"af405e26-d093-41c2-ab4e-bcf2849b819d"],
Cell[CellGroupData[{
Cell[198586, 3257, 1514, 26, 115, "Input",ExpressionUUID->"94a00175-135d-400d-b020-2950e3fe4142"],
Cell[200103, 3285, 18891, 284, 4592, "Output",ExpressionUUID->"556e76bd-1ffa-4383-a3d0-4bd6f902cff6"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[219043, 3575, 197, 3, 38, "Subsection",ExpressionUUID->"6b73f7b4-75c8-4787-aacd-c1a43b6dcc3a"],
Cell[CellGroupData[{
Cell[219265, 3582, 1512, 26, 115, "Input",ExpressionUUID->"77939a13-86f3-4830-92a7-19a774f9d348"],
Cell[220780, 3610, 18893, 284, 4592, "Output",ExpressionUUID->"a4a7f762-d2c1-4929-b62c-0e09a6210e2f"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[239722, 3900, 197, 3, 38, "Subsection",ExpressionUUID->"6c20a027-702c-4884-a069-60fe4684f42a"],
Cell[CellGroupData[{
Cell[239944, 3907, 1512, 26, 115, "Input",ExpressionUUID->"4aeba750-76e2-45aa-8618-58e286c75a0c"],
Cell[241459, 3935, 18890, 284, 4592, "Output",ExpressionUUID->"41890aad-7341-40c2-bbc3-d8d907d3ad26"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[260398, 4225, 197, 3, 38, "Subsection",ExpressionUUID->"e5205a1a-4402-4781-98a5-9e3a17fe87a3"],
Cell[CellGroupData[{
Cell[260620, 4232, 1514, 26, 115, "Input",ExpressionUUID->"27465fc7-3b4b-47b0-9664-984f3abc7782"],
Cell[262137, 4260, 18891, 284, 4592, "Output",ExpressionUUID->"a6f912da-21ca-4d34-8159-c071090d6f60"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[281077, 4550, 225, 4, 38, "Subsection",ExpressionUUID->"b06620ef-ef21-40c3-9615-ab3a8adea170"],
Cell[CellGroupData[{
Cell[281327, 4558, 1512, 26, 115, "Input",ExpressionUUID->"189d329e-4566-4ef9-aa59-7ab23c8e4aea"],
Cell[282842, 4586, 18891, 284, 4592, "Output",ExpressionUUID->"6f80e5c2-c60d-444b-afc1-9e46c3169add"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[301782, 4876, 224, 4, 38, "Subsection",ExpressionUUID->"436b62c4-53ce-4c50-bfb2-37e3758aaff9"],
Cell[CellGroupData[{
Cell[302031, 4884, 952, 21, 115, "Input",ExpressionUUID->"e1717882-8c7d-4c97-8bb1-8374dfde073e"],
Cell[302986, 4907, 18891, 284, 4592, "Output",ExpressionUUID->"e8324558-d0e1-4b35-b5d8-8856db9aeba6"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[321926, 5197, 244, 4, 38, "Subsection",ExpressionUUID->"6113eb02-8060-4c8c-a064-9cd95b00c76c"],
Cell[CellGroupData[{
Cell[322195, 5205, 1468, 25, 115, "Input",ExpressionUUID->"c3a5240e-67c3-4331-9889-06aa10799b1a"],
Cell[323666, 5232, 2019, 28, 279, "Output",ExpressionUUID->"eb6d350d-3702-4b06-b1d2-9389b7c3b873"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[325734, 5266, 291, 4, 38, "Subsection",ExpressionUUID->"738a77ba-22ff-4778-a9a6-d1ad655b6edb"],
Cell[CellGroupData[{
Cell[326050, 5274, 1517, 25, 115, "Input",ExpressionUUID->"8305051e-73d0-4ea1-8b58-277ac14386b6"],
Cell[327570, 5301, 3083, 44, 489, "Output",ExpressionUUID->"e78d8873-df75-4bb3-a286-01e24bdaf9c5"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[330702, 5351, 293, 4, 38, "Subsection",ExpressionUUID->"58fdff1a-c040-4df7-956d-b5df9588dacc"],
Cell[CellGroupData[{
Cell[331020, 5359, 1517, 25, 115, "Input",ExpressionUUID->"f16dfe66-26c6-4c68-bfa0-18c7186b9925"],
Cell[332540, 5386, 4777, 70, 812, "Output",ExpressionUUID->"d0f9327c-0996-433b-92d7-ca3d2b54850d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[337366, 5462, 291, 4, 38, "Subsection",ExpressionUUID->"4857a49a-9aff-4d65-b9b4-9c9f67c6b27d"],
Cell[CellGroupData[{
Cell[337682, 5470, 1512, 25, 115, "Input",ExpressionUUID->"cee78fb8-626e-4b2f-bf0c-2de284d48e87"],
Cell[339197, 5497, 8235, 124, 1526, "Output",ExpressionUUID->"e40ababa-02db-4561-a574-91cf627e0d52"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[347481, 5627, 245, 4, 38, "Subsection",ExpressionUUID->"eb9f67a5-b16b-4703-b3aa-3aabbbf1546e"],
Cell[CellGroupData[{
Cell[347751, 5635, 1443, 24, 115, "Input",ExpressionUUID->"61fb91f9-b6fd-4807-ac1f-0d09456a0482"],
Cell[349197, 5661, 18847, 284, 3710, "Output",ExpressionUUID->"66b2aa2d-0904-40f3-b10f-2060e905f322"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

